/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.schemabuilder;

import com.datastax.driver.core.DataType;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import info.archinnov.achilles.schemabuilder.SchemaStatement;
import info.archinnov.achilles.schemabuilder.TableOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;

public class Create
extends SchemaStatement {
    private Optional<String> keyspaceName = Optional.absent();
    private String tableName;
    private Optional<Boolean> ifNotExists = Optional.absent();
    private Map<String, DataType> partitionColumnsMap = new LinkedHashMap<String, DataType>();
    private Map<String, DataType> clusteringColumnsMap = new LinkedHashMap<String, DataType>();
    private Map<String, DataType> simpleColumnsMap = new LinkedHashMap<String, DataType>();
    private Map<String, DataType> staticColumnsMap = new LinkedHashMap<String, DataType>();

    Create(String keyspaceName, String tableName) {
        Create.validateNotEmpty(keyspaceName, "Keyspace name");
        Create.validateNotEmpty(tableName, "Table name");
        Create.validateNotKeyWord(keyspaceName, String.format("The keyspace name '%s' is not allowed because it is a reserved keyword", keyspaceName));
        Create.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.tableName = tableName;
        this.keyspaceName = Optional.fromNullable((Object)keyspaceName);
    }

    Create(String tableName) {
        Create.validateNotEmpty(tableName, "Table name");
        Create.validateNotKeyWord(tableName, String.format("The table name '%s' is not allowed because it is a reserved keyword", tableName));
        this.tableName = tableName;
    }

    public Create ifNotExists(Boolean ifNotExists) {
        this.ifNotExists = Optional.fromNullable((Object)ifNotExists);
        return this;
    }

    public Create addPartitionKey(String columnName, DataType dataType) {
        Create.validateNotEmpty(this.tableName, "Partition key name");
        Create.validateNotNull(dataType, "Partition key type");
        Create.validateNotKeyWord(columnName, String.format("The partition key name '%s' is not allowed because it is a reserved keyword", columnName));
        this.partitionColumnsMap.put(columnName, dataType);
        return this;
    }

    public Create addClusteringKey(String columnName, DataType dataType) {
        Create.validateNotEmpty(this.tableName, "Clustering key name");
        Create.validateNotNull(dataType, "Clustering key type");
        Create.validateNotKeyWord(columnName, String.format("The clustering key name '%s' is not allowed because it is a reserved keyword", columnName));
        this.clusteringColumnsMap.put(columnName, dataType);
        return this;
    }

    public Create addColumn(String columnName, DataType dataType) {
        Create.validateNotEmpty(this.tableName, "Column name");
        Create.validateNotNull(dataType, "Column type");
        Create.validateNotKeyWord(columnName, String.format("The column name '%s' is not allowed because it is a reserved keyword", columnName));
        this.simpleColumnsMap.put(columnName, dataType);
        return this;
    }

    public Create addColumn(String columnName, DataType dataType, boolean isStatic) {
        if (isStatic) {
            this.addStaticColumn(columnName, dataType);
        } else {
            this.addColumn(columnName, dataType);
        }
        return this;
    }

    public Create addStaticColumn(String columnName, DataType dataType) {
        Create.validateNotEmpty(this.tableName, "Column name");
        Create.validateNotNull(dataType, "Column type");
        Create.validateNotKeyWord(columnName, String.format("The static column name '%s' is not allowed because it is a reserved keyword", columnName));
        this.staticColumnsMap.put(columnName, dataType);
        return this;
    }

    public Options withOptions() {
        return new Options(this);
    }

    @Override
    String buildInternal() {
        StringBuilder column;
        if (this.partitionColumnsMap.size() < 1) {
            throw new IllegalStateException(String.format("There should be at least one partition key defined for the table '%s'", this.tableName));
        }
        this.validateColumnsDeclaration();
        StringBuilder createStatement = new StringBuilder("\n").append("\t").append("CREATE TABLE");
        if (this.ifNotExists.isPresent() && ((Boolean)this.ifNotExists.get()).booleanValue()) {
            createStatement.append(" ").append("IF NOT EXISTS");
        }
        createStatement.append(" ");
        if (this.keyspaceName.isPresent()) {
            createStatement.append((String)this.keyspaceName.get()).append(".");
        }
        createStatement.append(this.tableName);
        ArrayList<String> allColumns = new ArrayList<String>();
        ArrayList<String> partitionKeyColumns = new ArrayList<String>();
        ArrayList<String> clusteringKeyColumns = new ArrayList<String>();
        for (Map.Entry<String, DataType> entry : this.partitionColumnsMap.entrySet()) {
            allColumns.add(entry.getKey() + " " + entry.getValue().getName().toString());
            partitionKeyColumns.add(entry.getKey());
        }
        for (Map.Entry<String, DataType> entry : this.clusteringColumnsMap.entrySet()) {
            allColumns.add(entry.getKey() + " " + entry.getValue().getName().toString());
            clusteringKeyColumns.add(entry.getKey());
        }
        for (Map.Entry<String, DataType> entry : this.staticColumnsMap.entrySet()) {
            column = new StringBuilder();
            this.buildColumnType(entry, column);
            column.append(" ").append("static");
            allColumns.add(column.toString());
        }
        for (Map.Entry<String, DataType> entry : this.simpleColumnsMap.entrySet()) {
            column = new StringBuilder();
            this.buildColumnType(entry, column);
            allColumns.add(column.toString());
        }
        String partitionKeyPart = partitionKeyColumns.size() == 1 ? (String)partitionKeyColumns.get(0) : "(" + Joiner.on((String)", ").join(partitionKeyColumns) + ")";
        String primaryKeyPart = clusteringKeyColumns.size() == 0 ? partitionKeyPart : partitionKeyPart + ", " + Joiner.on((String)", ").join(clusteringKeyColumns);
        createStatement.append("(").append("\n").append("\t").append("\t");
        createStatement.append(Joiner.on((String)",\n\t\t").join(allColumns));
        createStatement.append(",\n\t\t").append("PRIMARY KEY");
        createStatement.append("(").append(primaryKeyPart).append(")");
        createStatement.append(")");
        return createStatement.toString();
    }

    private void buildColumnType(Map.Entry<String, DataType> entry, StringBuilder column) {
        DataType dataType = entry.getValue();
        String type = dataType.getName().toString();
        column.append(entry.getKey()).append(" ").append(type);
        if (dataType.isCollection()) {
            List typeArguments = dataType.getTypeArguments();
            if (typeArguments.size() == 1) {
                column.append("<").append(typeArguments.get(0)).append(">");
            } else if (typeArguments.size() == 2) {
                column.append("<").append(typeArguments.get(0)).append(",").append(typeArguments.get(1)).append(">");
            }
        }
    }

    private void validateColumnsDeclaration() {
        Collection partitionAndClusteringColumns = CollectionUtils.intersection(this.partitionColumnsMap.keySet(), this.clusteringColumnsMap.keySet());
        Collection partitionAndSimpleColumns = CollectionUtils.intersection(this.partitionColumnsMap.keySet(), this.simpleColumnsMap.keySet());
        Collection clusteringAndSimpleColumns = CollectionUtils.intersection(this.clusteringColumnsMap.keySet(), this.simpleColumnsMap.keySet());
        Collection partitionAndStaticColumns = CollectionUtils.intersection(this.partitionColumnsMap.keySet(), this.staticColumnsMap.keySet());
        Collection clusteringAndStaticColumns = CollectionUtils.intersection(this.clusteringColumnsMap.keySet(), this.staticColumnsMap.keySet());
        Collection simpleAndStaticColumns = CollectionUtils.intersection(this.simpleColumnsMap.keySet(), this.staticColumnsMap.keySet());
        if (!partitionAndClusteringColumns.isEmpty()) {
            throw new IllegalStateException(String.format("The '%s' columns can not be declared as partition keys and clustering keys at the same time", partitionAndClusteringColumns));
        }
        if (!partitionAndSimpleColumns.isEmpty()) {
            throw new IllegalStateException(String.format("The '%s' columns can not be declared as partition keys and simple columns at the same time", partitionAndSimpleColumns));
        }
        if (!clusteringAndSimpleColumns.isEmpty()) {
            throw new IllegalStateException(String.format("The '%s' columns can not be declared as clustering keys and simple columns at the same time", clusteringAndSimpleColumns));
        }
        if (!partitionAndStaticColumns.isEmpty()) {
            throw new IllegalStateException(String.format("The '%s' columns can not be declared as partition keys and static columns at the same time", partitionAndStaticColumns));
        }
        if (!clusteringAndStaticColumns.isEmpty()) {
            throw new IllegalStateException(String.format("The '%s' columns can not be declared as clustering keys and static columns at the same time", clusteringAndStaticColumns));
        }
        if (!simpleAndStaticColumns.isEmpty()) {
            throw new IllegalStateException(String.format("The '%s' columns can not be declared as simple columns and static columns at the same time", simpleAndStaticColumns));
        }
        if (!this.staticColumnsMap.isEmpty() && this.clusteringColumnsMap.isEmpty()) {
            throw new IllegalStateException(String.format("The table '%s' cannot declare static columns '%s' without clustering columns", this.tableName, this.staticColumnsMap.keySet()));
        }
    }

    public String build() {
        return this.buildInternal();
    }

    public static class Options
    extends TableOptions<Options> {
        private final Create create;
        private List<ClusteringOrder> clusteringOrderKeys = Collections.emptyList();
        private Optional<Boolean> compactStorage = Optional.absent();

        private Options(Create create) {
            super(create);
            this.create = create;
        }

        public Options clusteringOrder(ClusteringOrder ... clusteringOrders) {
            if (clusteringOrders == null || clusteringOrders.length == 0) {
                throw new IllegalArgumentException(String.format("Cannot create table '%s' with null or empty clustering order keys", this.create.tableName));
            }
            for (ClusteringOrder clusteringOrder : clusteringOrders) {
                String clusteringColumnName = clusteringOrder.getClusteringColumnName();
                if (this.create.clusteringColumnsMap.containsKey(clusteringColumnName)) continue;
                throw new IllegalArgumentException(String.format("Clustering key '%s' is unknown. Did you forget to declare it first ?", clusteringColumnName));
            }
            this.clusteringOrderKeys = Arrays.asList(clusteringOrders);
            return this;
        }

        public Options compactStorage(Boolean compactStorage) {
            this.compactStorage = Optional.fromNullable((Object)compactStorage);
            return this;
        }

        @Override
        String buildOptions() {
            List<String> commonOptions = super.buildCommonOptions();
            ArrayList<String> options = new ArrayList<String>(commonOptions);
            if (!this.clusteringOrderKeys.isEmpty()) {
                options.add("CLUSTERING ORDER BY" + "(" + Joiner.on((String)", ").join(this.clusteringOrderKeys) + ")");
            }
            if (this.compactStorage.isPresent() && ((Boolean)this.compactStorage.get()).booleanValue()) {
                if (!this.create.staticColumnsMap.isEmpty()) {
                    throw new IllegalStateException(String.format("Cannot create table '%s' with compact storage and static columns '%s'", this.create.tableName, this.create.staticColumnsMap.keySet()));
                }
                options.add("COMPACT STORAGE");
            }
            return "\n" + "\t" + "WITH" + " " + Joiner.on((String)" AND ").join(options);
        }

        @Override
        public String build() {
            StringBuilder statement = new StringBuilder(super.build());
            statement.append(this.buildOptions());
            return statement.toString();
        }

        public static class ClusteringOrder {
            private String clusteringColumnName;
            private Sorting sorting = Sorting.ASC;

            public ClusteringOrder(String clusteringColumnName, Sorting sorting) {
                SchemaStatement.validateNotEmpty(clusteringColumnName, "Column name for clustering order");
                this.clusteringColumnName = clusteringColumnName;
                this.sorting = sorting;
            }

            public ClusteringOrder(String clusteringColumnName) {
                SchemaStatement.validateNotEmpty(clusteringColumnName, "Column name for clustering order");
                this.clusteringColumnName = clusteringColumnName;
            }

            private String getClusteringColumnName() {
                return this.clusteringColumnName;
            }

            public Sorting getSorting() {
                return this.sorting;
            }

            public String toStatement() {
                return this.clusteringColumnName + " " + this.sorting.name();
            }

            public String toString() {
                return this.toStatement();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ClusteringOrder that = (ClusteringOrder)o;
                if (this.clusteringColumnName != null ? !this.clusteringColumnName.equals(that.clusteringColumnName) : that.clusteringColumnName != null) {
                    return false;
                }
                return this.sorting == that.sorting;
            }

            public int hashCode() {
                int result = this.clusteringColumnName != null ? this.clusteringColumnName.hashCode() : 0;
                result = 31 * result + (this.sorting != null ? this.sorting.hashCode() : 0);
                return result;
            }

            public static enum Sorting {
                ASC,
                DESC;

            }
        }
    }
}

