/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.typed;

import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedQueryValidator {
    private static final Logger log = LoggerFactory.getLogger(TypedQueryValidator.class);

    public void validateTypedQuery(Class<?> entityClass, String queryString, EntityMeta meta) {
        log.debug("Validate typed query {}", (Object)queryString);
        PropertyMeta idMeta = meta.getIdMeta();
        String normalizedQuery = queryString.toLowerCase();
        this.validateRawTypedQuery(entityClass, queryString, meta);
        if (!normalizedQuery.contains("select *")) {
            if (idMeta.isEmbeddedId()) {
                for (String component : idMeta.getCQLComponentNames()) {
                    Validator.validateTrue(normalizedQuery.contains(component), "The typed query [%s] should contain the component column '%s' for embedded id type '%s'", queryString, component, idMeta.getValueClass().getCanonicalName());
                }
            } else {
                String idColumn = idMeta.getPropertyName();
                Validator.validateTrue(normalizedQuery.contains(idColumn.toLowerCase()), "The typed query [%s] should contain the id column '%s'", queryString, idColumn);
            }
        }
    }

    public void validateRawTypedQuery(Class<?> entityClass, String queryString, EntityMeta meta) {
        log.debug("Validate raw typed query {}", (Object)queryString);
        String tableName = meta.getTableName().toLowerCase();
        String normalizedQuery = queryString.toLowerCase();
        Validator.validateTrue(normalizedQuery.contains(" from " + tableName), "The typed query [%s] should contain the ' from %s' clause if type is '%s'", queryString, tableName, entityClass.getCanonicalName());
    }
}

