/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.typed;

import com.datastax.driver.core.Row;
import com.google.common.base.Optional;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityMapper;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.statement.wrapper.SimpleStatementWrapper;
import info.archinnov.achilles.listener.CASResultListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypedQuery<T> {
    private static final Logger log = LoggerFactory.getLogger(TypedQuery.class);
    private static final Optional<CASResultListener> NO_LISTENER = Optional.absent();
    private DaoContext daoContext;
    private String normalizedQuery;
    private Map<String, PropertyMeta> propertiesMap;
    private EntityMeta meta;
    private PersistenceContextFactory contextFactory;
    private EntityMeta.EntityState entityState;
    private Object[] encodedBoundValues;
    private EntityMapper mapper = new EntityMapper();
    private EntityProxifier proxifier = new EntityProxifier();

    public TypedQuery(Class<T> entityClass, DaoContext daoContext, String queryString, EntityMeta meta, PersistenceContextFactory contextFactory, EntityMeta.EntityState entityState, boolean shouldNormalizeQuery, Object[] encodedBoundValues) {
        this.daoContext = daoContext;
        this.encodedBoundValues = meta.encodeBoundValuesForTypedQueries(encodedBoundValues);
        this.normalizedQuery = shouldNormalizeQuery ? queryString.toLowerCase() : queryString;
        this.meta = meta;
        this.contextFactory = contextFactory;
        this.entityState = entityState;
        this.propertiesMap = this.transformPropertiesMap(meta);
    }

    public List<T> get() {
        log.debug("Get results for typed query {}", (Object)this.normalizedQuery);
        ArrayList result = new ArrayList();
        List rows = this.daoContext.execute(new SimpleStatementWrapper(this.normalizedQuery, this.encodedBoundValues, NO_LISTENER)).all();
        for (Row row : rows) {
            Object entity = this.mapper.mapRowToEntityWithPrimaryKey(this.meta, row, this.propertiesMap, this.entityState);
            if (entity == null) continue;
            this.meta.intercept(entity, Event.POST_LOAD);
            if (this.entityState.isManaged()) {
                entity = this.buildProxy(entity);
            }
            result.add(entity);
        }
        return result;
    }

    public T getFirst() {
        log.debug("Get first result for typed query {}", (Object)this.normalizedQuery);
        Object entity = null;
        Row row = this.daoContext.execute(new SimpleStatementWrapper(this.normalizedQuery, this.encodedBoundValues, NO_LISTENER)).one();
        if (row != null) {
            entity = this.mapper.mapRowToEntityWithPrimaryKey(this.meta, row, this.propertiesMap, this.entityState);
            this.meta.intercept(entity, Event.POST_LOAD);
            if (entity != null && this.entityState.isManaged()) {
                entity = this.buildProxy(entity);
            }
        }
        return entity;
    }

    private Map<String, PropertyMeta> transformPropertiesMap(EntityMeta meta) {
        HashMap<String, PropertyMeta> propertiesMap = new HashMap<String, PropertyMeta>();
        for (Map.Entry<String, PropertyMeta> entry : meta.getPropertyMetas().entrySet()) {
            String propertyName = entry.getKey().toLowerCase();
            propertiesMap.put(propertyName, entry.getValue());
        }
        return propertiesMap;
    }

    private T buildProxy(T entity) {
        PersistenceContext context = this.contextFactory.newContext(entity);
        entity = this.proxifier.buildProxyWithAllFieldsLoadedExceptCounters(entity, context.getEntityFacade());
        return entity;
    }
}

