/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.slice;

import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.query.slice.SliceQuery;
import info.archinnov.achilles.type.OrderingMode;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceQueryValidator {
    private static final Logger log = LoggerFactory.getLogger(SliceQueryValidator.class);
    protected ComponentComparator comparator = new ComponentComparator();

    public int getLastNonNullIndex(List<Object> components) {
        for (int i = 0; i < components.size(); ++i) {
            if (components.get(i) != null) continue;
            return i - 1;
        }
        int lastNonNullIndex = components.size() - 1;
        log.trace("Get last non null index for components {} : {}", components, (Object)lastNonNullIndex);
        return lastNonNullIndex;
    }

    public <T> void validateComponentsForSliceQuery(SliceQuery<T> sliceQuery) {
        List<Object> clusteringsFrom = sliceQuery.getClusteringsFrom();
        List<Object> clusteringsTo = sliceQuery.getClusteringsTo();
        OrderingMode validationOrdering = sliceQuery.getOrdering();
        int partitionComponentsSize = sliceQuery.partitionComponentsSize();
        String startDescription = StringUtils.join(clusteringsFrom.subList(partitionComponentsSize, clusteringsFrom.size()), (String)",");
        String endDescription = StringUtils.join(clusteringsTo.subList(partitionComponentsSize, clusteringsTo.size()), (String)",");
        log.trace("Check components for slice query {} / {}", (Object)startDescription, (Object)endDescription);
        int startIndex = this.getLastNonNullIndex(clusteringsFrom);
        int endIndex = this.getLastNonNullIndex(clusteringsTo);
        Validator.validateTrue(Math.abs(endIndex - startIndex) <= 1, "There should be no more than 1 component difference between clustering keys: [[%s],[%s]", startDescription, endDescription);
        for (int i = partitionComponentsSize; i <= Math.max(startIndex, endIndex) - 1; ++i) {
            Object endComp;
            Object startComp = clusteringsFrom.get(i);
            int comparisonResult = this.comparator.compare(startComp, endComp = clusteringsTo.get(i));
            Validator.validateTrue(comparisonResult == 0, i + 1 - partitionComponentsSize + "th component for clustering keys should be equal: [[%s],[%s]", startDescription, endDescription);
        }
        if (startIndex > 0 && startIndex == endIndex) {
            Object startComp = clusteringsFrom.get(startIndex);
            Object endComp = clusteringsTo.get(endIndex);
            if (OrderingMode.ASCENDING.equals((Object)validationOrdering)) {
                Validator.validateTrue(this.comparator.compare(startComp, endComp) <= 0, "For slice query with ascending order, start clustering last component should be 'lesser or equal' to end clustering last component: [[%s],[%s]", startDescription, endDescription);
            } else {
                Validator.validateTrue(this.comparator.compare(startComp, endComp) >= 0, "For slice query with descending order, start clustering last component should be 'greater or equal' to end clustering last component: [[%s],[%s]", startDescription, endDescription);
            }
        }
    }

    protected static class ComponentComparator
    implements Comparator<Object> {
        protected ComponentComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (o1.getClass().isEnum() && o2.getClass().isEnum()) {
                String name1 = ((Enum)o1).name();
                String name2 = ((Enum)o2).name();
                return name1.compareTo(name2);
            }
            if (Comparable.class.isAssignableFrom(o1.getClass()) && Comparable.class.isAssignableFrom(o2.getClass())) {
                Comparable comp1 = (Comparable)o1;
                Comparable comp2 = (Comparable)o2;
                return comp1.compareTo(comp2);
            }
            throw new IllegalArgumentException("Type '" + o1.getClass().getCanonicalName() + "' or type '" + o2.getClass().getCanonicalName() + "' should implements Comparable");
        }
    }
}

