/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.slice;

import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.schemabuilder.Create;
import info.archinnov.achilles.type.BoundingMode;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.OrderingMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;

public class SliceQuery<T> {
    public static final int DEFAULT_LIMIT = 100;
    public static final int DEFAULT_BATCH_SIZE = 100;
    private Class<T> entityClass;
    private EntityMeta meta;
    private List<Object> partitionComponents;
    private List<Object> clusteringsFrom = new ArrayList<Object>();
    private List<Object> clusteringsTo = new ArrayList<Object>();
    private OrderingMode ordering;
    private BoundingMode bounding;
    private ConsistencyLevel consistencyLevel;
    private int batchSize;
    private int limit;
    private boolean limitSet;
    private boolean noComponent;
    private Create.Options.ClusteringOrder.Sorting clusteringOrder;

    public SliceQuery(Class<T> entityClass, EntityMeta meta, List<Object> partitionComponents, List<Object> clusteringsFrom, List<Object> clusteringsTo, OrderingMode ordering, BoundingMode bounding, ConsistencyLevel consistencyLevel, int limit, int batchSize, boolean limitSet) {
        this.limitSet = limitSet;
        Validator.validateTrue(CollectionUtils.isNotEmpty(partitionComponents), "Partition components should be set for slice query for entity class '%s'", entityClass.getCanonicalName());
        this.entityClass = entityClass;
        this.meta = meta;
        this.partitionComponents = partitionComponents;
        this.noComponent = clusteringsFrom.isEmpty() && clusteringsTo.isEmpty();
        PropertyMeta idMeta = meta.getIdMeta();
        ArrayList<Object> componentsFrom = new ArrayList<Object>();
        componentsFrom.addAll(partitionComponents);
        componentsFrom.addAll(clusteringsFrom);
        this.clusteringsFrom = idMeta.encodeToComponents(componentsFrom);
        ArrayList<Object> componentsTo = new ArrayList<Object>();
        componentsTo.addAll(partitionComponents);
        componentsTo.addAll(clusteringsTo);
        this.clusteringsTo = idMeta.encodeToComponents(componentsTo);
        this.ordering = ordering;
        this.bounding = bounding;
        this.consistencyLevel = consistencyLevel;
        this.limit = limit;
        this.batchSize = batchSize;
        this.clusteringOrder = meta.getIdMeta().getClusteringOrders().get(0).getSorting();
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public EntityMeta getMeta() {
        return this.meta;
    }

    public PropertyMeta getIdMeta() {
        return this.meta.getIdMeta();
    }

    public List<Object> getPartitionComponents() {
        return this.partitionComponents;
    }

    public int partitionComponentsSize() {
        return this.partitionComponents != null ? this.partitionComponents.size() : 0;
    }

    public List<Object> getClusteringsFrom() {
        return this.clusteringsFrom;
    }

    public List<Object> getClusteringsTo() {
        return this.clusteringsTo;
    }

    public OrderingMode getOrdering() {
        return this.clusteringOrder == Create.Options.ClusteringOrder.Sorting.ASC ? this.ordering : this.ordering.reverse();
    }

    public BoundingMode getBounding() {
        return this.bounding;
    }

    public ConsistencyLevel getConsistencyLevel() {
        return this.consistencyLevel;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public boolean isLimitSet() {
        return this.limitSet;
    }

    public boolean hasNoComponent() {
        return this.noComponent;
    }
}

