/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.slice;

import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.SliceQueryExecutor;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.query.slice.SliceQuery;
import info.archinnov.achilles.type.BoundingMode;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.OrderingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RootSliceQueryBuilder<T> {
    private static final Logger log = LoggerFactory.getLogger(RootSliceQueryBuilder.class);
    protected SliceQueryExecutor sliceQueryExecutor;
    protected Class<T> entityClass;
    protected EntityMeta meta;
    protected List<Object> partitionComponents = new ArrayList<Object>();
    private PropertyMeta idMeta;
    private List<Object> fromClusterings = new ArrayList<Object>();
    private List<Object> toClusterings = new ArrayList<Object>();
    private OrderingMode ordering = OrderingMode.ASCENDING;
    private BoundingMode bounding = BoundingMode.INCLUSIVE_BOUNDS;
    private ConsistencyLevel consistencyLevel;
    private int limit = 100;
    private int batchSize = 100;
    private boolean limitHasBeenSet = false;
    private boolean orderingHasBeenSet = false;

    RootSliceQueryBuilder(SliceQueryExecutor sliceQueryExecutor, Class<T> entityClass, EntityMeta meta) {
        this.sliceQueryExecutor = sliceQueryExecutor;
        this.entityClass = entityClass;
        this.meta = meta;
        this.idMeta = meta.getIdMeta();
    }

    protected RootSliceQueryBuilder<T> partitionComponentsInternal(List<Object> partitionComponents) {
        log.trace("Add partition key components {}", partitionComponents);
        this.idMeta.validatePartitionComponents(partitionComponents);
        if (this.partitionComponents.size() > 0) {
            Validator.validateTrue(this.partitionComponents.size() == partitionComponents.size(), "Partition components '%s' do not match previously set values '%s'", partitionComponents, this.partitionComponents);
            for (int i = 0; i < partitionComponents.size(); ++i) {
                Validator.validateTrue(this.partitionComponents.get(i).equals(partitionComponents.get(i)), "Partition components '%s' do not match previously set values '%s'", partitionComponents, this.partitionComponents);
            }
        }
        this.partitionComponents = partitionComponents;
        return this;
    }

    protected RootSliceQueryBuilder<T> partitionComponentsInternal(Object ... partitionComponents) {
        this.partitionComponentsInternal(Arrays.asList(partitionComponents));
        return this;
    }

    protected RootSliceQueryBuilder<T> fromClusteringsInternal(List<Object> clusteringComponents) {
        log.trace("Add clustering components {}", clusteringComponents);
        this.idMeta.validateClusteringComponents(clusteringComponents);
        this.fromClusterings = clusteringComponents;
        return this;
    }

    protected RootSliceQueryBuilder<T> fromClusteringsInternal(Object ... clusteringComponents) {
        this.fromClusteringsInternal(Arrays.asList(clusteringComponents));
        return this;
    }

    protected RootSliceQueryBuilder<T> toClusteringsInternal(List<Object> clusteringComponents) {
        log.trace("Add clustering components {}", clusteringComponents);
        this.idMeta.validateClusteringComponents(clusteringComponents);
        this.toClusterings = clusteringComponents;
        return this;
    }

    protected RootSliceQueryBuilder<T> toClusteringsInternal(Object ... clusteringComponents) {
        this.toClusteringsInternal(Arrays.asList(clusteringComponents));
        return this;
    }

    protected RootSliceQueryBuilder<T> ordering(OrderingMode ordering) {
        Validator.validateNotNull((Object)ordering, "Ordering mode for slice query for entity '%s' should not be null", this.meta.getClassName());
        this.ordering = ordering;
        this.orderingHasBeenSet = true;
        return this;
    }

    protected RootSliceQueryBuilder<T> bounding(BoundingMode boundingMode) {
        Validator.validateNotNull((Object)boundingMode, "Bounding mode for slice query for entity '%s' should not be null", this.meta.getClassName());
        this.bounding = boundingMode;
        return this;
    }

    protected RootSliceQueryBuilder<T> consistencyLevelInternal(ConsistencyLevel consistencyLevel) {
        Validator.validateNotNull(consistencyLevel, "ConsistencyLevel for slice query for entity '%s' should not be null", this.meta.getClassName());
        this.consistencyLevel = consistencyLevel;
        return this;
    }

    protected RootSliceQueryBuilder<T> limit(int limit) {
        this.limit = limit;
        this.limitHasBeenSet = true;
        return this;
    }

    protected List<T> get() {
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        return this.sliceQueryExecutor.get(clusteredQuery);
    }

    protected List<T> get(int n) {
        this.limit = n;
        this.limitHasBeenSet = true;
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        return this.sliceQueryExecutor.get(clusteredQuery);
    }

    protected T getFirstOccurence(Object ... clusteringComponents) {
        log.trace("Get first result using clustering components {}", clusteringComponents);
        this.fromClusteringsInternal(clusteringComponents);
        this.toClusteringsInternal(clusteringComponents);
        Validator.validateFalse(this.limitHasBeenSet, "You should not set 'limit' parameter when calling getFirst()", new Object[0]);
        this.limit = 1;
        this.limitHasBeenSet = true;
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        List<T> result = this.sliceQueryExecutor.get(clusteredQuery);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    protected List<T> getFirst(int n, Object ... clusteringComponents) {
        log.trace("Get first {} results using clustering components {}", (Object)n, (Object)clusteringComponents);
        this.fromClusteringsInternal(clusteringComponents);
        this.toClusteringsInternal(clusteringComponents);
        Validator.validateFalse(this.limitHasBeenSet, "You should not set 'limit' parameter when calling getFirst(int n)", new Object[0]);
        this.limit = n;
        this.limitHasBeenSet = true;
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        return this.sliceQueryExecutor.get(clusteredQuery);
    }

    protected T getLastOccurence(Object ... clusteringComponents) {
        log.trace("Get last result using clustering components {}", clusteringComponents);
        this.fromClusteringsInternal(clusteringComponents);
        this.toClusteringsInternal(clusteringComponents);
        Validator.validateFalse(this.orderingHasBeenSet, "You should not set 'ordering' parameter when calling getLast()", new Object[0]);
        Validator.validateFalse(this.limitHasBeenSet, "You should not set 'limit' parameter when calling getLast()", new Object[0]);
        this.limit = 1;
        this.limitHasBeenSet = true;
        this.ordering = OrderingMode.DESCENDING;
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        List<T> result = this.sliceQueryExecutor.get(clusteredQuery);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    protected List<T> getLast(int n, Object ... clusteringComponents) {
        log.trace("Get last {} results using clustering components {}", (Object)n, (Object)clusteringComponents);
        this.fromClusteringsInternal(clusteringComponents);
        this.toClusteringsInternal(clusteringComponents);
        Validator.validateFalse(this.orderingHasBeenSet, "You should not set 'ordering' parameter when calling getLast(int n)", new Object[0]);
        Validator.validateFalse(this.limitHasBeenSet, "You should not set 'limit' parameter when calling getLast(int n)", new Object[0]);
        this.limit = n;
        this.limitHasBeenSet = true;
        this.ordering = OrderingMode.DESCENDING;
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        return this.sliceQueryExecutor.get(clusteredQuery);
    }

    protected Iterator<T> iterator() {
        log.trace("Build iterator for slice query");
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        return this.sliceQueryExecutor.iterator(clusteredQuery);
    }

    protected Iterator<T> iteratorWithComponents(Object ... clusteringComponents) {
        log.trace("Build iterator for slice query with clustering components {}", clusteringComponents);
        this.fromClusteringsInternal(clusteringComponents);
        this.toClusteringsInternal(clusteringComponents);
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        return this.sliceQueryExecutor.iterator(clusteredQuery);
    }

    protected Iterator<T> iterator(int batchSize) {
        log.trace("Build iterator for slice query with batch size {}", (Object)batchSize);
        this.batchSize = batchSize;
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        return this.sliceQueryExecutor.iterator(clusteredQuery);
    }

    protected Iterator<T> iteratorWithComponents(int batchSize, Object ... clusteringComponents) {
        log.trace("Build iterator for slice query with clustering components {} and batch size {}", (Object)clusteringComponents, (Object)batchSize);
        this.fromClusteringsInternal(clusteringComponents);
        this.toClusteringsInternal(clusteringComponents);
        this.batchSize = batchSize;
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        return this.sliceQueryExecutor.iterator(clusteredQuery);
    }

    protected void remove() {
        log.trace("Slice remove");
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        this.sliceQueryExecutor.remove(clusteredQuery);
    }

    protected void remove(int n) {
        log.trace("Slice remove {} entities", (Object)n);
        Validator.validateFalse(this.limitHasBeenSet, "You should not set 'limit' parameter when calling remove(int n)", new Object[0]);
        this.limit = n;
        this.limitHasBeenSet = true;
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        this.sliceQueryExecutor.remove(clusteredQuery);
    }

    protected void removeFirstOccurence(Object ... clusteringComponents) {
        log.trace("Slice remove first matching entity with clustering components {}", clusteringComponents);
        this.fromClusteringsInternal(clusteringComponents);
        this.toClusteringsInternal(clusteringComponents);
        Validator.validateFalse(this.limitHasBeenSet, "You should not set 'limit' parameter when calling removeFirst()", new Object[0]);
        this.limit = 1;
        this.limitHasBeenSet = true;
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        this.sliceQueryExecutor.remove(clusteredQuery);
    }

    protected void removeFirst(int n, Object ... clusteringComponents) {
        log.trace("Slice remove first {} matching entities with clustering components {}", (Object)n, (Object)clusteringComponents);
        this.fromClusteringsInternal(clusteringComponents);
        this.toClusteringsInternal(clusteringComponents);
        Validator.validateFalse(this.limitHasBeenSet, "You should not set 'limit' parameter when calling removeFirst(int n)", new Object[0]);
        this.limit = n;
        this.limitHasBeenSet = true;
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        this.sliceQueryExecutor.remove(clusteredQuery);
    }

    protected void removeLastOccurence(Object ... clusteringComponents) {
        log.trace("Slice remove last matching entity with clustering components {}", clusteringComponents);
        this.fromClusteringsInternal(clusteringComponents);
        this.toClusteringsInternal(clusteringComponents);
        Validator.validateFalse(this.orderingHasBeenSet, "You should not set 'ordering' parameter when calling removeLast()", new Object[0]);
        Validator.validateFalse(this.limitHasBeenSet, "You should not set 'limit' parameter when calling removeLast()", new Object[0]);
        this.limit = 1;
        this.limitHasBeenSet = true;
        this.ordering = OrderingMode.DESCENDING;
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        this.sliceQueryExecutor.remove(clusteredQuery);
    }

    protected void removeLast(int n, Object ... clusteringComponents) {
        log.trace("Slice remove last {} matching entities with clustering components {}", (Object)n, (Object)clusteringComponents);
        this.fromClusteringsInternal(clusteringComponents);
        this.toClusteringsInternal(clusteringComponents);
        Validator.validateFalse(this.orderingHasBeenSet, "You should not set 'ordering' parameter when calling removeLast(int n)", new Object[0]);
        Validator.validateFalse(this.limitHasBeenSet, "You should not set 'limit' parameter when calling removeLast(int n)", new Object[0]);
        this.limit = n;
        this.limitHasBeenSet = true;
        this.ordering = OrderingMode.DESCENDING;
        SliceQuery<T> clusteredQuery = this.buildClusterQuery();
        this.sliceQueryExecutor.remove(clusteredQuery);
    }

    protected SliceQuery<T> buildClusterQuery() {
        return new SliceQuery<T>(this.entityClass, this.meta, this.partitionComponents, this.fromClusterings, this.toClusterings, this.ordering, this.bounding, this.consistencyLevel, this.limit, this.batchSize, this.limitHasBeenSet);
    }
}

