/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.slice;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import info.archinnov.achilles.internal.consistency.ConsistencyConverter;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.query.slice.SliceQuery;
import info.archinnov.achilles.query.slice.SliceQueryValidator;
import info.archinnov.achilles.type.BoundingMode;
import info.archinnov.achilles.type.OrderingMode;
import info.archinnov.achilles.type.Pair;
import java.util.ArrayList;
import java.util.List;

public class CQLSliceQuery<T> {
    private SliceQuery<T> sliceQuery;
    private List<Object> fixedComponents;
    private Object lastStartComp;
    private Object lastEndComp;
    private SliceQueryValidator validator = new SliceQueryValidator();
    private info.archinnov.achilles.type.ConsistencyLevel defaultReadLevel;

    public CQLSliceQuery(SliceQuery<T> sliceQuery, info.archinnov.achilles.type.ConsistencyLevel defaultReadLevel) {
        this.validator.validateComponentsForSliceQuery(sliceQuery);
        this.sliceQuery = sliceQuery;
        this.defaultReadLevel = defaultReadLevel;
        this.fixedComponents = this.determineFixedComponents(sliceQuery);
        Pair<Object, Object> lastComponents = this.determineLastComponents(sliceQuery);
        this.lastStartComp = lastComponents.left;
        this.lastEndComp = lastComponents.right;
    }

    public List<Object> getFixedComponents() {
        return this.fixedComponents;
    }

    public Object getLastStartComponent() {
        return this.lastStartComp;
    }

    public Object getLastEndComponent() {
        return this.lastEndComp;
    }

    public int getLimit() {
        return this.sliceQuery.getLimit();
    }

    public ConsistencyLevel getConsistencyLevel() {
        info.archinnov.achilles.type.ConsistencyLevel consistencyLevel = this.sliceQuery.getConsistencyLevel() == null ? this.defaultReadLevel : this.sliceQuery.getConsistencyLevel();
        return ConsistencyConverter.getCQLLevel(consistencyLevel);
    }

    public BoundingMode getBounding() {
        return this.sliceQuery.getBounding();
    }

    public OrderingMode getOrdering() {
        return this.sliceQuery.getOrdering();
    }

    public Ordering getCQLOrdering() {
        OrderingMode ordering = this.sliceQuery.getOrdering();
        String orderingComponentName = this.sliceQuery.getMeta().getIdMeta().getOrderingComponent();
        if (ordering.isReverse()) {
            return QueryBuilder.desc((String)orderingComponentName);
        }
        return QueryBuilder.asc((String)orderingComponentName);
    }

    public List<String> getComponentNames() {
        return this.sliceQuery.getIdMeta().getComponentNames();
    }

    public String getVaryingComponentName() {
        return this.sliceQuery.getIdMeta().getVaryingComponentNameForQuery(this.fixedComponents.size());
    }

    public EntityMeta getMeta() {
        return this.sliceQuery.getMeta();
    }

    public Class<T> getEntityClass() {
        return this.sliceQuery.getEntityClass();
    }

    public int getBatchSize() {
        return this.sliceQuery.getBatchSize();
    }

    private List<Object> determineFixedComponents(SliceQuery<T> sliceQuery) {
        ArrayList<Object> fixedComponents = new ArrayList<Object>();
        List<Object> startComponents = sliceQuery.getClusteringsFrom();
        List<Object> endComponents = sliceQuery.getClusteringsTo();
        int startIndex = this.validator.getLastNonNullIndex(startComponents);
        int endIndex = this.validator.getLastNonNullIndex(endComponents);
        int minIndex = Math.min(startIndex, endIndex);
        if (startIndex == endIndex) {
            for (int i = 0; i <= minIndex && startComponents.get(i).equals(endComponents.get(i)); ++i) {
                fixedComponents.add(startComponents.get(i));
            }
        } else {
            for (int i = 0; i <= minIndex; ++i) {
                fixedComponents.add(startComponents.get(i));
            }
        }
        return fixedComponents;
    }

    private Pair<Object, Object> determineLastComponents(SliceQuery<T> sliceQuery) {
        Object lastEndComp;
        Object lastStartComp;
        int endIndex;
        List<Object> startComponents = sliceQuery.getClusteringsFrom();
        List<Object> endComponents = sliceQuery.getClusteringsTo();
        int startIndex = this.validator.getLastNonNullIndex(startComponents);
        if (startIndex == (endIndex = this.validator.getLastNonNullIndex(endComponents)) && !startComponents.get(startIndex).equals(endComponents.get(endIndex))) {
            lastStartComp = startComponents.get(startIndex);
            lastEndComp = endComponents.get(endIndex);
        } else if (startIndex < endIndex) {
            lastStartComp = null;
            lastEndComp = endComponents.get(endIndex);
        } else if (startIndex > endIndex) {
            lastStartComp = startComponents.get(startIndex);
            lastEndComp = null;
        } else {
            lastStartComp = null;
            lastEndComp = null;
        }
        return Pair.create(lastStartComp, lastEndComp);
    }

    public void validateSliceQueryForRemove() {
        Validator.validateTrue(this.lastStartComp == null && this.lastEndComp == null, "CQL does not support slice delete with varying compound components", new Object[0]);
        Validator.validateFalse(this.sliceQuery.isLimitSet(), "CQL slice delete does not support LIMIT", new Object[0]);
    }
}

