/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.query.cql;

import com.google.common.base.Optional;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.persistence.operations.NativeQueryMapper;
import info.archinnov.achilles.internal.statement.wrapper.SimpleStatementWrapper;
import info.archinnov.achilles.listener.CASResultListener;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.TypedMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeQuery {
    private static final Logger log = LoggerFactory.getLogger(NativeQuery.class);
    private static final Optional<CASResultListener> NO_CAS_LISTENER = Optional.absent();
    private DaoContext daoContext;
    private NativeQueryMapper mapper = new NativeQueryMapper();
    protected String queryString;
    protected Object[] boundValues;
    protected Options options;

    public NativeQuery(DaoContext daoContext, String queryString, Options options, Object ... boundValues) {
        this.daoContext = daoContext;
        this.queryString = queryString;
        this.options = options;
        this.boundValues = boundValues;
    }

    public List<TypedMap> get() {
        log.debug("Get results for native query {}", (Object)this.queryString);
        List rows = this.daoContext.execute(new SimpleStatementWrapper(this.queryString, this.boundValues, NO_CAS_LISTENER)).all();
        return this.mapper.mapRows(rows);
    }

    public TypedMap first() {
        log.debug("Get first result for native query {}", (Object)this.queryString);
        List rows = this.daoContext.execute(new SimpleStatementWrapper(this.queryString, this.boundValues, NO_CAS_LISTENER)).all();
        List<TypedMap> result = this.mapper.mapRows(rows);
        if (result.isEmpty()) {
            return null;
        }
        return result.get(0);
    }

    public void execute() {
        log.debug("Execute native query {}", (Object)this.queryString);
        this.daoContext.execute(new SimpleStatementWrapper(this.queryString, this.boundValues, this.options.getCasResultListener()));
    }
}

