/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.persistence;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.configuration.ArgumentExtractor;
import info.archinnov.achilles.configuration.ConfigurationParameters;
import info.archinnov.achilles.interceptor.Interceptor;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.context.SchemaContext;
import info.archinnov.achilles.internal.metadata.discovery.AchillesBootstrapper;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.parsing.context.ParsingResult;
import info.archinnov.achilles.internal.proxy.ProxyClassFactory;
import info.archinnov.achilles.internal.utils.ConfigMap;
import info.archinnov.achilles.json.ObjectMapperFactory;
import info.archinnov.achilles.persistence.Batch;
import info.archinnov.achilles.persistence.PersistenceManager;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.InsertStrategy;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceManagerFactory {
    private static final Logger log = LoggerFactory.getLogger(PersistenceManagerFactory.class);
    Map<Class<?>, EntityMeta> entityMetaMap = new HashMap();
    ConfigurationContext configContext;
    DaoContext daoContext;
    PersistenceContextFactory contextFactory;
    ConfigMap configurationMap;
    private ArgumentExtractor argumentExtractor = new ArgumentExtractor();
    private AchillesBootstrapper bootstrapper = new AchillesBootstrapper();
    private ProxyClassFactory proxyClassFactory = new ProxyClassFactory();
    private Cluster cluster;

    PersistenceManagerFactory(Cluster cluster, Map<ConfigurationParameters, Object> configurationMap) {
        this.cluster = cluster;
        info.archinnov.achilles.internal.validation.Validator.validateNotNull(configurationMap, "Configuration map for PersistenceManagerFactory should not be null", new Object[0]);
        info.archinnov.achilles.internal.validation.Validator.validateNotEmpty(configurationMap, "Configuration map for PersistenceManagerFactory should not be empty", new Object[0]);
        this.configurationMap = ConfigMap.fromMap(configurationMap);
    }

    PersistenceManagerFactory bootstrap() {
        String keyspaceName = (String)this.configurationMap.getTyped(ConfigurationParameters.KEYSPACE_NAME);
        log.info("Bootstrapping Achilles PersistenceManagerFactory for keyspace {}", (Object)keyspaceName);
        this.configContext = this.argumentExtractor.initConfigContext(this.configurationMap);
        Session session = this.argumentExtractor.initSession(this.cluster, this.configurationMap);
        ClassLoader classLoader = this.argumentExtractor.initOSGIClassLoader(this.configurationMap);
        List<Interceptor<?>> interceptors = this.argumentExtractor.initInterceptors(this.configurationMap);
        List<Class<?>> candidateClasses = this.argumentExtractor.initEntities(this.configurationMap, classLoader);
        ParsingResult parsingResult = this.parseEntities(candidateClasses);
        this.entityMetaMap = parsingResult.getMetaMap();
        this.bootstrapper.addInterceptorsToEntityMetas(interceptors, parsingResult.getMetaMap());
        SchemaContext schemaContext = new SchemaContext(this.configContext.isForceColumnFamilyCreation(), session, keyspaceName, this.cluster, parsingResult);
        this.bootstrapper.validateOrCreateTables(schemaContext);
        this.daoContext = this.bootstrapper.buildDaoContext(session, parsingResult, this.configContext);
        this.contextFactory = new PersistenceContextFactory(this.daoContext, this.configContext, parsingResult.getMetaMap());
        this.warmUpProxies();
        return this;
    }

    private void warmUpProxies() {
        if (this.argumentExtractor.initProxyWarmUp(this.configurationMap)) {
            long start = System.nanoTime();
            for (Class<?> clazz : this.entityMetaMap.keySet()) {
                this.proxyClassFactory.createProxyClass(clazz, this.configContext);
            }
            long end = System.nanoTime();
            long duration = (end - start) / 1000000L;
            log.info("Entity proxies warm up took {} milli secs for {} entities", (Object)duration, (Object)this.entityMetaMap.size());
        }
    }

    private ParsingResult parseEntities(List<Class<?>> candidateClasses) {
        return this.bootstrapper.buildMetaDatas(this.configContext, candidateClasses);
    }

    public PersistenceManager createPersistenceManager() {
        log.debug("Spawn new PersistenceManager");
        return new PersistenceManager(this.entityMetaMap, this.contextFactory, this.daoContext, this.configContext);
    }

    public Batch createBatch() {
        log.debug("Spawn new BatchingPersistenceManager");
        return new Batch(this.entityMetaMap, this.contextFactory, this.daoContext, this.configContext, false);
    }

    public Batch createOrderedBatch() {
        log.debug("Spawn new BatchingPersistenceManager");
        return new Batch(this.entityMetaMap, this.contextFactory, this.daoContext, this.configContext, true);
    }

    public String jsonSerialize(Object entity) throws IOException {
        info.archinnov.achilles.internal.validation.Validator.validateNotNull(entity, "Cannot serialize to JSON null entity", new Object[0]);
        ObjectMapper objectMapper = this.configContext.getMapperFor(entity.getClass());
        return objectMapper.writeValueAsString(entity);
    }

    public <T> T deserializeJson(Class<T> type, String serialized) throws IOException {
        info.archinnov.achilles.internal.validation.Validator.validateNotNull(type, "Cannot deserialize from JSON if target type is null", new Object[0]);
        ObjectMapper objectMapper = this.configContext.getMapperFor(type);
        return (T)objectMapper.readValue(serialized, type);
    }

    public static class PersistenceManagerFactoryBuilder {
        private ConfigMap configMap = new ConfigMap();
        private Cluster cluster;

        private PersistenceManagerFactoryBuilder(Cluster cluster) {
            this.cluster = cluster;
            info.archinnov.achilles.internal.validation.Validator.validateNotNull(cluster, "Cluster object should not be null", new Object[0]);
        }

        public static PersistenceManagerFactory build(Cluster cluster, Map<ConfigurationParameters, Object> configurationMap) {
            return new PersistenceManagerFactory(cluster, configurationMap).bootstrap();
        }

        public static PersistenceManagerFactoryBuilder builder(Cluster cluster) {
            return new PersistenceManagerFactoryBuilder(cluster);
        }

        public PersistenceManagerFactoryBuilder withEntityPackages(String entityPackages) {
            this.configMap.put(ConfigurationParameters.ENTITY_PACKAGES, entityPackages);
            return this;
        }

        public PersistenceManagerFactoryBuilder withEntities(List<Class<?>> entities) {
            this.configMap.put(ConfigurationParameters.ENTITIES_LIST, entities);
            return this;
        }

        public PersistenceManagerFactoryBuilder withObjectMapper(ObjectMapper objectMapper) {
            this.configMap.put(ConfigurationParameters.OBJECT_MAPPER, objectMapper);
            return this;
        }

        public PersistenceManagerFactoryBuilder withObjectMapperFactory(ObjectMapperFactory objectMapperFactory) {
            this.configMap.put(ConfigurationParameters.OBJECT_MAPPER_FACTORY, objectMapperFactory);
            return this;
        }

        public PersistenceManagerFactoryBuilder withDefaultReadConsistency(ConsistencyLevel defaultReadConsistency) {
            this.configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_READ_DEFAULT, defaultReadConsistency);
            return this;
        }

        public PersistenceManagerFactoryBuilder withDefaultWriteConsistency(ConsistencyLevel defaultWriteConsistency) {
            this.configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_WRITE_DEFAULT, defaultWriteConsistency);
            return this;
        }

        public PersistenceManagerFactoryBuilder withDefaultReadConsistencyMap(Map<String, ConsistencyLevel> readConsistencyMap) {
            this.configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_READ_MAP, readConsistencyMap);
            return this;
        }

        public PersistenceManagerFactoryBuilder withDefaultWriteConsistencyMap(Map<String, ConsistencyLevel> writeConsistencyMap) {
            this.configMap.put(ConfigurationParameters.CONSISTENCY_LEVEL_WRITE_MAP, writeConsistencyMap);
            return this;
        }

        public PersistenceManagerFactoryBuilder forceTableCreation(boolean forceTableCreation) {
            this.configMap.put(ConfigurationParameters.FORCE_TABLE_CREATION, forceTableCreation);
            return this;
        }

        public PersistenceManagerFactoryBuilder enableSchemaUpdate(boolean forceTableUpdate) {
            this.configMap.put(ConfigurationParameters.ENABLE_SCHEMA_UPDATE, forceTableUpdate);
            return this;
        }

        public PersistenceManagerFactoryBuilder enableSchemaUpdateForTables(Map<String, Boolean> tables) {
            this.configMap.put(ConfigurationParameters.ENABLE_SCHEMA_UPDATE_FOR_TABLES, tables);
            return this;
        }

        public PersistenceManagerFactoryBuilder withNativeSession(Session nativeSession) {
            this.configMap.put(ConfigurationParameters.NATIVE_SESSION, nativeSession);
            return this;
        }

        public PersistenceManagerFactoryBuilder withKeyspaceName(String keyspaceName) {
            this.configMap.put(ConfigurationParameters.KEYSPACE_NAME, keyspaceName);
            return this;
        }

        public PersistenceManagerFactoryBuilder withEventInterceptors(List<Interceptor<?>> interceptors) {
            this.configMap.put(ConfigurationParameters.EVENT_INTERCEPTORS, interceptors);
            return this;
        }

        public PersistenceManagerFactoryBuilder enableBeanValidation(boolean enableBeanValidation) {
            this.configMap.put(ConfigurationParameters.BEAN_VALIDATION_ENABLE, enableBeanValidation);
            return this;
        }

        public PersistenceManagerFactoryBuilder withBeanValidator(Validator validator) {
            if (validator != null) {
                this.configMap.put(ConfigurationParameters.BEAN_VALIDATION_VALIDATOR, validator);
            }
            return this;
        }

        public PersistenceManagerFactoryBuilder withMaxPreparedStatementCacheSize(int maxPreparedStatementCacheSize) {
            this.configMap.put(ConfigurationParameters.PREPARED_STATEMENTS_CACHE_SIZE, maxPreparedStatementCacheSize);
            return this;
        }

        public PersistenceManagerFactoryBuilder disableProxiesWarmUp(boolean disableProxiesWarmUp) {
            this.configMap.put(ConfigurationParameters.PROXIES_WARM_UP_DISABLED, disableProxiesWarmUp);
            return this;
        }

        public PersistenceManagerFactoryBuilder globalInsertStrategy(InsertStrategy globalInsertStrategy) {
            this.configMap.put(ConfigurationParameters.INSERT_STRATEGY, globalInsertStrategy);
            return this;
        }

        public PersistenceManagerFactory build() {
            return new PersistenceManagerFactory(this.cluster, this.configMap).bootstrap();
        }
    }
}

