/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.persistence;

import com.datastax.driver.core.Session;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.exception.AchillesStaleObjectStateException;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.context.facade.PersistenceManagerOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.persistence.operations.EntityValidator;
import info.archinnov.achilles.internal.persistence.operations.OptionsValidator;
import info.archinnov.achilles.internal.persistence.operations.SliceQueryExecutor;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.query.cql.NativeQuery;
import info.archinnov.achilles.query.slice.SliceQueryBuilder;
import info.archinnov.achilles.query.typed.TypedQuery;
import info.archinnov.achilles.query.typed.TypedQueryValidator;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.IndexCondition;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.OptionsBuilder;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(PersistenceManager.class);
    protected Map<Class<?>, EntityMeta> entityMetaMap;
    protected ConfigurationContext configContext;
    protected PersistenceContextFactory contextFactory;
    protected EntityProxifier proxifier = new EntityProxifier();
    private EntityValidator entityValidator = new EntityValidator();
    private OptionsValidator optionsValidator = new OptionsValidator();
    private TypedQueryValidator typedQueryValidator = new TypedQueryValidator();
    private SliceQueryExecutor sliceQueryExecutor;
    protected DaoContext daoContext;

    protected PersistenceManager(Map<Class<?>, EntityMeta> entityMetaMap, PersistenceContextFactory contextFactory, DaoContext daoContext, ConfigurationContext configContext) {
        this.entityMetaMap = entityMetaMap;
        this.configContext = configContext;
        this.daoContext = daoContext;
        this.contextFactory = contextFactory;
        this.sliceQueryExecutor = new SliceQueryExecutor(contextFactory, configContext, daoContext);
    }

    public <T> T persist(T entity) {
        log.debug("Persisting entity '{}'", entity);
        return this.persist(entity, OptionsBuilder.noOptions());
    }

    public <T> T persist(T entity, Options options) {
        if (log.isDebugEnabled()) {
            log.debug("Persisting entity '{}' with options {} ", entity, (Object)options);
        }
        this.entityValidator.validateEntity(entity, this.entityMetaMap);
        this.optionsValidator.validateOptionsForInsert(entity, this.entityMetaMap, options);
        this.proxifier.ensureNotProxy(entity);
        PersistenceManagerOperations context = this.initPersistenceContext(entity, options);
        return context.persist(entity);
    }

    public void update(Object entity) {
        if (log.isDebugEnabled()) {
            log.debug("Updating entity '{}'", this.proxifier.getRealObject(entity));
        }
        this.update(entity, OptionsBuilder.noOptions());
    }

    public void update(Object entity, Options options) {
        this.proxifier.ensureProxy(entity);
        Object realObject = this.proxifier.getRealObject(entity);
        if (log.isDebugEnabled()) {
            log.debug("Updating entity '{}' with options {} ", realObject, (Object)options);
        }
        this.entityValidator.validateEntity(realObject, this.entityMetaMap);
        this.optionsValidator.validateOptionsForUpdate(entity, this.entityMetaMap, options);
        PersistenceManagerOperations context = this.initPersistenceContext(realObject, options);
        context.update(entity);
    }

    public void remove(Object entity) {
        if (log.isDebugEnabled()) {
            log.debug("Removing entity '{}'", this.proxifier.getRealObject(entity));
        }
        this.remove(entity, OptionsBuilder.noOptions());
    }

    public void removeById(Class<?> entityClass, Object primaryKey) {
        Validator.validateNotNull(entityClass, "The entity class should not be null for removal by id", new Object[0]);
        Validator.validateNotNull(primaryKey, "The primary key should not be null for removal by id", new Object[0]);
        if (log.isDebugEnabled()) {
            log.debug("Removing entity of type '{}' by its id '{}'", entityClass, primaryKey);
        }
        PersistenceManagerOperations context = this.initPersistenceContext(entityClass, primaryKey, OptionsBuilder.noOptions());
        this.entityValidator.validatePrimaryKey(context.getIdMeta(), primaryKey);
        context.remove();
    }

    public void remove(Object entity, Options options) {
        Object realObject = this.proxifier.getRealObject(entity);
        if (log.isDebugEnabled()) {
            log.debug("Removing entity '{}' with options {}", realObject, (Object)options);
        }
        this.entityValidator.validateEntity(realObject, this.entityMetaMap);
        PersistenceManagerOperations context = this.initPersistenceContext(realObject, options);
        context.remove();
    }

    public void removeById(Class<?> entityClass, Object primaryKey, ConsistencyLevel writeLevel) {
        Validator.validateNotNull(entityClass, "The entity class should not be null for removal by id", new Object[0]);
        Validator.validateNotNull(primaryKey, "The primary key should not be null for removal by id", new Object[0]);
        if (log.isDebugEnabled()) {
            log.debug("Removing entity of type '{}' by its id '{}'", entityClass, primaryKey);
        }
        PersistenceManagerOperations context = this.initPersistenceContext(entityClass, primaryKey, OptionsBuilder.withConsistency(writeLevel));
        this.entityValidator.validatePrimaryKey(context.getIdMeta(), primaryKey);
        context.remove();
    }

    public <T> T find(Class<T> entityClass, Object primaryKey) {
        log.debug("Find entity class '{}' with primary key {}", entityClass, primaryKey);
        T entity = this.find(entityClass, primaryKey, null);
        return entity;
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, ConsistencyLevel readLevel) {
        log.debug("Find entity class '{}' with primary key {} and read consistency level {}", new Object[]{entityClass, primaryKey, readLevel});
        Validator.validateNotNull(entityClass, "Entity class should not be null for find by id", new Object[0]);
        Validator.validateNotNull(primaryKey, "Entity primaryKey should not be null for find by id", new Object[0]);
        Validator.validateTrue(this.entityMetaMap.containsKey(entityClass), "The entity class '%s' is not managed by Achilles", entityClass.getCanonicalName());
        Validator.validateTrue(this.entityMetaMap.containsKey(entityClass), "The entity class '%s' is not managed by Achilles", entityClass.getCanonicalName());
        PersistenceManagerOperations context = this.initPersistenceContext(entityClass, primaryKey, OptionsBuilder.withConsistency(readLevel));
        this.entityValidator.validatePrimaryKey(context.getIdMeta(), primaryKey);
        return context.find(entityClass);
    }

    public <T> T getProxy(Class<T> entityClass, Object primaryKey) {
        if (log.isDebugEnabled()) {
            log.debug("Get reference for entity class '{}' with primary key {}", entityClass, primaryKey);
        }
        return this.getProxy(entityClass, primaryKey, null);
    }

    public <T> T getProxy(Class<T> entityClass, Object primaryKey, ConsistencyLevel readLevel) {
        if (log.isDebugEnabled()) {
            log.debug("Get reference for entity class '{}' with primary key {} and read consistency level {}", new Object[]{entityClass, primaryKey, readLevel});
        }
        Validator.validateNotNull(entityClass, "Entity class should not be null for get reference", new Object[0]);
        Validator.validateNotNull(primaryKey, "Entity primaryKey should not be null for get reference", new Object[0]);
        Validator.validateTrue(this.entityMetaMap.containsKey(entityClass), "The entity class '%s' is not managed by Achilles", entityClass.getCanonicalName());
        Validator.validateTrue(this.entityMetaMap.containsKey(entityClass), "The entity class '%s' is not managed by Achilles", entityClass.getCanonicalName());
        PersistenceManagerOperations context = this.initPersistenceContext(entityClass, primaryKey, OptionsBuilder.withConsistency(readLevel));
        this.entityValidator.validatePrimaryKey(context.getIdMeta(), primaryKey);
        T entity = context.getProxy(entityClass);
        return entity;
    }

    public void refresh(Object entity) throws AchillesStaleObjectStateException {
        if (log.isDebugEnabled()) {
            log.debug("Refreshing entity '{}'", this.proxifier.removeProxy(entity));
        }
        this.refresh(entity, null);
    }

    public void refresh(Object entity, ConsistencyLevel readLevel) throws AchillesStaleObjectStateException {
        if (log.isDebugEnabled()) {
            log.debug("Refreshing entity '{}' with read consistency level {}", this.proxifier.removeProxy(entity), (Object)readLevel);
        }
        this.proxifier.ensureProxy(entity);
        Object realObject = this.proxifier.getRealObject(entity);
        this.entityValidator.validateEntity(realObject, this.entityMetaMap);
        PersistenceManagerOperations context = this.initPersistenceContext(realObject, OptionsBuilder.withConsistency(readLevel));
        context.refresh(entity);
    }

    public <T> T initialize(T entity) {
        log.debug("Force lazy fields initialization for entity {}", entity);
        if (log.isDebugEnabled()) {
            log.debug("Force lazy fields initialization for entity {}", this.proxifier.removeProxy(entity));
        }
        this.proxifier.ensureProxy(entity);
        T realObject = this.proxifier.getRealObject(entity);
        PersistenceManagerOperations context = this.initPersistenceContext(realObject, OptionsBuilder.noOptions());
        return context.initialize(entity);
    }

    public <T> Set<T> initialize(Set<T> entities) {
        log.debug("Force lazy fields initialization for entity set {}", entities);
        for (T entity : entities) {
            this.initialize(entity);
        }
        return entities;
    }

    public <T> List<T> initialize(List<T> entities) {
        log.debug("Force lazy fields initialization for entity set {}", entities);
        for (T entity : entities) {
            this.initialize(entity);
        }
        return entities;
    }

    public <T> T initAndRemoveProxy(T entity) {
        return this.removeProxy(this.initialize(entity));
    }

    public <T> Set<T> initAndRemoveProxy(Set<T> entities) {
        return this.removeProxy(this.initialize(entities));
    }

    public <T> List<T> initAndRemoveProxy(List<T> entities) {
        return this.removeProxy(this.initialize(entities));
    }

    public <T> T removeProxy(T proxy) {
        log.debug("Removing proxy for entity {}", proxy);
        T realObject = this.proxifier.removeProxy(proxy);
        return realObject;
    }

    public <T> List<T> removeProxy(List<T> proxies) {
        log.debug("Removing proxy for a list of entities {}", proxies);
        return this.proxifier.removeProxy(proxies);
    }

    public <T> Set<T> removeProxy(Set<T> proxies) {
        log.debug("Removing proxy for a set of entities {}", proxies);
        return this.proxifier.removeProxy(proxies);
    }

    public <T> SliceQueryBuilder<T> sliceQuery(Class<T> entityClass) {
        log.debug("Execute slice query for entity class {}", entityClass);
        EntityMeta meta = this.entityMetaMap.get(entityClass);
        Validator.validateTrue(meta.isClusteredEntity(), "Cannot perform slice query on entity type '%s' because it is not a clustered entity", meta.getClassName());
        return new SliceQueryBuilder<T>(this.sliceQueryExecutor, entityClass, meta);
    }

    public NativeQuery nativeQuery(String queryString, Object ... boundValues) {
        return this.nativeQuery(queryString, OptionsBuilder.noOptions(), boundValues);
    }

    public NativeQuery nativeQuery(String queryString, Options options, Object ... boundValues) {
        log.debug("Execute native query {}", (Object)queryString);
        Validator.validateNotBlank(queryString, "The query string for native query should not be blank", new Object[0]);
        return new NativeQuery(this.daoContext, queryString, options, boundValues);
    }

    public <T> TypedQuery<T> typedQuery(Class<T> entityClass, String queryString, Object ... boundValues) {
        return this.typedQueryInternal(entityClass, queryString, true, boundValues);
    }

    private <T> TypedQuery<T> typedQueryInternal(Class<T> entityClass, String queryString, boolean normalizeQuery, Object ... boundValues) {
        log.debug("Execute typed query for entity class {}", entityClass);
        Validator.validateNotNull(entityClass, "The entityClass for typed query should not be null", new Object[0]);
        Validator.validateNotBlank(queryString, "The query string for typed query should not be blank", new Object[0]);
        Validator.validateTrue(this.entityMetaMap.containsKey(entityClass), "Cannot perform typed query because the entityClass '%s' is not managed by Achilles", entityClass.getCanonicalName());
        EntityMeta meta = this.entityMetaMap.get(entityClass);
        this.typedQueryValidator.validateTypedQuery(entityClass, queryString, meta);
        return new TypedQuery<T>(entityClass, this.daoContext, queryString, meta, this.contextFactory, EntityMeta.EntityState.MANAGED, normalizeQuery, boundValues);
    }

    public <T> TypedQuery<T> indexedQuery(Class<T> entityClass, IndexCondition indexCondition) {
        log.debug("Execute indexed query for entity class {}", entityClass);
        EntityMeta entityMeta = this.entityMetaMap.get(entityClass);
        Validator.validateFalse(entityMeta.isClusteredEntity(), "Index query is not supported for clustered entity. Please use typed query/native query", new Object[0]);
        Validator.validateNotNull(indexCondition, "Index condition should not be null", new Object[0]);
        entityMeta.encodeIndexConditionValue(indexCondition);
        String indexColumnName = indexCondition.getColumnName();
        Select.Where query = QueryBuilder.select().from(entityMeta.getTableName()).where(QueryBuilder.eq((String)indexColumnName, (Object)QueryBuilder.bindMarker((String)indexColumnName)));
        return this.typedQueryInternal(entityClass, query.getQueryString(), false, indexCondition.getColumnValue());
    }

    public <T> TypedQuery<T> rawTypedQuery(Class<T> entityClass, String queryString, Object ... boundValues) {
        log.debug("Execute raw typed query for entity class {}", entityClass);
        Validator.validateNotNull(entityClass, "The entityClass for typed query should not be null", new Object[0]);
        Validator.validateNotBlank(queryString, "The query string for typed query should not be blank", new Object[0]);
        Validator.validateTrue(this.entityMetaMap.containsKey(entityClass), "Cannot perform typed query because the entityClass '%s' is not managed by Achilles", entityClass.getCanonicalName());
        EntityMeta meta = this.entityMetaMap.get(entityClass);
        this.typedQueryValidator.validateRawTypedQuery(entityClass, queryString, meta);
        return new TypedQuery<T>(entityClass, this.daoContext, queryString, meta, this.contextFactory, EntityMeta.EntityState.NOT_MANAGED, true, boundValues);
    }

    public String jsonSerialize(Object entity) throws IOException {
        Validator.validateNotNull(entity, "Cannot serialize to JSON null entity", new Object[0]);
        ObjectMapper objectMapper = this.configContext.getMapperFor(entity.getClass());
        return objectMapper.writeValueAsString(entity);
    }

    public <T> T deserializeJson(Class<T> type, String serialized) throws IOException {
        Validator.validateNotNull(type, "Cannot deserialize from JSON if target type is null", new Object[0]);
        ObjectMapper objectMapper = this.configContext.getMapperFor(type);
        return (T)objectMapper.readValue(serialized, type);
    }

    protected PersistenceManagerOperations initPersistenceContext(Class<?> entityClass, Object primaryKey, Options options) {
        return this.contextFactory.newContext(entityClass, primaryKey, options).getPersistenceManagerFacade();
    }

    protected PersistenceManagerOperations initPersistenceContext(Object entity, Options options) {
        return this.contextFactory.newContext(entity, options).getPersistenceManagerFacade();
    }

    public Session getNativeSession() {
        return this.daoContext.getSession();
    }

    protected Map<Class<?>, EntityMeta> getEntityMetaMap() {
        return this.entityMetaMap;
    }

    protected ConfigurationContext getConfigContext() {
        return this.configContext;
    }

    protected void setEntityMetaMap(Map<Class<?>, EntityMeta> entityMetaMap) {
        this.entityMetaMap = entityMetaMap;
    }

    protected void setConfigContext(ConfigurationContext configContext) {
        this.configContext = configContext;
    }
}

