/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.persistence;

import com.datastax.driver.core.ConsistencyLevel;
import com.google.common.base.Optional;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.exception.AchillesStaleObjectStateException;
import info.archinnov.achilles.internal.consistency.ConsistencyConverter;
import info.archinnov.achilles.internal.context.BatchingFlushContext;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.context.facade.PersistenceManagerOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.utils.UUIDGen;
import info.archinnov.achilles.persistence.PersistenceManager;
import info.archinnov.achilles.type.Options;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Batch
extends PersistenceManager {
    private static final Logger log = LoggerFactory.getLogger(Batch.class);
    protected BatchingFlushContext flushContext;
    private final info.archinnov.achilles.type.ConsistencyLevel defaultConsistencyLevel;
    private final boolean orderedBatch;

    Batch(Map<Class<?>, EntityMeta> entityMetaMap, PersistenceContextFactory contextFactory, DaoContext daoContext, ConfigurationContext configContext, boolean orderedBatch) {
        super(entityMetaMap, contextFactory, daoContext, configContext);
        this.defaultConsistencyLevel = configContext.getDefaultWriteConsistencyLevel();
        this.orderedBatch = orderedBatch;
        this.flushContext = new BatchingFlushContext(daoContext, this.defaultConsistencyLevel, (Optional<ConsistencyLevel>)Optional.absent());
    }

    public void startBatch() {
        log.debug("Starting batch mode");
        this.flushContext = this.flushContext.duplicateWithNoData(this.defaultConsistencyLevel);
    }

    public void startBatch(info.archinnov.achilles.type.ConsistencyLevel consistencyLevel) {
        log.debug("Starting batch mode with consistency level {}", (Object)consistencyLevel.name());
        this.flushContext = this.flushContext.duplicateWithNoData(consistencyLevel);
    }

    public void startBatch(info.archinnov.achilles.type.ConsistencyLevel consistencyLevel, info.archinnov.achilles.type.ConsistencyLevel serialConsistency) {
        log.debug("Starting batch mode with consistency level {}", (Object)consistencyLevel.name());
        Optional serialConsistencyLevel = Optional.absent();
        if (serialConsistency != null) {
            serialConsistencyLevel = Optional.fromNullable((Object)ConsistencyConverter.getCQLLevel(serialConsistency));
        }
        this.flushContext = this.flushContext.duplicateWithNoData(consistencyLevel, (Optional<ConsistencyLevel>)serialConsistencyLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endBatch() {
        log.debug("Ending batch mode");
        try {
            this.flushContext.endBatch();
        }
        finally {
            this.flushContext = this.flushContext.duplicateWithNoData(this.defaultConsistencyLevel);
        }
    }

    public void cleanBatch() {
        log.debug("Cleaning all pending statements");
        this.flushContext = this.flushContext.duplicateWithNoData(this.defaultConsistencyLevel);
    }

    @Override
    public <T> T persist(T entity, Options options) {
        if (options.getConsistencyLevel().isPresent()) {
            this.flushContext = this.flushContext.duplicateWithNoData();
            throw new AchillesException("Runtime custom Consistency Level cannot be set for batch mode. Please set the Consistency Levels at batch start with 'startBatch(consistencyLevel)'");
        }
        return super.persist(entity, this.maybeAddTimestampToStatement(options));
    }

    @Override
    public void update(Object entity, Options options) {
        if (options.getConsistencyLevel().isPresent()) {
            this.flushContext = this.flushContext.duplicateWithNoData();
            throw new AchillesException("Runtime custom Consistency Level cannot be set for batch mode. Please set the Consistency Levels at batch start with 'startBatch(consistencyLevel)'");
        }
        super.update(entity, this.maybeAddTimestampToStatement(options));
    }

    @Override
    public void remove(Object entity, Options options) {
        if (options.getConsistencyLevel().isPresent()) {
            this.flushContext = this.flushContext.duplicateWithNoData();
            throw new AchillesException("Runtime custom Consistency Level cannot be set for batch mode. Please set the Consistency Levels at batch start with 'startBatch(consistencyLevel)'");
        }
        super.remove(entity, this.maybeAddTimestampToStatement(options));
    }

    @Override
    public <T> T find(Class<T> entityClass, Object primaryKey, info.archinnov.achilles.type.ConsistencyLevel readLevel) {
        if (readLevel != null) {
            this.flushContext = this.flushContext.duplicateWithNoData();
            throw new AchillesException("Runtime custom Consistency Level cannot be set for batch mode. Please set the Consistency Levels at batch start with 'startBatch(consistencyLevel)'");
        }
        return super.find(entityClass, primaryKey, null);
    }

    @Override
    public <T> T getProxy(Class<T> entityClass, Object primaryKey, info.archinnov.achilles.type.ConsistencyLevel readLevel) {
        if (readLevel != null) {
            this.flushContext = this.flushContext.duplicateWithNoData();
            throw new AchillesException("Runtime custom Consistency Level cannot be set for batch mode. Please set the Consistency Levels at batch start with 'startBatch(consistencyLevel)'");
        }
        return super.getProxy(entityClass, primaryKey, null);
    }

    @Override
    public void refresh(Object entity, info.archinnov.achilles.type.ConsistencyLevel readLevel) throws AchillesStaleObjectStateException {
        if (readLevel != null) {
            this.flushContext = this.flushContext.duplicateWithNoData();
            throw new AchillesException("Runtime custom Consistency Level cannot be set for batch mode. Please set the Consistency Levels at batch start with 'startBatch(consistencyLevel)'");
        }
        super.refresh(entity, null);
    }

    @Override
    protected PersistenceManagerOperations initPersistenceContext(Class<?> entityClass, Object primaryKey, Options options) {
        log.trace("Initializing new persistence context for entity class {} and primary key {}", (Object)entityClass.getCanonicalName(), primaryKey);
        return this.contextFactory.newContextWithFlushContext(entityClass, primaryKey, options, this.flushContext).getPersistenceManagerFacade();
    }

    @Override
    protected PersistenceManagerOperations initPersistenceContext(Object entity, Options options) {
        log.trace("Initializing new persistence context for entity {}", entity);
        return this.contextFactory.newContextWithFlushContext(entity, options, this.flushContext).getPersistenceManagerFacade();
    }

    private Options maybeAddTimestampToStatement(Options options) {
        if (this.orderedBatch) {
            return options.duplicateWithNewTimestamp(UUIDGen.increasingMicroTimestamp());
        }
        return options;
    }
}

