/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.table;

import com.datastax.driver.core.ColumnMetadata;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.TableMetadata;
import info.archinnov.achilles.internal.cql.TypeMapper;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.InternalTimeUUID;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.table.ColumnMetaDataComparator;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.Counter;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableValidator {
    private static final Logger log = LoggerFactory.getLogger(TableValidator.class);
    private ColumnMetaDataComparator columnMetaDataComparator = new ColumnMetaDataComparator();

    public void validateForEntity(EntityMeta entityMeta, TableMetadata tableMetadata) {
        log.debug("Validate existing table {} for {}", (Object)tableMetadata.getName(), (Object)entityMeta);
        PropertyMeta idMeta = entityMeta.getIdMeta();
        this.validateTable(entityMeta, tableMetadata, idMeta);
    }

    private void validateTable(EntityMeta entityMeta, TableMetadata tableMetadata, PropertyMeta idMeta) {
        if (idMeta.isEmbeddedId()) {
            this.validatePrimaryKeyComponents(tableMetadata, idMeta, true);
            this.validatePrimaryKeyComponents(tableMetadata, idMeta, false);
        } else {
            this.validateColumn(tableMetadata, idMeta.getCQL3PropertyName(), idMeta.getValueClassForTableCreation(), idMeta.isIndexed(), entityMeta.isSchemaUpdateEnabled());
        }
        for (PropertyMeta pm : entityMeta.getAllMetasExceptIdAndCounters()) {
            switch (pm.type()) {
                case SIMPLE: {
                    this.validateColumn(tableMetadata, pm.getCQL3PropertyName(), pm.getValueClassForTableCreation(), pm.isIndexed(), entityMeta.isSchemaUpdateEnabled());
                    break;
                }
                case LIST: 
                case SET: 
                case MAP: {
                    this.validateCollectionAndMapColumn(tableMetadata, pm, entityMeta.isSchemaUpdateEnabled());
                    break;
                }
            }
        }
        for (PropertyMeta counterMeta : entityMeta.getAllCounterMetas()) {
            this.validateCounterColumnForClusteredCounters(tableMetadata, counterMeta, entityMeta.isSchemaUpdateEnabled());
        }
    }

    public void validateAchillesCounter(KeyspaceMetadata keyspaceMetaData, String keyspaceName) {
        log.debug("Validate existing Achilles Counter table");
        DataType.Name textTypeName = DataType.text().getName();
        DataType.Name counterTypeName = DataType.counter().getName();
        TableMetadata tableMetaData = keyspaceMetaData.getTable("achilles_counter_table");
        Validator.validateTableTrue(tableMetaData != null, "Cannot find table '%s' from keyspace '%s'", "achilles_counter_table", keyspaceName);
        ColumnMetadata fqcnColumn = tableMetaData.getColumn("fqcn");
        Validator.validateTableTrue(fqcnColumn != null, "Cannot find column '%s' from table '%s'", "fqcn", "achilles_counter_table");
        Validator.validateTableTrue(fqcnColumn.getType().getName() == textTypeName, "Column '%s' of type '%s' should be of type '%s'", "fqcn", fqcnColumn.getType().getName(), textTypeName);
        Validator.validateBeanMappingTrue(this.hasColumnMeta(tableMetaData.getPartitionKey(), fqcnColumn), "Column '%s' of table '%s' should be a partition key component", "fqcn", "achilles_counter_table");
        ColumnMetadata pkColumn = tableMetaData.getColumn("primary_key");
        Validator.validateTableTrue(pkColumn != null, "Cannot find column '%s' from table '%s'", "primary_key", "achilles_counter_table");
        Validator.validateTableTrue(pkColumn.getType().getName() == textTypeName, "Column '%s' of type '%s' should be of type '%s'", "primary_key", pkColumn.getType().getName(), textTypeName);
        Validator.validateBeanMappingTrue(this.hasColumnMeta(tableMetaData.getPartitionKey(), pkColumn), "Column '%s' of table '%s' should be a partition key component", "primary_key", "achilles_counter_table");
        ColumnMetadata propertyNameColumn = tableMetaData.getColumn("property_name");
        Validator.validateTableTrue(propertyNameColumn != null, "Cannot find column '%s' from table '%s'", "property_name", "achilles_counter_table");
        Validator.validateTableTrue(propertyNameColumn.getType().getName() == textTypeName, "Column '%s' of type '%s' should be of type '%s'", "property_name", propertyNameColumn.getType().getName(), textTypeName);
        Validator.validateBeanMappingTrue(this.hasColumnMeta(tableMetaData.getClusteringColumns(), propertyNameColumn), "Column '%s' of table '%s' should be a clustering key component", "property_name", "achilles_counter_table");
        ColumnMetadata counterValueColumn = tableMetaData.getColumn("counter_value");
        Validator.validateTableTrue(counterValueColumn != null, "Cannot find column '%s' from table '%s'", "counter_value", "achilles_counter_table");
        Validator.validateTableTrue(counterValueColumn.getType().getName() == counterTypeName, "Column '%s' of type '%s' should be of type '%s'", "counter_value", counterValueColumn.getType().getName(), counterTypeName);
    }

    private void validateColumn(TableMetadata tableMetaData, String columnName, Class<?> columnJavaType, boolean indexed, boolean schemaUpdateEnabled) {
        log.debug("Validate existing column {} from table {} against type {}", new Object[]{columnName, tableMetaData.getName(), columnJavaType});
        String tableName = tableMetaData.getName();
        ColumnMetadata columnMetadata = tableMetaData.getColumn(columnName);
        DataType.Name expectedType = TypeMapper.toCQLType(columnJavaType);
        if (schemaUpdateEnabled && columnMetadata == null) {
            return;
        }
        Validator.validateTableTrue(columnMetadata != null, "Cannot find column '%s' in the table '%s'", columnName, tableName);
        boolean columnIsIndexed = columnMetadata.getIndex() != null;
        Validator.validateTableFalse(columnIsIndexed ^ indexed, "Column '%s' in the table '%s' is indexed (or not) whereas metadata indicates it is (or not)", columnName, tableName);
        DataType.Name realType = columnMetadata.getType().getName();
        if (realType == DataType.Name.CUSTOM) {
            realType = DataType.Name.BLOB;
        }
        Validator.validateTableTrue(expectedType == realType, "Column '%s' of table '%s' of type '%s' should be of type '%s' indeed", columnName, tableName, realType, expectedType);
    }

    private void validateCounterColumnForClusteredCounters(TableMetadata tableMetaData, PropertyMeta propertyMeta, boolean schemaUpdateEnabled) {
        String columnName = propertyMeta.getPropertyName().toLowerCase();
        log.debug("Validate existing column {} from table {} against type {}", new Object[]{columnName, tableMetaData.getName(), Counter.class});
        String tableName = tableMetaData.getName();
        ColumnMetadata columnMetadata = tableMetaData.getColumn(columnName);
        if (schemaUpdateEnabled && columnMetadata == null) {
            return;
        }
        Validator.validateTableTrue(columnMetadata != null, "Cannot find column '%s' in the table '%s'", columnName, tableName);
        DataType.Name realType = columnMetadata.getType().getName();
        Validator.validateTableTrue(realType == DataType.Name.COUNTER, "Column '%s' of table '%s' of type '%s' should be of type '%s' indeed", columnName, tableName, realType, DataType.Name.COUNTER);
    }

    private void validatePartitionComponent(TableMetadata tableMetaData, String columnName, Class<?> columnJavaType) {
        log.debug("Validate existing partition key component {} from table {} against type {}", new Object[]{columnName, tableMetaData.getName(), columnJavaType});
        this.validateColumn(tableMetaData, columnName, columnJavaType, false, false);
        ColumnMetadata columnMetadata = tableMetaData.getColumn(columnName);
        Validator.validateBeanMappingTrue(this.hasColumnMeta(tableMetaData.getPartitionKey(), columnMetadata), "Column '%s' of table '%s' should be a partition key component", columnName, tableMetaData.getName());
    }

    private void validateClusteringComponent(TableMetadata tableMetaData, String columnName, Class<?> columnJavaType) {
        log.debug("Validate existing clustering column {} from table {} against type {}", new Object[]{columnName, tableMetaData.getName(), columnJavaType});
        this.validateColumn(tableMetaData, columnName, columnJavaType, false, false);
        ColumnMetadata columnMetadata = tableMetaData.getColumn(columnName);
        Validator.validateBeanMappingTrue(this.hasColumnMeta(tableMetaData.getClusteringColumns(), columnMetadata), "Column '%s' of table '%s' should be a clustering key component", columnName, tableMetaData.getName());
    }

    private void validateCollectionAndMapColumn(TableMetadata tableMetadata, PropertyMeta pm, boolean schemaUpdateEnabled) {
        log.debug("Validate existing collection/map column {} from table {}");
        String columnName = pm.getPropertyName().toLowerCase();
        String tableName = tableMetadata.getName();
        ColumnMetadata columnMetadata = tableMetadata.getColumn(columnName);
        if (schemaUpdateEnabled && columnMetadata == null) {
            return;
        }
        Validator.validateTableTrue(columnMetadata != null, "Cannot find column '%s' in the table '%s'", columnName, tableName);
        DataType.Name realType = columnMetadata.getType().getName();
        DataType.Name expectedValueType = TypeMapper.toCQLType(pm.getValueClassForTableCreation());
        switch (pm.type()) {
            case LIST: {
                Validator.validateTableTrue(realType == DataType.Name.LIST, "Column '%s' of table '%s' of type '%s' should be of type '%s' indeed", columnName, tableName, realType, DataType.Name.LIST);
                DataType.Name realListValueType = ((DataType)columnMetadata.getType().getTypeArguments().get(0)).getName();
                Validator.validateTableTrue(realListValueType == expectedValueType, "Column '%s' of table '%s' of type 'List<%s>' should be of type 'List<%s>' indeed", columnName, tableName, realListValueType, expectedValueType);
                break;
            }
            case SET: {
                Validator.validateTableTrue(realType == DataType.Name.SET, "Column '%s' of table '%s' of type '%s' should be of type '%s' indeed", columnName, tableName, realType, DataType.Name.SET);
                DataType.Name realSetValueType = ((DataType)columnMetadata.getType().getTypeArguments().get(0)).getName();
                Validator.validateTableTrue(realSetValueType == expectedValueType, "Column '%s' of table '%s' of type 'Set<%s>' should be of type 'Set<%s>' indeed", columnName, tableName, realSetValueType, expectedValueType);
                break;
            }
            case MAP: {
                Validator.validateTableTrue(realType == DataType.Name.MAP, "Column '%s' of table '%s' of type '%s' should be of type '%s' indeed", columnName, tableName, realType, DataType.Name.MAP);
                DataType.Name expectedMapKeyType = TypeMapper.toCQLType(pm.getKeyClass());
                DataType.Name realMapKeyType = ((DataType)columnMetadata.getType().getTypeArguments().get(0)).getName();
                DataType.Name realMapValueType = ((DataType)columnMetadata.getType().getTypeArguments().get(1)).getName();
                Validator.validateTableTrue(realMapKeyType == expectedMapKeyType, "Column %s' of table '%s' of type 'Map<%s,?>' should be of type 'Map<%s,?>' indeed", columnName, tableName, realMapKeyType, expectedMapKeyType);
                Validator.validateTableTrue(realMapValueType == expectedValueType, "Column '%s' of table '%s' of type 'Map<?,%s>' should be of type 'Map<?,%s>' indeed", columnName, tableName, realMapValueType, expectedValueType);
                break;
            }
        }
    }

    private void validatePrimaryKeyComponents(TableMetadata tableMetadata, PropertyMeta idMeta, boolean partitionKey) {
        List<Class<?>> componentClasses;
        List<String> componentNames;
        log.debug("Validate existing primary key component from table {} against Achilles meta data {}", (Object)tableMetadata.getName(), (Object)idMeta);
        if (partitionKey) {
            componentNames = idMeta.getPartitionComponentNames();
            componentClasses = idMeta.getPartitionComponentClasses();
        } else {
            componentNames = idMeta.getClusteringComponentNames();
            componentClasses = idMeta.getClusteringComponentClasses();
        }
        for (int i = 0; i < componentNames.size(); ++i) {
            Class<Object> componentClass = componentClasses.get(i);
            String componentName = componentNames.get(i);
            if (idMeta.isPrimaryKeyTimeUUID(componentName)) {
                componentClass = InternalTimeUUID.class;
            }
            if (partitionKey) {
                this.validatePartitionComponent(tableMetadata, componentName.toLowerCase(), componentClass);
                continue;
            }
            this.validateClusteringComponent(tableMetadata, componentName.toLowerCase(), componentClass);
        }
    }

    private boolean hasColumnMeta(Collection<ColumnMetadata> columnMetadatas, ColumnMetadata fqcnColumn) {
        boolean fqcnColumnMatches = false;
        for (ColumnMetadata columnMetadata : columnMetadatas) {
            fqcnColumnMatches = fqcnColumnMatches || this.columnMetaDataComparator.isEqual(fqcnColumn, columnMetadata);
        }
        return fqcnColumnMatches;
    }
}

