/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.table;

import info.archinnov.achilles.exception.AchillesInvalidTableException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableNameNormalizer {
    protected static final Logger log = LoggerFactory.getLogger(TableNameNormalizer.class);
    public static final Pattern CF_PATTERN = Pattern.compile("[a-zA-Z0-9_]{1,48}");

    public static String normalizerAndValidateColumnFamilyName(String cfName) {
        log.trace("Normalizing table '{}' name against Cassandra restrictions", (Object)cfName);
        Matcher nameMatcher = CF_PATTERN.matcher(cfName);
        if (nameMatcher.matches()) {
            return cfName;
        }
        if (cfName.contains(".")) {
            String className = cfName.replaceAll(".+\\.(.+)", "$1");
            return TableNameNormalizer.normalizerAndValidateColumnFamilyName(className);
        }
        throw new AchillesInvalidTableException("The table name '" + cfName + "' is invalid. It should be respect the pattern [a-zA-Z0-9_] and be at most 48 characters long");
    }
}

