/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.table;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import info.archinnov.achilles.exception.AchillesInvalidTableException;
import info.archinnov.achilles.internal.cql.TypeMapper;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.InternalTimeUUID;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.table.TableNameNormalizer;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.schemabuilder.Create;
import info.archinnov.achilles.schemabuilder.SchemaBuilder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableCreator {
    static final String ACHILLES_DDL_SCRIPT = "ACHILLES_DDL_SCRIPT";
    public static final String TABLE_PATTERN = "[a-zA-Z0-9_]+";
    private static final Logger log = LoggerFactory.getLogger(TableCreator.class);
    private static final Logger DML_LOG = LoggerFactory.getLogger((String)"ACHILLES_DDL_SCRIPT");

    public Map<String, TableMetadata> fetchTableMetaData(KeyspaceMetadata keyspaceMeta, String keyspaceName) {
        log.debug("Fetch existing table meta data from Cassandra");
        HashMap<String, TableMetadata> tableMetas = new HashMap<String, TableMetadata>();
        Validator.validateTableTrue(keyspaceMeta != null, "Keyspace '%s' doest not exist or cannot be found", keyspaceName);
        for (TableMetadata tableMeta : keyspaceMeta.getTables()) {
            tableMetas.put(tableMeta.getName(), tableMeta);
        }
        return tableMetas;
    }

    public void createTableForEntity(Session session, EntityMeta entityMeta, boolean forceColumnFamilyCreation) {
        log.debug("Create table for entity {}", (Object)entityMeta);
        String tableName = entityMeta.getTableName().toLowerCase();
        if (!forceColumnFamilyCreation) {
            throw new AchillesInvalidTableException("The required table '" + tableName + "' does not exist for entity '" + entityMeta.getClassName() + "'");
        }
        log.debug("Force creation of table for entityMeta {}", (Object)entityMeta.getClassName());
        this.createTableForEntity(session, entityMeta);
    }

    private void createTableForEntity(Session session, EntityMeta entityMeta) {
        log.debug("Creating table for entityMeta {}", (Object)entityMeta.getClassName());
        if (entityMeta.isClusteredCounter()) {
            this.createTableForClusteredCounter(session, entityMeta);
        } else {
            this.createTable(session, entityMeta);
        }
    }

    public void createTableForCounter(Session session, boolean forceColumnFamilyCreation) {
        log.debug("Create table for Achilles counters");
        if (!forceColumnFamilyCreation) {
            throw new AchillesInvalidTableException("The required generic table 'achilles_counter_table' does not exist");
        }
        String createTable = ((Create.Options)SchemaBuilder.createTable("achilles_counter_table").addPartitionKey("fqcn", DataType.text()).addPartitionKey("primary_key", DataType.text()).addClusteringKey("property_name", DataType.text()).addColumn("counter_value", DataType.counter()).withOptions().comment("Create default Achilles counter table \"achilles_counter_table\"")).build();
        session.execute(createTable);
    }

    private void createTable(Session session, EntityMeta entityMeta) {
        String tableName = TableNameNormalizer.normalizerAndValidateColumnFamilyName(entityMeta.getTableName());
        LinkedList<String> indexes = new LinkedList<String>();
        Create createTable = SchemaBuilder.createTable(tableName);
        for (PropertyMeta pm : entityMeta.getAllMetasExceptIdAndCounters()) {
            String propertyName = pm.getCQL3PropertyName();
            Class keyClass = pm.getKeyClass();
            Class<?> valueClass = pm.getValueClassForTableCreation();
            boolean staticColumn = pm.isStaticColumn();
            switch (pm.type()) {
                case SIMPLE: {
                    createTable.addColumn(propertyName, TypeMapper.toCQLDataType(valueClass), staticColumn);
                    if (!pm.isIndexed()) break;
                    String optionalIndexName = pm.getIndexProperties().getIndexName();
                    String indexName = StringUtils.isBlank((String)optionalIndexName) ? tableName + "_" + propertyName : optionalIndexName;
                    indexes.add(SchemaBuilder.createIndex(indexName).onTable(tableName).andColumn(propertyName));
                    break;
                }
                case LIST: {
                    createTable.addColumn(propertyName, DataType.list((DataType)TypeMapper.toCQLDataType(valueClass)), staticColumn);
                    break;
                }
                case SET: {
                    createTable.addColumn(propertyName, DataType.set((DataType)TypeMapper.toCQLDataType(valueClass)), staticColumn);
                    break;
                }
                case MAP: {
                    createTable.addColumn(propertyName, DataType.map((DataType)TypeMapper.toCQLDataType(keyClass), (DataType)TypeMapper.toCQLDataType(valueClass)), staticColumn);
                    break;
                }
            }
        }
        PropertyMeta idMeta = entityMeta.getIdMeta();
        this.buildPrimaryKey(idMeta, createTable);
        Create.Options tableOptions = createTable.withOptions();
        this.addClusteringOrder(idMeta, tableOptions);
        tableOptions.comment("Create table for entity \"" + entityMeta.getClassName() + "\"");
        String createTableScript = tableOptions.build();
        session.execute(createTableScript);
        DML_LOG.debug(createTableScript);
        if (!indexes.isEmpty()) {
            for (String indexScript : indexes) {
                session.execute(indexScript);
                DML_LOG.debug(indexScript);
            }
        }
    }

    private void createTableForClusteredCounter(Session session, EntityMeta meta) {
        log.debug("Creating table for clustered counter entity {}", (Object)meta.getClassName());
        Create createTable = SchemaBuilder.createTable(TableNameNormalizer.normalizerAndValidateColumnFamilyName(meta.getTableName()));
        PropertyMeta idMeta = meta.getIdMeta();
        this.buildPrimaryKey(idMeta, createTable);
        for (PropertyMeta counterMeta : meta.getAllCounterMetas()) {
            createTable.addColumn(counterMeta.getCQL3PropertyName(), DataType.counter(), counterMeta.isStaticColumn());
        }
        Create.Options tableOptions = createTable.withOptions();
        this.addClusteringOrder(idMeta, tableOptions);
        tableOptions.comment("Create table for clustered counter entity \"" + meta.getClassName() + "\"");
        String createTableScript = tableOptions.build();
        session.execute(createTableScript);
        DML_LOG.debug(createTableScript);
    }

    private void addClusteringOrder(PropertyMeta idMeta, Create.Options tableOptions) {
        if (idMeta.isClustered()) {
            List<Create.Options.ClusteringOrder> clusteringOrders = idMeta.getClusteringOrders();
            tableOptions.clusteringOrder(clusteringOrders.toArray(new Create.Options.ClusteringOrder[clusteringOrders.size()]));
        }
    }

    private List<Create.Options.ClusteringOrder> buildPrimaryKey(PropertyMeta pm, Create createTable) {
        LinkedList<Create.Options.ClusteringOrder> clusteringOrders = new LinkedList<Create.Options.ClusteringOrder>();
        if (pm.isEmbeddedId()) {
            this.addPartitionKeys(pm, createTable);
            this.addClusteringKeys(pm, createTable);
        } else {
            String columnName = pm.getPropertyName();
            createTable.addPartitionKey(columnName, TypeMapper.toCQLDataType(pm.getValueClassForTableCreation()));
        }
        return clusteringOrders;
    }

    private void addPartitionKeys(PropertyMeta pm, Create createTable) {
        List<String> componentNames = pm.getPartitionComponentNames();
        List<Class<?>> componentClasses = pm.getPartitionComponentClasses();
        for (int i = 0; i < componentNames.size(); ++i) {
            String componentName = componentNames.get(i);
            Class<InternalTimeUUID> javaType = pm.isPrimaryKeyTimeUUID(componentName) ? InternalTimeUUID.class : componentClasses.get(i);
            createTable.addPartitionKey(componentName, TypeMapper.toCQLDataType(javaType));
        }
    }

    private void addClusteringKeys(PropertyMeta pm, Create createTable) {
        List<String> componentNames = pm.getClusteringComponentNames();
        List<Class<?>> componentClasses = pm.getClusteringComponentClasses();
        for (int i = 0; i < componentNames.size(); ++i) {
            String componentName = componentNames.get(i);
            Class<InternalTimeUUID> javaType = pm.isPrimaryKeyTimeUUID(componentName) ? InternalTimeUUID.class : componentClasses.get(i);
            createTable.addClusteringKey(componentName, TypeMapper.toCQLDataType(javaType));
        }
    }
}

