/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.wrapper;

import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.google.common.base.Optional;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.listener.CASResultListener;

public class SimpleStatementWrapper
extends AbstractStatementWrapper {
    private SimpleStatement simpleStatement;

    public SimpleStatementWrapper(String query, Object[] values, Optional<CASResultListener> casResultListener) {
        super(null, values);
        this.casResultListener = casResultListener;
        this.simpleStatement = new SimpleStatement(query);
    }

    @Override
    public ResultSet execute(Session session) {
        this.logDMLStatement("");
        String queryString = this.simpleStatement.getQueryString();
        SimpleStatement statement = new SimpleStatement(queryString, this.values);
        this.activateQueryTracing((Statement)statement);
        ResultSet resultSet = session.execute((Statement)statement);
        this.tracing(resultSet);
        this.checkForCASSuccess(queryString, resultSet);
        return resultSet;
    }

    public SimpleStatement getStatement() {
        return this.simpleStatement;
    }

    @Override
    public void logDMLStatement(String indentation) {
        if (dmlLogger.isDebugEnabled()) {
            String queryType = "Simple statement";
            String queryString = this.simpleStatement.getQueryString();
            String consistencyLevel = this.simpleStatement.getConsistencyLevel() == null ? "DEFAULT" : this.simpleStatement.getConsistencyLevel().name();
            this.writeDMLStatementLog(queryType, queryString, consistencyLevel, this.values);
        }
    }
}

