/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.wrapper;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.base.Optional;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.listener.CASResultListener;

public class RegularStatementWrapper
extends AbstractStatementWrapper {
    private RegularStatement regularStatement;

    public RegularStatementWrapper(Class<?> entityClass, RegularStatement regularStatement, Object[] boundValues, ConsistencyLevel consistencyLevel, Optional<CASResultListener> casResultListener, Optional<ConsistencyLevel> serialConsistencyLevel) {
        super(entityClass, boundValues);
        this.regularStatement = regularStatement;
        this.casResultListener = casResultListener;
        this.regularStatement.setConsistencyLevel(consistencyLevel);
        if (serialConsistencyLevel.isPresent()) {
            this.regularStatement.setSerialConsistencyLevel((ConsistencyLevel)serialConsistencyLevel.get());
        }
    }

    @Override
    public ResultSet execute(Session session) {
        this.logDMLStatement("");
        this.activateQueryTracing((Statement)this.regularStatement);
        ResultSet resultSet = session.execute((Statement)this.regularStatement);
        this.tracing(resultSet);
        this.checkForCASSuccess(this.regularStatement.getQueryString(), resultSet);
        return resultSet;
    }

    public RegularStatement getStatement() {
        return this.regularStatement;
    }

    @Override
    public void logDMLStatement(String indentation) {
        if (dmlLogger.isDebugEnabled()) {
            String queryType = "Parameterized statement";
            String queryString = this.regularStatement.getQueryString();
            String consistencyLevel = this.regularStatement.getConsistencyLevel() == null ? "DEFAULT" : this.regularStatement.getConsistencyLevel().name();
            this.writeDMLStatementLog(queryType, queryString, consistencyLevel, this.values);
        }
    }
}

