/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.wrapper;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.base.Optional;
import info.archinnov.achilles.internal.statement.wrapper.AbstractStatementWrapper;
import info.archinnov.achilles.listener.CASResultListener;

public class BoundStatementWrapper
extends AbstractStatementWrapper {
    private BoundStatement boundStatement;

    public BoundStatementWrapper(Class<?> entityClass, BoundStatement bs, Object[] values, ConsistencyLevel consistencyLevel, Optional<CASResultListener> casResultListener, Optional<ConsistencyLevel> serialConsistencyLevel) {
        super(entityClass, values);
        this.casResultListener = casResultListener;
        this.boundStatement = bs;
        this.boundStatement.setConsistencyLevel(consistencyLevel);
        if (serialConsistencyLevel.isPresent()) {
            this.boundStatement.setSerialConsistencyLevel((ConsistencyLevel)serialConsistencyLevel.get());
        }
    }

    @Override
    public ResultSet execute(Session session) {
        this.logDMLStatement("");
        this.activateQueryTracing((Statement)this.boundStatement);
        ResultSet resultSet = session.execute((Statement)this.boundStatement);
        this.tracing(resultSet);
        this.checkForCASSuccess(this.boundStatement.preparedStatement().getQueryString(), resultSet);
        return resultSet;
    }

    public BoundStatement getStatement() {
        return this.boundStatement;
    }

    @Override
    public void logDMLStatement(String indentation) {
        if (dmlLogger.isDebugEnabled()) {
            PreparedStatement ps = this.boundStatement.preparedStatement();
            String queryType = "Prepared statement";
            String queryString = ps.getQueryString();
            String consistencyLevel = this.boundStatement.getConsistencyLevel() == null ? "DEFAULT" : this.boundStatement.getConsistencyLevel().name();
            this.writeDMLStatementLog(queryType, queryString, consistencyLevel, this.values);
        }
    }
}

