/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.wrapper;

import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ExecutionInfo;
import com.datastax.driver.core.QueryTrace;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.exceptions.TraceRetrievalException;
import com.google.common.base.Optional;
import info.archinnov.achilles.exception.AchillesCASException;
import info.archinnov.achilles.internal.reflection.RowMethodInvoker;
import info.archinnov.achilles.listener.CASResultListener;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.TypedMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStatementWrapper {
    public static final EventComparator EVENT_TRACE_COMPARATOR = new EventComparator();
    public static final String ACHILLES_DML_STATEMENT = "ACHILLES_DML_STATEMENT";
    protected static final String IF_NOT_EXIST_CLAUSE = " IF NOT EXISTS";
    protected static final String IF_CLAUSE = " IF ";
    protected static final String CAS_RESULT_COLUMN = "[applied]";
    protected static final Logger dmlLogger = LoggerFactory.getLogger((String)"ACHILLES_DML_STATEMENT");
    protected RowMethodInvoker invoker = new RowMethodInvoker();
    protected Optional<CASResultListener> casResultListener = Optional.absent();
    protected Object[] values = new Object[0];
    protected boolean traceQueryForEntity = false;
    protected boolean displayDMLForEntity = false;
    protected Logger entityLogger;

    protected AbstractStatementWrapper(Class<?> entityClass, Object[] values) {
        if (ArrayUtils.isNotEmpty((Object[])values)) {
            this.values = values;
        }
        if (entityClass != null && LoggerFactory.getLogger(entityClass) != null) {
            this.traceQueryForEntity = LoggerFactory.getLogger(entityClass).isTraceEnabled();
            this.displayDMLForEntity = LoggerFactory.getLogger(entityClass).isDebugEnabled();
            this.entityLogger = LoggerFactory.getLogger(entityClass);
        }
    }

    public Object[] getValues() {
        return this.values;
    }

    public abstract ResultSet execute(Session var1);

    public abstract Statement getStatement();

    public abstract void logDMLStatement(String var1);

    public static void writeDMLStartBatch(BatchStatement.Type batchType) {
        if (dmlLogger.isDebugEnabled()) {
            if (batchType == BatchStatement.Type.LOGGED) {
                dmlLogger.debug("");
                dmlLogger.debug("");
                dmlLogger.debug("****** BATCH LOGGED START ******");
                dmlLogger.debug("");
            } else {
                dmlLogger.debug("");
                dmlLogger.debug("");
                dmlLogger.debug("****** BATCH UNLOGGED START ******");
                dmlLogger.debug("");
            }
        }
    }

    public static void writeDMLEndBatch(BatchStatement.Type batchType, ConsistencyLevel consistencyLevel) {
        if (dmlLogger.isDebugEnabled()) {
            if (batchType == BatchStatement.Type.LOGGED) {
                dmlLogger.debug("");
                dmlLogger.debug("  ****** BATCH LOGGED END with CONSISTENCY LEVEL [{}] ******", consistencyLevel != null ? consistencyLevel : "DEFAULT");
                dmlLogger.debug("");
                dmlLogger.debug("");
            } else {
                dmlLogger.debug("");
                dmlLogger.debug("  ****** BATCH UNLOGGED END with CONSISTENCY LEVEL [{}] ******", consistencyLevel != null ? consistencyLevel : "DEFAULT");
                dmlLogger.debug("");
                dmlLogger.debug("");
            }
        }
    }

    protected void writeDMLStatementLog(String queryType, String queryString, String consistencyLevel, Object ... values) {
        Logger actualLogger = this.displayDMLForEntity ? this.entityLogger : dmlLogger;
        actualLogger.debug("{} : [{}] with CONSISTENCY LEVEL [{}]", new Object[]{queryType, queryString, consistencyLevel});
        if (ArrayUtils.isNotEmpty((Object[])values)) {
            actualLogger.debug("\t bound values : {}", Arrays.asList(values));
        }
    }

    protected boolean isCASInsert(String queryString) {
        return queryString.contains(IF_NOT_EXIST_CLAUSE);
    }

    protected boolean isCASOperation(String queryString) {
        return queryString.contains(IF_CLAUSE);
    }

    protected void checkForCASSuccess(String queryString, ResultSet resultSet) {
        if (this.isCASOperation(queryString)) {
            Row casResult = resultSet.one();
            if (!casResult.getBool(CAS_RESULT_COLUMN)) {
                TreeMap currentValues = new TreeMap();
                for (ColumnDefinitions.Definition columnDef : casResult.getColumnDefinitions()) {
                    String columnDefName = columnDef.getName();
                    Object columnValue = this.invoker.invokeOnRowForType(casResult, columnDef.getType().asJavaClass(), columnDefName);
                    currentValues.put(columnDefName, columnValue);
                }
                CASResultListener.CASResult.Operation operation = CASResultListener.CASResult.Operation.UPDATE;
                if (this.isCASInsert(queryString)) {
                    operation = CASResultListener.CASResult.Operation.INSERT;
                }
                this.notifyCASError(new CASResultListener.CASResult(operation, TypedMap.fromMap(currentValues)));
            } else {
                this.notifyCASSuccess();
            }
        }
    }

    protected void notifyCASError(CASResultListener.CASResult casResult) {
        if (!this.casResultListener.isPresent()) {
            throw new AchillesCASException(casResult);
        }
        ((CASResultListener)this.casResultListener.get()).onCASError(casResult);
    }

    protected void notifyCASSuccess() {
        if (this.casResultListener.isPresent()) {
            ((CASResultListener)this.casResultListener.get()).onCASSuccess();
        }
    }

    protected Statement activateQueryTracing(Statement statement) {
        if (dmlLogger.isTraceEnabled() || this.traceQueryForEntity) {
            statement.enableTracing();
        }
        return statement;
    }

    protected void tracing(ResultSet resultSet) {
        if (dmlLogger.isTraceEnabled() || this.traceQueryForEntity) {
            Logger actualLogger = this.traceQueryForEntity ? this.entityLogger : dmlLogger;
            for (ExecutionInfo executionInfo : resultSet.getAllExecutionInfo()) {
                actualLogger.trace("Query tracing at host {} with achieved consistency level {} ", (Object)executionInfo.getQueriedHost(), (Object)executionInfo.getAchievedConsistencyLevel());
                actualLogger.trace("****************************");
                actualLogger.trace(String.format("%1$-80s | %2$-16s | %3$-24s | %4$-20s", "Description", "Source", "Source elapsed in micros", "Thread name"));
                try {
                    ArrayList events = new ArrayList(executionInfo.getQueryTrace().getEvents());
                    Collections.sort(events, EVENT_TRACE_COMPARATOR);
                    for (QueryTrace.Event event : events) {
                        String formatted = String.format("%1$-80s | %2$-16s | %3$-24s | %4$-20s", event.getDescription(), event.getSource(), event.getSourceElapsedMicros(), event.getThreadName());
                        actualLogger.trace(formatted);
                    }
                }
                catch (TraceRetrievalException e) {
                    actualLogger.trace("Cannot retrieve asynchronous trace, reason: " + e.getMessage());
                }
                actualLogger.trace("****************************");
            }
        }
    }

    private static class EventComparator
    implements Comparator<QueryTrace.Event> {
        private EventComparator() {
        }

        @Override
        public int compare(QueryTrace.Event event1, QueryTrace.Event event2) {
            return event1.getSource().toString().compareTo(event2.getSource().toString());
        }
    }
}

