/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.prepared;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import info.archinnov.achilles.counter.AchillesCounter;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.CollectionAndMapChangeType;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyCheckChangeSet;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.OptionsBuilder;
import info.archinnov.achilles.type.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementGenerator {
    private static final Logger log = LoggerFactory.getLogger(PreparedStatementGenerator.class);

    public PreparedStatement prepareInsert(Session session, EntityMeta entityMeta, List<PropertyMeta> pms, Options options) {
        log.trace("Generate prepared statement for INSERT on {}", (Object)entityMeta);
        PropertyMeta idMeta = entityMeta.getIdMeta();
        Insert insert = QueryBuilder.insertInto((String)entityMeta.getTableName());
        if (options.isIfNotExists()) {
            insert.ifNotExists();
        }
        this.prepareInsertPrimaryKey(idMeta, insert);
        for (PropertyMeta pm : pms) {
            String property = pm.getPropertyName();
            insert.value(property, (Object)QueryBuilder.bindMarker((String)property));
        }
        Insert.Options insertOptions = insert.using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl")));
        if (options.getTimestamp().isPresent()) {
            insertOptions.and(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker((String)"timestamp")));
        }
        return session.prepare(insert.getQueryString());
    }

    public PreparedStatement prepareSelectField(Session session, EntityMeta entityMeta, PropertyMeta pm) {
        log.trace("Generate prepared statement for SELECT property {}", (Object)pm);
        PropertyMeta idMeta = entityMeta.getIdMeta();
        if (pm.isCounter()) {
            throw new IllegalArgumentException("Cannot prepare statement for property '" + pm.getPropertyName() + "' of entity '" + entityMeta.getClassName() + "' because it is a counter type");
        }
        Select.Selection select = this.prepareSelectField(pm, QueryBuilder.select());
        Select from = select.from(entityMeta.getTableName());
        RegularStatement statement = this.prepareWhereClauseForSelect(idMeta, (Optional<PropertyMeta>)Optional.fromNullable((Object)pm), from);
        return session.prepare(statement.getQueryString());
    }

    public PreparedStatement prepareUpdateFields(Session session, EntityMeta entityMeta, List<PropertyMeta> pms, Options options) {
        log.trace("Generate prepared statement for UPDATE properties {}", pms);
        PropertyMeta idMeta = entityMeta.getIdMeta();
        Update update = QueryBuilder.update((String)entityMeta.getTableName());
        Update.Conditions updateConditions = update.onlyIf();
        if (options.hasCasConditions()) {
            for (Options.CASCondition CASCondition2 : options.getCASConditions()) {
                updateConditions.and(CASCondition2.toClauseForPreparedStatement());
            }
        }
        Update.Assignments assignments = null;
        boolean onlyStaticColumns = true;
        for (int i = 0; i < pms.size(); ++i) {
            PropertyMeta pm = pms.get(i);
            if (!pm.isStaticColumn()) {
                onlyStaticColumns = false;
            }
            String property = pm.getPropertyName();
            if (i == 0) {
                assignments = updateConditions.with(QueryBuilder.set((String)property, (Object)QueryBuilder.bindMarker((String)property)));
                continue;
            }
            assignments.and(QueryBuilder.set((String)property, (Object)QueryBuilder.bindMarker((String)property)));
        }
        RegularStatement statement = this.prepareWhereClauseWithTTLForUpdate(idMeta, assignments, onlyStaticColumns, options);
        return session.prepare(statement.getQueryString());
    }

    public PreparedStatement prepareSelectAll(Session session, EntityMeta entityMeta) {
        log.trace("Generate prepared statement for SELECT of {}", (Object)entityMeta);
        PropertyMeta idMeta = entityMeta.getIdMeta();
        Select.Selection select = QueryBuilder.select();
        for (PropertyMeta pm : entityMeta.getColumnsMetaToLoad()) {
            select = this.prepareSelectField(pm, select);
        }
        Select from = select.from(entityMeta.getTableName());
        Optional staticMeta = Optional.absent();
        if (entityMeta.hasOnlyStaticColumns()) {
            staticMeta = Optional.fromNullable((Object)entityMeta.getAllMetasExceptId().get(0));
        }
        RegularStatement statement = this.prepareWhereClauseForSelect(idMeta, (Optional<PropertyMeta>)staticMeta, from);
        return session.prepare(statement.getQueryString());
    }

    public Map<AchillesCounter.CQLQueryType, PreparedStatement> prepareSimpleCounterQueryMap(Session session) {
        String incr = QueryBuilder.update((String)"achilles_counter_table").with(QueryBuilder.incr((String)"counter_value", (BindMarker)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"fqcn", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"primary_key", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"property_name", (Object)QueryBuilder.bindMarker())).getQueryString();
        String decr = QueryBuilder.update((String)"achilles_counter_table").with(QueryBuilder.decr((String)"counter_value", (BindMarker)QueryBuilder.bindMarker())).where(QueryBuilder.eq((String)"fqcn", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"primary_key", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"property_name", (Object)QueryBuilder.bindMarker())).getQueryString();
        String select = QueryBuilder.select((String[])new String[]{"counter_value"}).from("achilles_counter_table").where(QueryBuilder.eq((String)"fqcn", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"primary_key", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"property_name", (Object)QueryBuilder.bindMarker())).getQueryString();
        String delete = QueryBuilder.delete().from("achilles_counter_table").where(QueryBuilder.eq((String)"fqcn", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"primary_key", (Object)QueryBuilder.bindMarker())).and(QueryBuilder.eq((String)"property_name", (Object)QueryBuilder.bindMarker())).getQueryString();
        HashMap<AchillesCounter.CQLQueryType, PreparedStatement> counterPSMap = new HashMap<AchillesCounter.CQLQueryType, PreparedStatement>();
        counterPSMap.put(AchillesCounter.CQLQueryType.INCR, session.prepare(incr));
        counterPSMap.put(AchillesCounter.CQLQueryType.DECR, session.prepare(decr));
        counterPSMap.put(AchillesCounter.CQLQueryType.SELECT, session.prepare(select));
        counterPSMap.put(AchillesCounter.CQLQueryType.DELETE, session.prepare(delete));
        return counterPSMap;
    }

    public Map<AchillesCounter.CQLQueryType, Map<String, PreparedStatement>> prepareClusteredCounterQueryMap(Session session, EntityMeta meta) {
        PropertyMeta idMeta = meta.getIdMeta();
        String tableName = meta.getTableName();
        HashMap<AchillesCounter.CQLQueryType, Map<String, PreparedStatement>> clusteredCounterPSMap = new HashMap<AchillesCounter.CQLQueryType, Map<String, PreparedStatement>>();
        HashMap<String, PreparedStatement> incrStatementPerCounter = new HashMap<String, PreparedStatement>();
        HashMap<String, PreparedStatement> decrStatementPerCounter = new HashMap<String, PreparedStatement>();
        HashMap<String, PreparedStatement> selectStatementPerCounter = new HashMap<String, PreparedStatement>();
        for (PropertyMeta counterMeta : meta.getAllCounterMetas()) {
            String counterName = counterMeta.getPropertyName();
            RegularStatement incrementStatement = this.prepareWhereClauseForCounterUpdate(idMeta, QueryBuilder.update((String)tableName).with(QueryBuilder.incr((String)counterName, (BindMarker)QueryBuilder.bindMarker((String)counterName))), counterMeta.isStaticColumn(), OptionsBuilder.noOptions());
            RegularStatement decrementStatement = this.prepareWhereClauseForCounterUpdate(idMeta, QueryBuilder.update((String)tableName).with(QueryBuilder.decr((String)counterName, (BindMarker)QueryBuilder.bindMarker((String)counterName))), counterMeta.isStaticColumn(), OptionsBuilder.noOptions());
            RegularStatement selectStatement = this.prepareWhereClauseForSelect(idMeta, (Optional<PropertyMeta>)Optional.fromNullable((Object)counterMeta), QueryBuilder.select((String[])new String[]{counterName}).from(tableName));
            incrStatementPerCounter.put(counterName, session.prepare(incrementStatement));
            decrStatementPerCounter.put(counterName, session.prepare(decrementStatement));
            selectStatementPerCounter.put(counterName, session.prepare(selectStatement));
        }
        clusteredCounterPSMap.put(AchillesCounter.CQLQueryType.INCR, incrStatementPerCounter);
        clusteredCounterPSMap.put(AchillesCounter.CQLQueryType.DECR, decrStatementPerCounter);
        RegularStatement selectStatement = this.prepareWhereClauseForSelect(idMeta, (Optional<PropertyMeta>)Optional.absent(), QueryBuilder.select().from(tableName));
        selectStatementPerCounter.put(AchillesCounter.ClusteredCounterStatement.SELECT_ALL.name(), session.prepare(selectStatement));
        clusteredCounterPSMap.put(AchillesCounter.CQLQueryType.SELECT, selectStatementPerCounter);
        RegularStatement deleteStatement = this.prepareWhereClauseForDelete(idMeta, false, QueryBuilder.delete().from(tableName));
        clusteredCounterPSMap.put(AchillesCounter.CQLQueryType.DELETE, (Map<String, PreparedStatement>)ImmutableMap.of((Object)AchillesCounter.ClusteredCounterStatement.DELETE_ALL.name(), (Object)session.prepare(deleteStatement)));
        return clusteredCounterPSMap;
    }

    private Select.Selection prepareSelectField(PropertyMeta pm, Select.Selection select) {
        if (pm.isEmbeddedId()) {
            for (String component : pm.getComponentNames()) {
                select = select.column(component);
            }
        } else {
            select = select.column(pm.getPropertyName());
        }
        return select;
    }

    private void prepareInsertPrimaryKey(PropertyMeta idMeta, Insert insert) {
        if (idMeta.isEmbeddedId()) {
            for (String component : idMeta.getComponentNames()) {
                insert.value(component, (Object)QueryBuilder.bindMarker((String)component));
            }
        } else {
            String idName = idMeta.getPropertyName();
            insert.value(idName, (Object)QueryBuilder.bindMarker((String)idName));
        }
    }

    private RegularStatement prepareWhereClauseForSelect(PropertyMeta idMeta, Optional<PropertyMeta> pmO, Select from) {
        Select.Where statement;
        if (idMeta.isEmbeddedId()) {
            Select.Where where = null;
            int i = 0;
            List<String> componentNames = pmO.isPresent() && ((PropertyMeta)pmO.get()).isStaticColumn() ? idMeta.getPartitionComponentNames() : idMeta.getComponentNames();
            for (String partitionKey : componentNames) {
                if (i++ == 0) {
                    where = from.where(QueryBuilder.eq((String)partitionKey, (Object)QueryBuilder.bindMarker((String)partitionKey)));
                    continue;
                }
                where.and(QueryBuilder.eq((String)partitionKey, (Object)QueryBuilder.bindMarker((String)partitionKey)));
            }
            statement = where;
        } else {
            String idName = idMeta.getPropertyName();
            statement = from.where(QueryBuilder.eq((String)idName, (Object)QueryBuilder.bindMarker((String)idName)));
        }
        return statement;
    }

    private RegularStatement prepareWhereClauseWithTTLForUpdate(PropertyMeta idMeta, Update.Assignments assignments, boolean onlyStaticColumns, Options options) {
        Update.Where where = null;
        if (idMeta.isEmbeddedId()) {
            where = this.prepareCommonWhereClauseForUpdate(idMeta, assignments, onlyStaticColumns, where);
        } else {
            String idName = idMeta.getPropertyName();
            where = assignments.where(QueryBuilder.eq((String)idName, (Object)QueryBuilder.bindMarker((String)idName)));
        }
        Update.Options updateOptions = where.using(QueryBuilder.ttl((BindMarker)QueryBuilder.bindMarker((String)"ttl")));
        if (options.getTimestamp().isPresent()) {
            updateOptions.and(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker((String)"timestamp")));
        }
        return updateOptions;
    }

    private RegularStatement prepareWhereClauseForCounterUpdate(PropertyMeta idMeta, Update.Assignments assignments, boolean onlyStaticColumns, Options options) {
        Update.Where where = null;
        if (idMeta.isEmbeddedId()) {
            where = this.prepareCommonWhereClauseForUpdate(idMeta, assignments, onlyStaticColumns, where);
        } else {
            String idName = idMeta.getPropertyName();
            where = assignments.where(QueryBuilder.eq((String)idName, (Object)QueryBuilder.bindMarker((String)idName)));
        }
        if (options.getTimestamp().isPresent()) {
            return where.using(QueryBuilder.timestamp((BindMarker)QueryBuilder.bindMarker((String)"timestamp")));
        }
        return where;
    }

    private Update.Where prepareCommonWhereClauseForUpdate(PropertyMeta idMeta, Update.Assignments assignments, boolean onlyStaticColumns, Update.Where where) {
        int i = 0;
        if (onlyStaticColumns) {
            for (String partitionKeys : idMeta.getPartitionComponentNames()) {
                if (i++ == 0) {
                    where = assignments.where(QueryBuilder.eq((String)partitionKeys, (Object)QueryBuilder.bindMarker((String)partitionKeys)));
                    continue;
                }
                where.and(QueryBuilder.eq((String)partitionKeys, (Object)QueryBuilder.bindMarker((String)partitionKeys)));
            }
        } else {
            for (String clusteredId : idMeta.getComponentNames()) {
                if (i++ == 0) {
                    where = assignments.where(QueryBuilder.eq((String)clusteredId, (Object)QueryBuilder.bindMarker((String)clusteredId)));
                    continue;
                }
                where.and(QueryBuilder.eq((String)clusteredId, (Object)QueryBuilder.bindMarker((String)clusteredId)));
            }
        }
        return where;
    }

    public Map<String, PreparedStatement> prepareRemovePSs(Session session, EntityMeta entityMeta) {
        log.trace("Generate prepared statement for DELETE of {}", (Object)entityMeta);
        PropertyMeta idMeta = entityMeta.getIdMeta();
        HashMap<String, PreparedStatement> removePSs = new HashMap<String, PreparedStatement>();
        Delete mainFrom = QueryBuilder.delete().from(entityMeta.getTableName());
        RegularStatement mainStatement = this.prepareWhereClauseForDelete(idMeta, entityMeta.hasOnlyStaticColumns(), mainFrom);
        removePSs.put(entityMeta.getTableName(), session.prepare(mainStatement.getQueryString()));
        return removePSs;
    }

    private RegularStatement prepareWhereClauseForDelete(PropertyMeta idMeta, boolean onlyStaticColumns, Delete mainFrom) {
        Delete.Where mainStatement;
        if (idMeta.isEmbeddedId()) {
            Delete.Where where = null;
            List<String> componentNames = onlyStaticColumns ? idMeta.getPartitionComponentNames() : idMeta.getComponentNames();
            int i = 0;
            for (String clusteredId : componentNames) {
                if (i++ == 0) {
                    where = mainFrom.where(QueryBuilder.eq((String)clusteredId, (Object)QueryBuilder.bindMarker((String)clusteredId)));
                    continue;
                }
                where.and(QueryBuilder.eq((String)clusteredId, (Object)QueryBuilder.bindMarker((String)clusteredId)));
            }
            mainStatement = where;
        } else {
            String idName = idMeta.getPropertyName();
            mainStatement = mainFrom.where(QueryBuilder.eq((String)idName, (Object)QueryBuilder.bindMarker((String)idName)));
        }
        return mainStatement;
    }

    public PreparedStatement prepareCollectionAndMapUpdate(Session session, EntityMeta meta, DirtyCheckChangeSet changeSet, Options options) {
        Update.Conditions conditions = QueryBuilder.update((String)meta.getTableName()).onlyIf();
        if (options.hasCasConditions()) {
            for (Options.CASCondition CASCondition2 : options.getCASConditions()) {
                conditions.and(CASCondition2.toClauseForPreparedStatement());
            }
        }
        CollectionAndMapChangeType changeType = changeSet.getChangeType();
        Pair<Update.Assignments, Object[]> updateClauseAndBoundValues = null;
        switch (changeType) {
            case ASSIGN_VALUE_TO_LIST: 
            case ASSIGN_VALUE_TO_SET: 
            case ASSIGN_VALUE_TO_MAP: 
            case REMOVE_COLLECTION_OR_MAP: {
                updateClauseAndBoundValues = changeSet.generateUpdateForRemoveAll(conditions, true);
                break;
            }
            case ADD_TO_SET: {
                updateClauseAndBoundValues = changeSet.generateUpdateForAddedElements(conditions, true);
                break;
            }
            case REMOVE_FROM_SET: {
                updateClauseAndBoundValues = changeSet.generateUpdateForRemovedElements(conditions, true);
                break;
            }
            case APPEND_TO_LIST: {
                updateClauseAndBoundValues = changeSet.generateUpdateForAppendedElements(conditions, true);
                break;
            }
            case PREPEND_TO_LIST: {
                updateClauseAndBoundValues = changeSet.generateUpdateForPrependedElements(conditions, true);
                break;
            }
            case REMOVE_FROM_LIST: {
                updateClauseAndBoundValues = changeSet.generateUpdateForRemoveListElements(conditions, true);
                break;
            }
            case SET_TO_LIST_AT_INDEX: {
                throw new IllegalStateException("Cannot prepare statement to set element at index for list");
            }
            case REMOVE_FROM_LIST_AT_INDEX: {
                throw new IllegalStateException("Cannot prepare statement to remove element at index for list");
            }
            case ADD_TO_MAP: {
                updateClauseAndBoundValues = changeSet.generateUpdateForAddedEntries(conditions, true);
                break;
            }
            case REMOVE_FROM_MAP: {
                updateClauseAndBoundValues = changeSet.generateUpdateForRemovedKey(conditions, true);
            }
        }
        RegularStatement regularStatement = this.prepareWhereClauseWithTTLForUpdate(meta.getIdMeta(), (Update.Assignments)updateClauseAndBoundValues.left, changeSet.getPropertyMeta().isStaticColumn(), options);
        PreparedStatement preparedStatement = session.prepare(regularStatement);
        return preparedStatement;
    }
}

