/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.prepared;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.PreparedStatement;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import info.archinnov.achilles.internal.consistency.ConsistencyConverter;
import info.archinnov.achilles.internal.consistency.ConsistencyOverrider;
import info.archinnov.achilles.internal.context.facade.PersistentStateHolder;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.CollectionAndMapChangeType;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyCheckChangeSet;
import info.archinnov.achilles.internal.statement.wrapper.BoundStatementWrapper;
import info.archinnov.achilles.listener.CASResultListener;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Options;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementBinder {
    private static final Logger log = LoggerFactory.getLogger(PreparedStatementBinder.class);
    protected static final Optional<CASResultListener> NO_LISTENER = Optional.absent();
    protected static final Optional<com.datastax.driver.core.ConsistencyLevel> NO_SERIAL_CONSISTENCY = Optional.absent();
    private ConsistencyOverrider overrider = new ConsistencyOverrider();

    public BoundStatementWrapper bindForInsert(PersistentStateHolder context, PreparedStatement ps, List<PropertyMeta> pms) {
        EntityMeta entityMeta = context.getEntityMeta();
        Object entity = context.getEntity();
        log.trace("Bind prepared statement {} for insert of entity {}", (Object)ps.getQueryString(), entity);
        ConsistencyLevel consistencyLevel = this.overrider.getWriteLevel(context);
        ArrayList<Object> values = new ArrayList<Object>();
        values.addAll(this.fetchPrimaryKeyValues(entityMeta, entity, false));
        values.addAll(this.fetchPropertiesValues(pms, entity));
        values.addAll(this.fetchTTLAndTimestampValues(context));
        BoundStatement bs = ps.bind(values.toArray());
        return new BoundStatementWrapper(context.getEntityClass(), bs, values.toArray(), ConsistencyConverter.getCQLLevel(consistencyLevel), (Optional<CASResultListener>)context.getCASResultListener(), context.getSerialConsistencyLevel());
    }

    public BoundStatementWrapper bindForUpdate(PersistentStateHolder context, PreparedStatement ps, List<PropertyMeta> pms) {
        EntityMeta entityMeta = context.getEntityMeta();
        Object entity = context.getEntity();
        log.trace("Bind prepared statement {} for properties {} update of entity {}", new Object[]{ps.getQueryString(), pms, entity});
        ConsistencyLevel consistencyLevel = this.overrider.getWriteLevel(context);
        ArrayList<Object> values = new ArrayList<Object>();
        int staticColumnsCount = FluentIterable.from(pms).filter(PropertyMeta.STATIC_COLUMN_FILTER).size();
        boolean onlyStaticColumns = staticColumnsCount > 0 && pms.size() == staticColumnsCount;
        values.addAll(this.fetchTTLAndTimestampValues(context));
        values.addAll(this.fetchPropertiesValues(pms, entity));
        values.addAll(this.fetchPrimaryKeyValues(entityMeta, entity, onlyStaticColumns));
        values.addAll(this.fetchCASConditionsValues(context, entityMeta));
        BoundStatement bs = ps.bind(values.toArray());
        return new BoundStatementWrapper(context.getEntityClass(), bs, values.toArray(), ConsistencyConverter.getCQLLevel(consistencyLevel), (Optional<CASResultListener>)context.getCASResultListener(), context.getSerialConsistencyLevel());
    }

    public BoundStatementWrapper bindForCollectionAndMapUpdate(PersistentStateHolder context, PreparedStatement ps, DirtyCheckChangeSet changeSet) {
        EntityMeta entityMeta = context.getEntityMeta();
        Object entity = context.getEntity();
        log.trace("Bind prepared statement {} for collection/map update of entity {}", (Object)ps.getQueryString(), entity);
        ConsistencyLevel consistencyLevel = this.overrider.getWriteLevel(context);
        ArrayList<Object> values = new ArrayList<Object>();
        CollectionAndMapChangeType changeType = changeSet.getChangeType();
        values.addAll(this.fetchTTLAndTimestampValues(context));
        switch (changeType) {
            case ASSIGN_VALUE_TO_LIST: {
                values.add(changeSet.getEncodedListChanges());
                break;
            }
            case ASSIGN_VALUE_TO_SET: {
                values.add(changeSet.getEncodedSetChanges());
                break;
            }
            case ASSIGN_VALUE_TO_MAP: {
                values.add(changeSet.getEncodedMapChanges());
                break;
            }
            case REMOVE_COLLECTION_OR_MAP: {
                values.add(null);
                break;
            }
            case ADD_TO_SET: 
            case REMOVE_FROM_SET: {
                values.add(changeSet.getEncodedSetChanges());
                break;
            }
            case APPEND_TO_LIST: 
            case PREPEND_TO_LIST: 
            case REMOVE_FROM_LIST: {
                values.add(changeSet.getEncodedListChanges());
                break;
            }
            case SET_TO_LIST_AT_INDEX: {
                throw new IllegalStateException("Cannot bind statement to set element at index for list");
            }
            case REMOVE_FROM_LIST_AT_INDEX: {
                throw new IllegalStateException("Cannot bind statement to remove element at index for list");
            }
            case ADD_TO_MAP: {
                values.add(changeSet.getEncodedMapChanges());
                break;
            }
            case REMOVE_FROM_MAP: {
                values.add(changeSet.getEncodedMapChanges().keySet().iterator().next());
                values.add(null);
            }
        }
        values.addAll(this.fetchPrimaryKeyValues(entityMeta, entity, changeSet.getPropertyMeta().isStaticColumn()));
        values.addAll(this.fetchCASConditionsValues(context, entityMeta));
        BoundStatement bs = ps.bind(values.toArray());
        return new BoundStatementWrapper(context.getEntityClass(), bs, values.toArray(), ConsistencyConverter.getCQLLevel(consistencyLevel), (Optional<CASResultListener>)context.getCASResultListener(), context.getSerialConsistencyLevel());
    }

    public BoundStatementWrapper bindStatementWithOnlyPKInWhereClause(PersistentStateHolder context, PreparedStatement ps, boolean onlyStaticColumns, ConsistencyLevel consistencyLevel) {
        Object primaryKey = context.getPrimaryKey();
        log.trace("Bind prepared statement {} with primary key {}", (Object)ps.getQueryString(), primaryKey);
        PropertyMeta idMeta = context.getIdMeta();
        List<Object> values = this.bindPrimaryKey(primaryKey, idMeta, onlyStaticColumns);
        BoundStatement bs = ps.bind(values.toArray());
        return new BoundStatementWrapper(context.getEntityClass(), bs, values.toArray(), ConsistencyConverter.getCQLLevel(consistencyLevel), (Optional<CASResultListener>)context.getCASResultListener(), context.getSerialConsistencyLevel());
    }

    public BoundStatementWrapper bindForSimpleCounterIncrementDecrement(PersistentStateHolder context, PreparedStatement ps, PropertyMeta pm, Long increment, ConsistencyLevel consistencyLevel) {
        EntityMeta entityMeta = context.getEntityMeta();
        Object primaryKey = context.getPrimaryKey();
        log.trace("Bind prepared statement {} for simple counter increment of {} using primary key {} and value {}", new Object[]{ps.getQueryString(), pm, primaryKey, increment});
        Object[] boundValues = ArrayUtils.add((Object[])this.extractValuesForSimpleCounterBinding(entityMeta, pm, primaryKey), (int)0, (Object)increment);
        BoundStatement bs = ps.bind(boundValues);
        return new BoundStatementWrapper(context.getEntityClass(), bs, boundValues, ConsistencyConverter.getCQLLevel(consistencyLevel), NO_LISTENER, NO_SERIAL_CONSISTENCY);
    }

    public BoundStatementWrapper bindForSimpleCounterSelect(PersistentStateHolder context, PreparedStatement ps, PropertyMeta pm, ConsistencyLevel consistencyLevel) {
        EntityMeta entityMeta = context.getEntityMeta();
        Object primaryKey = context.getPrimaryKey();
        log.trace("Bind prepared statement {} for simple counter read of {} using primary key {}", new Object[]{ps.getQueryString(), pm, primaryKey});
        Object[] boundValues = this.extractValuesForSimpleCounterBinding(entityMeta, pm, primaryKey);
        BoundStatement bs = ps.bind(boundValues);
        return new BoundStatementWrapper(context.getEntityClass(), bs, boundValues, ConsistencyConverter.getCQLLevel(consistencyLevel), NO_LISTENER, NO_SERIAL_CONSISTENCY);
    }

    public BoundStatementWrapper bindForSimpleCounterDelete(PersistentStateHolder context, PreparedStatement ps, PropertyMeta pm) {
        EntityMeta entityMeta = context.getEntityMeta();
        Object primaryKey = context.getPrimaryKey();
        log.trace("Bind prepared statement {} for simple counter delete for {} using primary key {}", new Object[]{ps.getQueryString(), pm, primaryKey});
        ConsistencyLevel consistencyLevel = this.overrider.getWriteLevel(context);
        Object[] boundValues = this.extractValuesForSimpleCounterBinding(entityMeta, pm, primaryKey);
        BoundStatement bs = ps.bind(boundValues);
        return new BoundStatementWrapper(context.getEntityClass(), bs, boundValues, ConsistencyConverter.getCQLLevel(consistencyLevel), NO_LISTENER, NO_SERIAL_CONSISTENCY);
    }

    public BoundStatementWrapper bindForClusteredCounterIncrementDecrement(PersistentStateHolder context, PreparedStatement ps, PropertyMeta counterMeta, Long increment) {
        EntityMeta entityMeta = context.getEntityMeta();
        Object primaryKey = context.getPrimaryKey();
        log.trace("Bind prepared statement {} for clustered counter increment/decrement for {} using primary key {} and value {}", new Object[]{ps.getQueryString(), entityMeta, primaryKey, increment});
        ConsistencyLevel consistencyLevel = this.overrider.getWriteLevel(context);
        List<Object> primaryKeys = this.bindPrimaryKey(primaryKey, entityMeta.getIdMeta(), counterMeta.isStaticColumn());
        Object[] keys = new Object[]{increment};
        keys = ArrayUtils.addAll((Object[])keys, (Object[])primaryKeys.toArray());
        BoundStatement bs = ps.bind(keys);
        return new BoundStatementWrapper(context.getEntityClass(), bs, keys, ConsistencyConverter.getCQLLevel(consistencyLevel), NO_LISTENER, NO_SERIAL_CONSISTENCY);
    }

    public BoundStatementWrapper bindForClusteredCounterSelect(PersistentStateHolder context, PreparedStatement ps, boolean onlyStaticColumns, ConsistencyLevel consistencyLevel) {
        EntityMeta entityMeta = context.getEntityMeta();
        Object primaryKey = context.getPrimaryKey();
        log.trace("Bind prepared statement {} for clustered counter read for {} using primary key {}", new Object[]{ps.getQueryString(), entityMeta, primaryKey});
        List<Object> primaryKeys = this.bindPrimaryKey(primaryKey, entityMeta.getIdMeta(), onlyStaticColumns);
        Object[] boundValues = primaryKeys.toArray(new Object[primaryKeys.size()]);
        BoundStatement bs = ps.bind(boundValues);
        return new BoundStatementWrapper(context.getEntityClass(), bs, boundValues, ConsistencyConverter.getCQLLevel(consistencyLevel), NO_LISTENER, NO_SERIAL_CONSISTENCY);
    }

    public BoundStatementWrapper bindForClusteredCounterDelete(PersistentStateHolder context, PreparedStatement ps) {
        EntityMeta entityMeta = context.getEntityMeta();
        Object primaryKey = context.getPrimaryKey();
        log.trace("Bind prepared statement {} for simple counter delete for {} using primary key {}", new Object[]{ps.getQueryString(), entityMeta, primaryKey});
        ConsistencyLevel consistencyLevel = this.overrider.getWriteLevel(context);
        List<Object> primaryKeys = this.bindPrimaryKey(primaryKey, entityMeta.getIdMeta(), false);
        Object[] boundValues = primaryKeys.toArray(new Object[primaryKeys.size()]);
        BoundStatement bs = ps.bind(boundValues);
        return new BoundStatementWrapper(context.getEntityClass(), bs, boundValues, ConsistencyConverter.getCQLLevel(consistencyLevel), NO_LISTENER, NO_SERIAL_CONSISTENCY);
    }

    private List<Object> fetchPrimaryKeyValues(EntityMeta entityMeta, Object entity, boolean onlyStaticColumns) {
        ArrayList<Object> values = new ArrayList<Object>();
        Object primaryKey = entityMeta.getPrimaryKey(entity);
        values.addAll(this.bindPrimaryKey(primaryKey, entityMeta.getIdMeta(), onlyStaticColumns));
        return values;
    }

    private List<Object> fetchTTLAndTimestampValues(PersistentStateHolder context) {
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(context.getTtl().or((Object)0));
        if (context.getTimestamp().isPresent()) {
            values.add(context.getTimestamp().get());
        }
        return values;
    }

    private List<Object> fetchPropertiesValues(List<PropertyMeta> pms, Object entity) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (PropertyMeta pm : pms) {
            Object value = pm.getAndEncodeValueForCassandra(entity);
            values.add(value);
        }
        return values;
    }

    private List<Object> fetchCASConditionsValues(PersistentStateHolder context, EntityMeta entityMeta) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (context.hasCasConditions()) {
            for (Options.CASCondition CASCondition2 : context.getCasConditions()) {
                values.add(entityMeta.encodeCasConditionValue(CASCondition2));
            }
        }
        return values;
    }

    private List<Object> bindPrimaryKey(Object primaryKey, PropertyMeta idMeta, boolean onlyStaticColumns) {
        ArrayList<Object> values = new ArrayList<Object>();
        if (idMeta.isEmbeddedId()) {
            values.addAll(idMeta.encodeToComponents(primaryKey, onlyStaticColumns));
        } else {
            values.add(idMeta.encode(primaryKey));
        }
        return values;
    }

    private Object[] extractValuesForSimpleCounterBinding(EntityMeta entityMeta, PropertyMeta pm, Object primaryKey) {
        PropertyMeta idMeta = entityMeta.getIdMeta();
        String fqcn = entityMeta.getClassName();
        String primaryKeyAsString = idMeta.forceEncodeToJSON(primaryKey);
        String propertyName = pm.getPropertyName();
        return new Object[]{fqcn, primaryKeyAsString, propertyName};
    }
}

