/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement.cache;

import com.google.common.base.Optional;
import info.archinnov.achilles.internal.statement.cache.CacheType;
import info.archinnov.achilles.type.Options;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class StatementCacheKey {
    private CacheType type;
    private Set<String> fields;
    private Class<?> entityClass;
    private OptionsCacheKey optionsCacheKey;

    public StatementCacheKey(CacheType type, Set<String> fields, Class<?> entityClass, Options options) {
        this.type = type;
        this.entityClass = entityClass;
        this.fields = fields;
        this.optionsCacheKey = OptionsCacheKey.fromOptions(options);
    }

    public CacheType getType() {
        return this.type;
    }

    public Set<String> getFields() {
        return this.fields;
    }

    public <T> Class<T> getEntityClass() {
        return this.entityClass;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.entityClass, this.fields, this.type, this.optionsCacheKey});
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this.getClass() != o.getClass()) {
            return false;
        }
        StatementCacheKey other = (StatementCacheKey)o;
        return Objects.equals(this.entityClass, other.entityClass) && Objects.equals(this.fields, other.fields) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.optionsCacheKey, other.optionsCacheKey);
    }

    private static class OptionsCacheKey {
        private boolean hasConsistencyLevel;
        private boolean hasTimestamp;
        private boolean ifNotExists;
        private List<Options.CASCondition> CASConditions;

        private OptionsCacheKey(boolean hasConsistencyLevel, boolean hasTimestamp, boolean ifNotExists, List<Options.CASCondition> CASConditions) {
            this.hasConsistencyLevel = hasConsistencyLevel;
            this.hasTimestamp = hasTimestamp;
            this.ifNotExists = ifNotExists;
            this.CASConditions = CASConditions;
        }

        private static OptionsCacheKey fromOptions(Options options) {
            boolean hasConsistencyLevel = options.getConsistencyLevel().isPresent();
            boolean hasTimestamp = options.getTimestamp().isPresent();
            boolean ifNotExists = options.isIfNotExists();
            List CASConditions = (List)Optional.fromNullable(options.getCASConditions()).or(Collections.emptyList());
            return new OptionsCacheKey(hasConsistencyLevel, hasTimestamp, ifNotExists, CASConditions);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this.getClass() != o.getClass()) {
                return false;
            }
            OptionsCacheKey other = (OptionsCacheKey)o;
            return Objects.equals(this.hasConsistencyLevel, other.hasConsistencyLevel) && Objects.equals(this.hasTimestamp, other.hasTimestamp) && Objects.equals(this.ifNotExists, other.ifNotExists) && Objects.equals(this.CASConditions, other.CASConditions);
        }

        public int hashCode() {
            return Objects.hash(this.hasConsistencyLevel, this.hasTimestamp, this.ifNotExists, this.CASConditions);
        }
    }
}

