/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement;

import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Ordering;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.querybuilder.Update;
import com.google.common.base.Optional;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.context.facade.PersistentStateHolder;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.CollectionAndMapChangeType;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyCheckChangeSet;
import info.archinnov.achilles.internal.statement.SliceQueryStatementGenerator;
import info.archinnov.achilles.internal.statement.wrapper.RegularStatementWrapper;
import info.archinnov.achilles.query.slice.CQLSliceQuery;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.Pair;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatementGenerator {
    private static final Logger log = LoggerFactory.getLogger(StatementGenerator.class);
    private SliceQueryStatementGenerator sliceQueryGenerator = new SliceQueryStatementGenerator();

    public RegularStatementWrapper generateSelectSliceQuery(CQLSliceQuery<?> sliceQuery) {
        log.trace("Generate SELECT statement for slice query");
        EntityMeta meta = sliceQuery.getMeta();
        Select select = this.generateSelectEntityInternal(meta);
        select = select.limit(sliceQuery.getLimit());
        if (sliceQuery.getCQLOrdering() != null) {
            select.orderBy(new Ordering[]{sliceQuery.getCQLOrdering()});
        }
        select.setFetchSize(sliceQuery.getBatchSize());
        return this.sliceQueryGenerator.generateWhereClauseForSelectSliceQuery(sliceQuery, select);
    }

    public RegularStatementWrapper generateRemoveSliceQuery(CQLSliceQuery<?> sliceQuery) {
        log.trace("Generate DELETE statement for slice query");
        EntityMeta meta = sliceQuery.getMeta();
        Delete delete = QueryBuilder.delete().from(meta.getTableName());
        return this.sliceQueryGenerator.generateWhereClauseForDeleteSliceQuery(sliceQuery, delete);
    }

    protected Select generateSelectEntityInternal(EntityMeta entityMeta) {
        log.trace("Generate SELECT statement for entity class {}", (Object)entityMeta.getClassName());
        PropertyMeta idMeta = entityMeta.getIdMeta();
        Select.Selection select = QueryBuilder.select();
        this.generateSelectForPrimaryKey(idMeta, select);
        for (PropertyMeta pm : entityMeta.getColumnsMetaToInsert()) {
            select.column(pm.getPropertyName());
        }
        return select.from(entityMeta.getTableName());
    }

    public Pair<Update.Where, Object[]> generateCollectionAndMapUpdateOperation(PersistentStateHolder context, DirtyCheckChangeSet changeSet) {
        Pair<Update.Assignments, Object[]> updateClauseAndBoundValues;
        Object entity = context.getEntity();
        EntityMeta meta = context.getEntityMeta();
        Optional<Integer> ttlO = context.getTtl();
        Optional<Long> timestampO = context.getTimestamp();
        List<Options.CASCondition> CASConditions = context.getCasConditions();
        Update.Conditions conditions = QueryBuilder.update((String)meta.getTableName()).onlyIf();
        List<Object> casEncodedValues = this.addAndEncodeCasConditions(meta, CASConditions, conditions);
        Object[] boundValues = new Object[]{};
        if (ttlO.isPresent()) {
            conditions.using(QueryBuilder.ttl((int)((Integer)ttlO.get())));
            boundValues = ArrayUtils.addAll((Object[])boundValues, (Object[])new Object[]{ttlO.get()});
        }
        if (timestampO.isPresent()) {
            conditions.using(QueryBuilder.timestamp((long)((Long)timestampO.get())));
            boundValues = ArrayUtils.addAll((Object[])boundValues, (Object[])new Object[]{timestampO.get()});
        }
        CollectionAndMapChangeType operationType = changeSet.getChangeType();
        switch (operationType) {
            case SET_TO_LIST_AT_INDEX: {
                updateClauseAndBoundValues = changeSet.generateUpdateForSetAtIndexElement(conditions);
                break;
            }
            case REMOVE_FROM_LIST_AT_INDEX: {
                updateClauseAndBoundValues = changeSet.generateUpdateForRemovedAtIndexElement(conditions);
                break;
            }
            default: {
                throw new AchillesException(String.format("Should not generate non-prepapred statement for collection/map change of type '%s'", new Object[]{operationType}));
            }
        }
        Pair<Update.Where, Object[]> whereClauseAndBoundValues = this.generateWhereClauseForUpdate(entity, meta.getIdMeta(), changeSet.getPropertyMeta(), (Update.Assignments)updateClauseAndBoundValues.left);
        boundValues = ArrayUtils.addAll((Object[])ArrayUtils.addAll((Object[])boundValues, (Object[])ArrayUtils.addAll((Object[])((Object[])updateClauseAndBoundValues.right), (Object[])((Object[])whereClauseAndBoundValues.right))), (Object[])casEncodedValues.toArray());
        return Pair.create(whereClauseAndBoundValues.left, boundValues);
    }

    private List<Object> addAndEncodeCasConditions(EntityMeta entityMeta, List<Options.CASCondition> CASConditions, Update.Conditions conditions) {
        ArrayList<Object> casEncodedValues = new ArrayList<Object>();
        for (Options.CASCondition CASCondition2 : CASConditions) {
            Object encodedValue = entityMeta.encodeCasConditionValue(CASCondition2);
            casEncodedValues.add(encodedValue);
            conditions.and(CASCondition2.toClause());
        }
        return casEncodedValues;
    }

    private Pair<Update.Where, Object[]> generateWhereClauseForUpdate(Object entity, PropertyMeta idMeta, PropertyMeta pm, Update.Assignments update) {
        Object[] boundValues;
        Update.Where where = null;
        Object primaryKey = idMeta.getPrimaryKey(entity);
        if (idMeta.isEmbeddedId()) {
            List<String> componentNames = idMeta.getComponentNames();
            List<Object> encodedComponents = idMeta.encodeToComponents(primaryKey, pm.isStaticColumn());
            boundValues = new Object[encodedComponents.size()];
            for (int i = 0; i < encodedComponents.size(); ++i) {
                String componentName = componentNames.get(i);
                Object componentValue = encodedComponents.get(i);
                if (i == 0) {
                    where = update.where(QueryBuilder.eq((String)componentName, (Object)componentValue));
                } else {
                    where.and(QueryBuilder.eq((String)componentName, (Object)componentValue));
                }
                boundValues[i] = componentValue;
            }
        } else {
            Object id = idMeta.encode(primaryKey);
            where = update.where(QueryBuilder.eq((String)idMeta.getPropertyName(), (Object)id));
            boundValues = new Object[]{id};
        }
        return Pair.create(where, boundValues);
    }

    private void generateSelectForPrimaryKey(PropertyMeta idMeta, Select.Selection select) {
        if (idMeta.isEmbeddedId()) {
            for (String component : idMeta.getComponentNames()) {
                select.column(component);
            }
        } else {
            select.column(idMeta.getPropertyName());
        }
    }
}

