/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.statement;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.google.common.base.Optional;
import info.archinnov.achilles.internal.statement.wrapper.RegularStatementWrapper;
import info.archinnov.achilles.listener.CASResultListener;
import info.archinnov.achilles.query.slice.CQLSliceQuery;
import info.archinnov.achilles.type.OrderingMode;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceQueryStatementGenerator {
    private static final Logger log = LoggerFactory.getLogger(SliceQueryStatementGenerator.class);
    private static final Optional<CASResultListener> NO_CAS_LISTENER = Optional.absent();
    private static final Optional<ConsistencyLevel> NO_SERIAL_CONSISTENCY = Optional.absent();

    public RegularStatementWrapper generateWhereClauseForSelectSliceQuery(CQLSliceQuery<?> sliceQuery, Select select) {
        Select.Where where = select.where();
        List<Object> fixedComponents = sliceQuery.getFixedComponents();
        List<String> componentNames = sliceQuery.getComponentNames();
        String varyingComponentName = sliceQuery.getVaryingComponentName();
        OrderingMode ordering = sliceQuery.getOrdering();
        Object lastStartComp = sliceQuery.getLastStartComponent();
        Object lastEndComp = sliceQuery.getLastEndComponent();
        Object[] boundValues = new Object[fixedComponents.size()];
        for (int i = 0; i < fixedComponents.size(); ++i) {
            where.and(QueryBuilder.eq((String)componentNames.get(i), (Object)fixedComponents.get(i)));
            boundValues[i] = fixedComponents.get(i);
        }
        if (lastStartComp != null) {
            boundValues = ArrayUtils.add((Object[])boundValues, (Object)lastStartComp);
        }
        if (lastEndComp != null) {
            boundValues = ArrayUtils.add((Object[])boundValues, (Object)lastEndComp);
        }
        if (ordering == OrderingMode.ASCENDING) {
            switch (sliceQuery.getBounding()) {
                case INCLUSIVE_BOUNDS: {
                    if (lastStartComp != null) {
                        where.and(QueryBuilder.gte((String)varyingComponentName, (Object)lastStartComp));
                    }
                    if (lastEndComp == null) break;
                    where.and(QueryBuilder.lte((String)varyingComponentName, (Object)lastEndComp));
                    break;
                }
                case EXCLUSIVE_BOUNDS: {
                    if (lastStartComp != null) {
                        where.and(QueryBuilder.gt((String)varyingComponentName, (Object)lastStartComp));
                    }
                    if (lastEndComp == null) break;
                    where.and(QueryBuilder.lt((String)varyingComponentName, (Object)lastEndComp));
                    break;
                }
                case INCLUSIVE_START_BOUND_ONLY: {
                    if (lastStartComp != null) {
                        where.and(QueryBuilder.gte((String)varyingComponentName, (Object)lastStartComp));
                    }
                    if (lastEndComp == null) break;
                    where.and(QueryBuilder.lt((String)varyingComponentName, (Object)lastEndComp));
                    break;
                }
                case INCLUSIVE_END_BOUND_ONLY: {
                    if (lastStartComp != null) {
                        where.and(QueryBuilder.gt((String)varyingComponentName, (Object)lastStartComp));
                    }
                    if (lastEndComp == null) break;
                    where.and(QueryBuilder.lte((String)varyingComponentName, (Object)lastEndComp));
                }
            }
        } else {
            switch (sliceQuery.getBounding()) {
                case INCLUSIVE_BOUNDS: {
                    if (lastStartComp != null) {
                        where.and(QueryBuilder.lte((String)varyingComponentName, (Object)lastStartComp));
                    }
                    if (lastEndComp == null) break;
                    where.and(QueryBuilder.gte((String)varyingComponentName, (Object)lastEndComp));
                    break;
                }
                case EXCLUSIVE_BOUNDS: {
                    if (lastStartComp != null) {
                        where.and(QueryBuilder.lt((String)varyingComponentName, (Object)lastStartComp));
                    }
                    if (lastEndComp == null) break;
                    where.and(QueryBuilder.gt((String)varyingComponentName, (Object)lastEndComp));
                    break;
                }
                case INCLUSIVE_START_BOUND_ONLY: {
                    if (lastStartComp != null) {
                        where.and(QueryBuilder.lte((String)varyingComponentName, (Object)lastStartComp));
                    }
                    if (lastEndComp == null) break;
                    where.and(QueryBuilder.gt((String)varyingComponentName, (Object)lastEndComp));
                    break;
                }
                case INCLUSIVE_END_BOUND_ONLY: {
                    if (lastStartComp != null) {
                        where.and(QueryBuilder.lt((String)varyingComponentName, (Object)lastStartComp));
                    }
                    if (lastEndComp == null) break;
                    where.and(QueryBuilder.gte((String)varyingComponentName, (Object)lastEndComp));
                }
            }
        }
        where.setFetchSize(sliceQuery.getBatchSize());
        log.trace("Generated WHERE clause for slice query : {}", (Object)where.getQueryString());
        return new RegularStatementWrapper(sliceQuery.getEntityClass(), (RegularStatement)where, boundValues, sliceQuery.getConsistencyLevel(), NO_CAS_LISTENER, NO_SERIAL_CONSISTENCY);
    }

    public RegularStatementWrapper generateWhereClauseForDeleteSliceQuery(CQLSliceQuery<?> sliceQuery, Delete delete) {
        List<Object> fixedComponents = sliceQuery.getFixedComponents();
        List<String> componentNames = sliceQuery.getComponentNames();
        Delete.Where where = delete.where();
        Object[] boundValues = new Object[fixedComponents.size()];
        for (int i = 0; i < fixedComponents.size(); ++i) {
            where.and(QueryBuilder.eq((String)componentNames.get(i), (Object)fixedComponents.get(i)));
            boundValues[i] = fixedComponents.get(i);
        }
        log.trace("Generated WHERE clause for slice delete query : {}", (Object)where.getQueryString());
        return new RegularStatementWrapper(sliceQuery.getEntityClass(), (RegularStatement)where, boundValues, sliceQuery.getConsistencyLevel(), NO_CAS_LISTENER, NO_SERIAL_CONSISTENCY);
    }
}

