/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.reflection;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.Row;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.cql.TypeMapper;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.validation.Validator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RowMethodInvoker {
    private static final Logger log = LoggerFactory.getLogger(RowMethodInvoker.class);

    public Object invokeOnRowForFields(Row row, PropertyMeta pm) {
        String propertyName = pm.getPropertyName().toLowerCase();
        Map<?, ?> value = null;
        if (!row.isNull(propertyName)) {
            switch (pm.type()) {
                case LIST: {
                    value = this.invokeOnRowForList(row, pm, propertyName, pm.getValueClass());
                    break;
                }
                case SET: {
                    value = this.invokeOnRowForSet(row, pm, propertyName, pm.getValueClass());
                    break;
                }
                case MAP: {
                    Class keyClass = pm.getKeyClass();
                    Class valueClass = pm.getValueClass();
                    value = this.invokeOnRowForMap(row, pm, propertyName, keyClass, valueClass);
                    break;
                }
                case ID: 
                case SIMPLE: {
                    value = this.invokeOnRowForProperty(row, pm, propertyName, pm.getValueClass());
                    break;
                }
            }
        } else {
            switch (pm.type()) {
                case LIST: 
                case SET: 
                case MAP: {
                    value = pm.nullValueForCollectionAndMap();
                    break;
                }
            }
        }
        return value;
    }

    public Object extractCompoundPrimaryKeyFromRow(Row row, EntityMeta meta, PropertyMeta pm, EntityMeta.EntityState entityState) {
        log.trace("Extract compound primary key {} from CQL row for entity class {}", (Object)pm.getPropertyName(), (Object)pm.getEntityClassName());
        List<String> componentNames = pm.getCQLComponentNames();
        List<Class<?>> componentClasses = pm.getComponentClasses();
        ArrayList<Object> rawValues = new ArrayList<Object>(Collections.nCopies(componentNames.size(), null));
        try {
            for (ColumnDefinitions.Definition column : row.getColumnDefinitions()) {
                String columnName = column.getName();
                int index = componentNames.indexOf(columnName);
                if (index < 0) continue;
                Class<?> componentClass = componentClasses.get(index);
                Object rawValue = TypeMapper.getRowMethod(componentClass).invoke((Object)row, columnName);
                rawValues.set(index, rawValue);
            }
            if (entityState.isManaged() && !meta.hasOnlyStaticColumns()) {
                for (int i = 0; i < componentNames.size(); ++i) {
                    Validator.validateNotNull(rawValues.get(i), "Error, the component '%s' from @EmbeddedId class '%s' cannot be found in Cassandra", componentNames.get(i), pm.getValueClass());
                }
            }
            return pm.decodeFromComponents(rawValues);
        }
        catch (Exception e) {
            throw new AchillesException("Cannot retrieve compound primary key for entity class '" + pm.getEntityClassName() + "' from CQL Row", (Throwable)e);
        }
    }

    private Object invokeOnRowForProperty(Row row, PropertyMeta pm, String propertyName, Class<?> valueClass) {
        log.trace("Extract property {} from CQL row for entity class {}", (Object)propertyName, (Object)pm.getEntityClassName());
        try {
            Object rawValue = TypeMapper.getRowMethod(valueClass).invoke((Object)row, propertyName);
            return pm.decode(rawValue);
        }
        catch (Exception e) {
            throw new AchillesException("Cannot retrieve property '" + propertyName + "' for entity class '" + pm.getEntityClassName() + "' from CQL Row", (Throwable)e);
        }
    }

    public List<?> invokeOnRowForList(Row row, PropertyMeta pm, String propertyName, Class<?> valueClass) {
        log.trace("Extract list property {} from CQL row for entity class {}", (Object)propertyName, (Object)pm.getEntityClassName());
        try {
            List rawValues = row.getList(propertyName, TypeMapper.toCompatibleJavaType(valueClass));
            return pm.decode(rawValues);
        }
        catch (Exception e) {
            throw new AchillesException("Cannot retrieve list property '" + propertyName + "' from CQL Row", (Throwable)e);
        }
    }

    public Set<?> invokeOnRowForSet(Row row, PropertyMeta pm, String propertyName, Class<?> valueClass) {
        log.trace("Extract set property {} from CQL row for entity class {}", (Object)propertyName, (Object)pm.getEntityClassName());
        try {
            Set rawValues = row.getSet(propertyName, TypeMapper.toCompatibleJavaType(valueClass));
            return pm.decode(rawValues);
        }
        catch (Exception e) {
            throw new AchillesException("Cannot retrieve set property '" + propertyName + "' from CQL Row", (Throwable)e);
        }
    }

    public Map<?, ?> invokeOnRowForMap(Row row, PropertyMeta pm, String propertyName, Class<?> keyClass, Class<?> valueClass) {
        log.trace("Extract map property {} from CQL row for entity class {}", (Object)propertyName, (Object)pm.getEntityClassName());
        try {
            Map rawValues = row.getMap(propertyName, TypeMapper.toCompatibleJavaType(keyClass), TypeMapper.toCompatibleJavaType(valueClass));
            return pm.decode(rawValues);
        }
        catch (Exception e) {
            throw new AchillesException("Cannot retrieve map property '" + propertyName + "' from CQL Row", (Throwable)e);
        }
    }

    public <T> T invokeOnRowForType(Row row, Class<T> type, String name) {
        log.trace("Extract property {} of type {} from CQL row ", (Object)name, type);
        try {
            return (T)TypeMapper.getRowMethod(type).invoke((Object)row, name);
        }
        catch (Exception e) {
            throw new AchillesException("Cannot retrieve column '" + name + "' of type '" + type.getCanonicalName() + "' from CQL Row", (Throwable)e);
        }
    }
}

