/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.proxy.wrapper;

import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyChecker;
import info.archinnov.achilles.internal.proxy.wrapper.AbstractWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.collections.ListUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListWrapper
extends AbstractWrapper
implements List<Object> {
    private static final Logger log = LoggerFactory.getLogger(ListWrapper.class);
    private List<Object> target;

    public ListWrapper(List<Object> target) {
        this.target = target;
    }

    @Override
    public boolean add(Object arg0) {
        log.trace("Mark list property {} of entity class {} dirty upon element addition", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        Object element = this.proxifier.removeProxy(arg0);
        this.getDirtyChecker().appendListElements(Arrays.asList(arg0));
        return this.target.add(element);
    }

    @Override
    public boolean addAll(Collection<?> arg0) {
        Collection<?> elements = this.proxifier.removeProxy(arg0);
        boolean added = this.target.addAll(elements);
        if (added) {
            log.trace("Mark list property {} of entity class {} dirty upon elements addition", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
            this.getDirtyChecker().appendListElements(new ArrayList<Object>(elements));
        }
        return added;
    }

    @Override
    public void add(int index, Object arg1) {
        log.trace("Mark list property {} of entity class {} dirty upon element addition at index {}", new Object[]{this.propertyMeta.getPropertyName(), this.propertyMeta.getEntityClassName(), index});
        if (index != 0) {
            throw new UnsupportedOperationException("Append, Prepend, Remove, RemoveAll and SetValueAtIndex are the only supported operations for CQL3 lists");
        }
        Object element = this.proxifier.removeProxy(arg1);
        this.target.add(index, element);
        this.getDirtyChecker().prependListElements(Arrays.asList(element));
    }

    @Override
    public boolean addAll(int index, Collection<?> arg1) {
        if (index != 0) {
            throw new UnsupportedOperationException("Append, Prepend, Remove, RemoveAll and SetValueAtIndex are the only supported operations for CQL3 lists");
        }
        Collection<?> elements = this.proxifier.removeProxy(arg1);
        boolean result = this.target.addAll(index, elements);
        if (result) {
            log.trace("Mark list property {} of entity class {} dirty upon elements addition", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
            this.getDirtyChecker().prependListElements(new ArrayList<Object>(elements));
        }
        return result;
    }

    @Override
    public void clear() {
        if (this.target.size() > 0) {
            log.trace("Mark list property {} of entity class {} dirty upon clearance", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
            this.getDirtyChecker().removeAllElements();
        }
        this.target.clear();
    }

    @Override
    public Object get(int index) {
        log.trace("Return element at index {} for list property {} of entity class {}", new Object[]{index, this.propertyMeta.getPropertyName(), this.propertyMeta.getEntityClassName()});
        return this.target.get(index);
    }

    @Override
    public int indexOf(Object arg0) {
        return this.target.indexOf(this.proxifier.removeProxy(arg0));
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.target.lastIndexOf(this.proxifier.removeProxy(arg0));
    }

    @Override
    public ListIterator<Object> listIterator() {
        return new ArrayList<Object>(this.target).listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return new ArrayList<Object>(this.target).listIterator(index);
    }

    @Override
    public boolean contains(Object arg0) {
        return this.target.contains(this.proxifier.removeProxy(arg0));
    }

    @Override
    public boolean containsAll(Collection<?> arg0) {
        return this.target.containsAll(this.proxifier.removeProxy(arg0));
    }

    @Override
    public boolean isEmpty() {
        return this.target.isEmpty();
    }

    @Override
    public Iterator<Object> iterator() {
        log.trace("Build iterator wrapper for list property {} of entity class {}", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        return new ArrayList<Object>(this.target).iterator();
    }

    @Override
    public boolean remove(Object arg0) {
        Object element = this.proxifier.removeProxy(arg0);
        boolean result = this.target.remove(element);
        if (result) {
            log.trace("Mark list property {} of entity class {} dirty upon element removal", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
            this.getDirtyChecker().removeElements(Arrays.asList(element));
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> arg0) {
        Collection<?> elements = this.proxifier.removeProxy(arg0);
        boolean result = this.target.removeAll(elements);
        if (result) {
            log.trace("Mark list property {} of entity class {} dirty upon elements removal", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
            this.getDirtyChecker().removeElements(new ArrayList<Object>(elements));
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> arg0) {
        ArrayList argumentList = new ArrayList(this.proxifier.removeProxy(arg0));
        ArrayList<Object> originalList = new ArrayList<Object>(this.target);
        boolean result = this.target.retainAll(argumentList);
        if (result) {
            log.trace("Mark list property {} of entity class {} dirty upon elements removal", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
            List intersectionList = ListUtils.intersection(originalList, argumentList);
            List toBeRemoved = ListUtils.subtract(originalList, (List)intersectionList);
            this.getDirtyChecker().removeElements(toBeRemoved);
        }
        return result;
    }

    @Override
    public int size() {
        return this.target.size();
    }

    @Override
    public Object[] toArray() {
        return this.target.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arg0) {
        return this.target.toArray(arg0);
    }

    @Override
    public Object remove(int index) {
        log.trace("Mark list property {} of entity class {} dirty upon element removal at index {}", new Object[]{this.propertyMeta.getPropertyName(), this.propertyMeta.getEntityClassName(), index});
        Object result = this.target.remove(index);
        this.getDirtyChecker().removeListElementAtIndex(index);
        return result;
    }

    @Override
    public Object set(int index, Object arg1) {
        log.trace("Mark list property {} of entity class {} dirty upon element set at index {}", (Object)this.propertyMeta.getPropertyName(), (Object)this.propertyMeta.getEntityClassName());
        Object element = this.proxifier.removeProxy(arg1);
        Object result = this.target.set(index, element);
        this.getDirtyChecker().setListElementAtIndex(index, element);
        return result;
    }

    @Override
    public List<Object> subList(int from, int to) {
        return new ArrayList<Object>(this.target).subList(from, to);
    }

    public List<Object> getTarget() {
        return this.target;
    }

    @Override
    protected DirtyChecker getDirtyChecker() {
        if (!this.dirtyMap.containsKey(this.setter)) {
            this.dirtyMap.put(this.setter, new DirtyChecker(this.propertyMeta));
        }
        return (DirtyChecker)this.dirtyMap.get(this.setter);
    }
}

