/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.proxy.dirtycheck;

import com.datastax.driver.core.querybuilder.BindMarker;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Update;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.CollectionAndMapChangeType;
import info.archinnov.achilles.type.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class DirtyCheckChangeSet {
    private final CollectionAndMapChangeType changeType;
    private final PropertyMeta propertyMeta;
    protected List<Object> listChanges = new ArrayList<Object>();
    protected ElementAtIndex listChangeAtIndex = null;
    protected Set<Object> setChanges = new HashSet<Object>();
    protected Map<Object, Object> mapChanges = new HashMap<Object, Object>();

    public DirtyCheckChangeSet(PropertyMeta propertyMeta, CollectionAndMapChangeType changeType) {
        this.propertyMeta = propertyMeta;
        this.changeType = changeType;
    }

    public List<Object> getEncodedListChanges() {
        if (CollectionUtils.isNotEmpty(this.listChanges)) {
            return this.propertyMeta.encode(this.listChanges);
        }
        return this.listChanges;
    }

    public ElementAtIndex getEncodedListChangeAtIndex() {
        if (this.listChangeAtIndex != null && this.listChangeAtIndex.getElement() != null) {
            Object encodedElement = this.propertyMeta.encode(this.listChangeAtIndex.getElement());
            return new ElementAtIndex(this.listChangeAtIndex.getIndex(), encodedElement);
        }
        return this.listChangeAtIndex;
    }

    public Set<Object> getEncodedSetChanges() {
        if (CollectionUtils.isNotEmpty(this.setChanges)) {
            return this.propertyMeta.encode(this.setChanges);
        }
        return this.setChanges;
    }

    public Map<Object, Object> getEncodedMapChanges() {
        if (MapUtils.isNotEmpty(this.mapChanges)) {
            HashMap<Object, Object> encodedMapChanges = new HashMap<Object, Object>();
            for (Map.Entry<Object, Object> entry : this.mapChanges.entrySet()) {
                Object encodedKey = this.propertyMeta.encodeKey(entry.getKey());
                Object encodedValue = this.propertyMeta.encode(entry.getValue());
                encodedMapChanges.put(encodedKey, encodedValue);
            }
            return encodedMapChanges;
        }
        return this.mapChanges;
    }

    public CollectionAndMapChangeType getChangeType() {
        return this.changeType;
    }

    public PropertyMeta getPropertyMeta() {
        return this.propertyMeta;
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForAddedElements(Update.Conditions conditions, boolean preparedStatement) {
        Update.Assignments assignments;
        Set<Object> encodedElements = null;
        String propertyName = this.propertyMeta.getPropertyName();
        if (preparedStatement) {
            assignments = conditions.with(QueryBuilder.addAll((String)propertyName, (BindMarker)QueryBuilder.bindMarker((String)propertyName)));
        } else {
            encodedElements = this.getEncodedSetChanges();
            assignments = conditions.with(QueryBuilder.addAll((String)propertyName, encodedElements));
        }
        return Pair.create(assignments, new Object[]{encodedElements});
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForRemovedElements(Update.Conditions conditions, boolean preparedStatement) {
        Update.Assignments assignments;
        Set<Object> encodedElements = null;
        String propertyName = this.propertyMeta.getPropertyName();
        if (preparedStatement) {
            assignments = conditions.with(QueryBuilder.removeAll((String)propertyName, (BindMarker)QueryBuilder.bindMarker((String)propertyName)));
        } else {
            encodedElements = this.getEncodedSetChanges();
            assignments = conditions.with(QueryBuilder.removeAll((String)propertyName, encodedElements));
        }
        return Pair.create(assignments, new Object[]{encodedElements});
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForAppendedElements(Update.Conditions conditions, boolean preparedStatement) {
        Update.Assignments assignments;
        List<Object> encodedElements = null;
        String propertyName = this.propertyMeta.getPropertyName();
        if (preparedStatement) {
            assignments = conditions.with(QueryBuilder.appendAll((String)propertyName, (BindMarker)QueryBuilder.bindMarker((String)propertyName)));
        } else {
            encodedElements = this.getEncodedListChanges();
            assignments = conditions.with(QueryBuilder.appendAll((String)propertyName, encodedElements));
        }
        return Pair.create(assignments, new Object[]{encodedElements});
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForPrependedElements(Update.Conditions conditions, boolean preparedStatement) {
        Update.Assignments assignments;
        List<Object> encodedElements = null;
        String propertyName = this.propertyMeta.getPropertyName();
        if (preparedStatement) {
            assignments = conditions.with(QueryBuilder.prependAll((String)propertyName, (BindMarker)QueryBuilder.bindMarker((String)propertyName)));
        } else {
            encodedElements = this.getEncodedListChanges();
            assignments = conditions.with(QueryBuilder.prependAll((String)propertyName, encodedElements));
        }
        return Pair.create(assignments, new Object[]{encodedElements});
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForRemoveListElements(Update.Conditions conditions, boolean preparedStatement) {
        Update.Assignments assignments;
        List<Object> encodedElements = null;
        String propertyName = this.propertyMeta.getPropertyName();
        if (preparedStatement) {
            assignments = conditions.with(QueryBuilder.discardAll((String)propertyName, (BindMarker)QueryBuilder.bindMarker((String)propertyName)));
        } else {
            encodedElements = this.getEncodedListChanges();
            assignments = conditions.with(QueryBuilder.discardAll((String)propertyName, encodedElements));
        }
        return Pair.create(assignments, new Object[]{encodedElements});
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForSetAtIndexElement(Update.Conditions conditions) {
        ElementAtIndex elementAtIndex = this.getEncodedListChangeAtIndex();
        int index = elementAtIndex.getIndex();
        Object encoded = elementAtIndex.getElement();
        String propertyName = this.propertyMeta.getPropertyName();
        Update.Assignments assignments = conditions.with(QueryBuilder.setIdx((String)propertyName, (int)index, (Object)encoded));
        return Pair.create(assignments, new Object[]{index, encoded});
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForRemovedAtIndexElement(Update.Conditions conditions) {
        String propertyName = this.propertyMeta.getPropertyName();
        Update.Assignments assignments = conditions.with(QueryBuilder.setIdx((String)propertyName, (int)this.listChangeAtIndex.getIndex(), null));
        return Pair.create(assignments, new Object[]{this.listChangeAtIndex.getIndex(), null});
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForAddedEntries(Update.Conditions conditions, boolean preparedStatement) {
        Update.Assignments assignments;
        Map<Object, Object> encodedEntries = null;
        String propertyName = this.propertyMeta.getPropertyName();
        if (preparedStatement) {
            assignments = conditions.with(QueryBuilder.putAll((String)propertyName, (BindMarker)QueryBuilder.bindMarker((String)propertyName)));
        } else {
            encodedEntries = this.getEncodedMapChanges();
            assignments = conditions.with(QueryBuilder.putAll((String)propertyName, encodedEntries));
        }
        return Pair.create(assignments, new Object[]{encodedEntries});
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForRemovedKey(Update.Conditions conditions, boolean preparedStatement) {
        String propertyName = this.propertyMeta.getPropertyName();
        Object encodedKey = this.propertyMeta.encodeKey(this.mapChanges.keySet().iterator().next());
        Update.Assignments assignments = preparedStatement ? conditions.with(QueryBuilder.put((String)propertyName, (Object)QueryBuilder.bindMarker((String)"key"), (Object)QueryBuilder.bindMarker((String)"nullValue"))) : conditions.with(QueryBuilder.put((String)propertyName, (Object)encodedKey, null));
        return Pair.create(assignments, new Object[]{encodedKey, null});
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForRemoveAll(Update.Conditions conditions, boolean preparedStatement) {
        String propertyName = this.propertyMeta.getPropertyName();
        Update.Assignments assignments = preparedStatement ? conditions.with(QueryBuilder.set((String)propertyName, (Object)QueryBuilder.bindMarker((String)propertyName))) : conditions.with(QueryBuilder.set((String)propertyName, null));
        return Pair.create(assignments, new Object[]{null});
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForAssignValueToList(Update.Conditions conditions, boolean preparedStatement) {
        Update.Assignments assignments;
        List<Object> encodedElements = null;
        String propertyName = this.propertyMeta.getPropertyName();
        if (preparedStatement) {
            assignments = conditions.with(QueryBuilder.set((String)propertyName, (Object)QueryBuilder.bindMarker((String)propertyName)));
        } else {
            encodedElements = this.getEncodedListChanges();
            assignments = conditions.with(QueryBuilder.set((String)propertyName, encodedElements));
        }
        return Pair.create(assignments, new Object[]{encodedElements});
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForAssignValueToSet(Update.Conditions conditions, boolean preparedStatement) {
        Update.Assignments assignments;
        Set<Object> encodedElements = null;
        String propertyName = this.propertyMeta.getPropertyName();
        if (preparedStatement) {
            assignments = conditions.with(QueryBuilder.set((String)propertyName, (Object)QueryBuilder.bindMarker((String)propertyName)));
        } else {
            encodedElements = this.getEncodedSetChanges();
            assignments = conditions.with(QueryBuilder.set((String)propertyName, encodedElements));
        }
        return Pair.create(assignments, new Object[]{encodedElements});
    }

    public Pair<Update.Assignments, Object[]> generateUpdateForAssignValueToMap(Update.Conditions conditions, boolean preparedStatement) {
        Update.Assignments assignments;
        Map<Object, Object> encodedElements = null;
        String propertyName = this.propertyMeta.getPropertyName();
        if (preparedStatement) {
            assignments = conditions.with(QueryBuilder.set((String)propertyName, (Object)QueryBuilder.bindMarker((String)propertyName)));
        } else {
            encodedElements = this.getEncodedMapChanges();
            assignments = conditions.with(QueryBuilder.set((String)propertyName, encodedElements));
        }
        return Pair.create(assignments, new Object[]{encodedElements});
    }

    void setListChanges(List<Object> listChanges) {
        this.listChanges = listChanges;
    }

    void setListChangeAtIndex(ElementAtIndex listChangeAtIndex) {
        this.listChangeAtIndex = listChangeAtIndex;
    }

    void setSetChanges(Set<Object> setChanges) {
        this.setChanges = setChanges;
    }

    void setMapChanges(Map<Object, Object> mapChanges) {
        this.mapChanges = mapChanges;
    }

    public List<Object> getRawListChanges() {
        return this.listChanges;
    }

    public Set<Object> getRawSetChanges() {
        return this.setChanges;
    }

    public Map<Object, Object> getRawMapChanges() {
        return this.mapChanges;
    }

    public static class ElementAtIndex {
        private int index;
        private Object element;

        public ElementAtIndex(int index, Object element) {
            this.index = index;
            this.element = element;
        }

        public int getIndex() {
            return this.index;
        }

        public Object getElement() {
            return this.element;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ElementAtIndex that = (ElementAtIndex)o;
            return this.index == that.index && !(this.element == null ? that.element != null : !this.element.equals(that.element));
        }

        public int hashCode() {
            int result = this.index;
            result = 31 * result + (this.element != null ? this.element.hashCode() : 0);
            return result;
        }
    }
}

