/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.datastax.driver.core.Row;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.PersistenceContext;
import info.archinnov.achilles.internal.context.PersistenceContextFactory;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityMapper;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.statement.StatementGenerator;
import info.archinnov.achilles.internal.statement.wrapper.RegularStatementWrapper;
import info.archinnov.achilles.iterator.SliceQueryIterator;
import info.archinnov.achilles.query.slice.CQLSliceQuery;
import info.archinnov.achilles.query.slice.SliceQuery;
import info.archinnov.achilles.type.ConsistencyLevel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceQueryExecutor {
    private static final Logger log = LoggerFactory.getLogger(SliceQueryExecutor.class);
    private StatementGenerator generator = new StatementGenerator();
    private EntityMapper mapper = new EntityMapper();
    private EntityProxifier proxifier = new EntityProxifier();
    private PersistenceContextFactory contextFactory;
    private DaoContext daoContext;
    private ConsistencyLevel defaultReadLevel;

    public SliceQueryExecutor(PersistenceContextFactory contextFactory, ConfigurationContext configContext, DaoContext daoContext) {
        this.contextFactory = contextFactory;
        this.daoContext = daoContext;
        this.defaultReadLevel = configContext.getDefaultReadConsistencyLevel();
    }

    public <T> List<T> get(SliceQuery<T> sliceQuery) {
        log.debug("Get slice query");
        EntityMeta meta = sliceQuery.getMeta();
        ArrayList clusteredEntities = new ArrayList();
        CQLSliceQuery<T> cqlSliceQuery = new CQLSliceQuery<T>(sliceQuery, this.defaultReadLevel);
        RegularStatementWrapper statementWrapper = this.generator.generateSelectSliceQuery(cqlSliceQuery);
        List rows = this.daoContext.execute(statementWrapper).all();
        for (Row row : rows) {
            Object clusteredEntity = meta.instanciate();
            this.mapper.setNonCounterPropertiesToEntity(row, meta, clusteredEntity);
            meta.intercept(clusteredEntity, Event.POST_LOAD);
            clusteredEntities.add(clusteredEntity);
        }
        return Lists.transform(clusteredEntities, this.getProxyTransformer());
    }

    public <T> Iterator<T> iterator(SliceQuery<T> sliceQuery) {
        log.debug("Get iterator for slice query");
        CQLSliceQuery<T> cqlSliceQuery = new CQLSliceQuery<T>(sliceQuery, this.defaultReadLevel);
        RegularStatementWrapper statementWrapper = this.generator.generateSelectSliceQuery(cqlSliceQuery);
        Iterator iterator = this.daoContext.execute(statementWrapper).iterator();
        PersistenceContext context = this.buildContextForQuery(sliceQuery);
        return new SliceQueryIterator<T>(cqlSliceQuery, context, iterator);
    }

    public <T> void remove(SliceQuery<T> sliceQuery) {
        log.debug("Slice remove");
        CQLSliceQuery<T> cqlSliceQuery = new CQLSliceQuery<T>(sliceQuery, this.defaultReadLevel);
        cqlSliceQuery.validateSliceQueryForRemove();
        RegularStatementWrapper statementWrapper = this.generator.generateRemoveSliceQuery(cqlSliceQuery);
        this.daoContext.execute(statementWrapper);
    }

    protected <T> PersistenceContext buildContextForQuery(SliceQuery<T> sliceQuery) {
        log.trace("Build PersistenceContext for slice query");
        ConsistencyLevel cl = sliceQuery.getConsistencyLevel() == null ? this.defaultReadLevel : sliceQuery.getConsistencyLevel();
        return this.contextFactory.newContextForSliceQuery(sliceQuery.getEntityClass(), sliceQuery.getPartitionComponents(), cl);
    }

    private <T> Function<T, T> getProxyTransformer() {
        return new Function<T, T>(){

            public T apply(T clusteredEntity) {
                PersistenceContext context = SliceQueryExecutor.this.contextFactory.newContext(clusteredEntity);
                return SliceQueryExecutor.this.proxifier.buildProxyWithAllFieldsLoadedExceptCounters(clusteredEntity, context.getEntityFacade());
            }
        };
    }
}

