/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityValidator;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.Options;
import java.util.Map;

public class OptionsValidator {
    protected EntityValidator entityValidator = new EntityValidator();

    public void validateOptionsForInsert(Object entity, Map<Class<?>, EntityMeta> entityMetaMap, Options options) {
        this.validateNoTtlForClusteredCounter(entity, entityMetaMap, options);
        this.validateNoCasConditionsAndTtl(options);
    }

    public void validateOptionsForUpdate(Object entity, Map<Class<?>, EntityMeta> entityMetaMap, Options options) {
        this.validateNoTtlForClusteredCounter(entity, entityMetaMap, options);
        this.validateNoCasConditionsAndTtl(options);
    }

    private void validateNoCasConditionsAndTtl(Options options) {
        Validator.validateFalse(options.isIfNotExists() && options.getTimestamp().isPresent(), "Cannot provide custom timestamp for CAS insert operations", new Object[0]);
        Validator.validateFalse(options.hasCasConditions() && options.getTimestamp().isPresent(), "Cannot provide custom timestamp for CAS update operations", new Object[0]);
    }

    private void validateNoTtlForClusteredCounter(Object entity, Map<Class<?>, EntityMeta> entityMetaMap, Options options) {
        if (options.getTtl().isPresent()) {
            this.entityValidator.validateNotClusteredCounter(entity, entityMetaMap);
        }
    }
}

