/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Row;
import info.archinnov.achilles.internal.reflection.RowMethodInvoker;
import info.archinnov.achilles.type.TypedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativeQueryMapper {
    private static final Logger log = LoggerFactory.getLogger(NativeQueryMapper.class);
    private RowMethodInvoker cqlRowInvoker = new RowMethodInvoker();

    public List<TypedMap> mapRows(List<Row> rows) {
        log.trace("Map CQL rows to List<Map<ColumnName,Value>>");
        ArrayList<TypedMap> result = new ArrayList<TypedMap>();
        if (!rows.isEmpty()) {
            for (Row row : rows) {
                this.mapRow(result, row);
            }
        }
        return result;
    }

    private void mapRow(List<TypedMap> result, Row row) {
        log.trace("Map CQL row to a map of <ColumnName,Value>");
        ColumnDefinitions columnDefinitions = row.getColumnDefinitions();
        if (columnDefinitions != null) {
            TypedMap line = new TypedMap();
            for (ColumnDefinitions.Definition column : columnDefinitions) {
                this.mapColumn(row, (Map<String, Object>)line, column);
            }
            result.add(line);
        }
    }

    private void mapColumn(Row row, Map<String, Object> line, ColumnDefinitions.Definition column) {
        Object value;
        if (log.isTraceEnabled()) {
            log.trace("Extract data from CQL column [keyspace:{},table:{},column:{}]", new Object[]{column.getKeyspace(), column.getTable(), column.getName()});
        }
        DataType type = column.getType();
        Class javaClass = type.asJavaClass();
        String name = column.getName();
        if (type.isCollection()) {
            List typeArguments = type.getTypeArguments();
            value = List.class.isAssignableFrom(javaClass) ? row.getList(name, ((DataType)typeArguments.get(0)).asJavaClass()) : (Set.class.isAssignableFrom(javaClass) ? row.getSet(name, ((DataType)typeArguments.get(0)).asJavaClass()) : row.getMap(name, ((DataType)typeArguments.get(0)).asJavaClass(), ((DataType)typeArguments.get(1)).asJavaClass()));
        } else {
            value = this.cqlRowInvoker.invokeOnRowForType(row, javaClass, name);
        }
        line.put(name, value);
    }
}

