/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.CounterPersister;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.proxy.EntityInterceptor;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyCheckChangeSet;
import info.archinnov.achilles.internal.proxy.dirtycheck.DirtyChecker;
import info.archinnov.achilles.internal.validation.Validator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityUpdater {
    private static final Logger log = LoggerFactory.getLogger(EntityUpdater.class);
    private PropertyMetaComparator comparator = new PropertyMetaComparator();
    private CounterPersister counterPersister = new CounterPersister();
    private EntityProxifier proxifier = new EntityProxifier();

    public void update(EntityOperations context, Object entity) {
        log.debug("Merging entity of class {} with primary key {}", (Object)context.getEntityClass().getCanonicalName(), context.getPrimaryKey());
        EntityMeta entityMeta = context.getEntityMeta();
        Validator.validateNotNull(entity, "Proxy object should not be null for update", new Object[0]);
        Validator.validateNotNull(entityMeta, "entityMeta should not be null for update", new Object[0]);
        log.debug("Checking for dirty fields before merging");
        Object realObject = this.proxifier.getRealObject(entity);
        context.setEntity(realObject);
        EntityInterceptor<Object> interceptor = this.proxifier.getInterceptor(entity);
        Map<Method, DirtyChecker> dirtyMap = interceptor.getDirtyMap();
        ArrayList<DirtyChecker> dirtyCheckers = new ArrayList<DirtyChecker>(dirtyMap.values());
        if (dirtyCheckers.size() > 0) {
            this.pushDirtySimpleFields(context, dirtyCheckers);
            this.pushCollectionAndMapUpdates(context, dirtyCheckers);
            dirtyMap.clear();
        }
        if (context.isClusteredCounter()) {
            this.counterPersister.persistClusteredCounters(context);
        } else {
            this.counterPersister.persistCounters(context, entityMeta.getAllCounterMetas());
        }
        interceptor.setEntityOperations(context);
        interceptor.setTarget(realObject);
    }

    private void pushCollectionAndMapUpdates(EntityOperations context, List<DirtyChecker> dirtyCheckers) {
        ImmutableList collectionsAndMaps = FluentIterable.from(dirtyCheckers).filter(DirtyChecker.COLLECTION_AND_MAP_FIELD).toList();
        for (DirtyChecker dirtyChecker : collectionsAndMaps) {
            for (DirtyCheckChangeSet changeSet : dirtyChecker.getChangeSets()) {
                context.pushCollectionAndMapUpdateStatements(changeSet);
            }
        }
    }

    private void pushDirtySimpleFields(EntityOperations context, List<DirtyChecker> dirtyCheckers) {
        ArrayList<PropertyMeta> sortedSimpleMetas = new ArrayList<PropertyMeta>((Collection<PropertyMeta>)FluentIterable.from(dirtyCheckers).filter(DirtyChecker.SIMPLE_FIELD).transform(DirtyChecker.EXTRACT_META).toList());
        if (sortedSimpleMetas.size() > 0) {
            Collections.sort(sortedSimpleMetas, this.comparator);
            context.pushUpdateStatement(sortedSimpleMetas);
        }
    }

    public static class PropertyMetaComparator
    implements Comparator<PropertyMeta> {
        @Override
        public int compare(PropertyMeta arg0, PropertyMeta arg1) {
            return arg0.getPropertyName().compareTo(arg1.getPropertyName());
        }
    }
}

