/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import info.archinnov.achilles.exception.AchillesStaleObjectStateException;
import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.persistence.operations.EntityLoader;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.proxy.EntityInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityRefresher {
    private static final Logger log = LoggerFactory.getLogger(EntityRefresher.class);
    private EntityProxifier proxifier = new EntityProxifier();
    private EntityLoader loader = new EntityLoader();

    public void refresh(Object proxifiedEntity, EntityOperations context) throws AchillesStaleObjectStateException {
        Object primaryKey = context.getPrimaryKey();
        log.debug("Refreshing entity of class {} and primary key {}", (Object)context.getEntityClass().getCanonicalName(), primaryKey);
        EntityInterceptor<Object> interceptor = this.proxifier.getInterceptor(proxifiedEntity);
        Object entity = context.getEntity();
        interceptor.getDirtyMap().clear();
        Object freshEntity = this.loader.load(context, context.getEntityClass());
        if (freshEntity == null) {
            throw new AchillesStaleObjectStateException("The entity '" + entity + "' with primary_key '" + primaryKey + "' no longer exists in Cassandra");
        }
        interceptor.setTarget(freshEntity);
        interceptor.getAlreadyLoaded().clear();
        interceptor.getAlreadyLoaded().addAll(context.getAllGettersExceptCounters());
    }
}

