/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.persistence.operations.CounterPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityPersister {
    private static final Logger log = LoggerFactory.getLogger(EntityPersister.class);
    private CounterPersister counterPersister = new CounterPersister();

    public void persist(EntityOperations context) {
        EntityMeta entityMeta = context.getEntityMeta();
        Object entity = context.getEntity();
        log.debug("Persisting transient entity {}", entity);
        if (entityMeta.isClusteredCounter()) {
            this.counterPersister.persistClusteredCounters(context);
        } else {
            context.pushInsertStatement();
            this.counterPersister.persistCounters(context, entityMeta.getAllCounterMetas());
        }
    }

    public void remove(EntityOperations context) {
        log.trace("Removing entity using PersistenceContext {}", (Object)context);
        EntityMeta entityMeta = context.getEntityMeta();
        if (entityMeta.isClusteredCounter()) {
            context.bindForClusteredCounterRemoval();
        } else {
            context.bindForRemoval(entityMeta.getTableName());
            this.counterPersister.removeRelatedCounters(context);
        }
    }
}

