/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.datastax.driver.core.Row;
import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyType;
import info.archinnov.achilles.internal.persistence.operations.CounterLoader;
import info.archinnov.achilles.internal.persistence.operations.EntityMapper;
import info.archinnov.achilles.internal.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityLoader {
    private static final Logger log = LoggerFactory.getLogger(EntityLoader.class);
    private EntityMapper mapper = new EntityMapper();
    private CounterLoader counterLoader = new CounterLoader();

    public <T> T load(EntityOperations context, Class<T> entityClass) {
        log.debug("Loading entity of class {} using PersistenceContext {}", entityClass, (Object)context);
        EntityMeta entityMeta = context.getEntityMeta();
        Object primaryKey = context.getPrimaryKey();
        Validator.validateNotNull(entityClass, "Entity class should not be null", new Object[0]);
        Validator.validateNotNull(primaryKey, "Entity '%s' key should not be null", entityClass.getCanonicalName());
        Validator.validateNotNull(entityMeta, "Entity meta for '%s' should not be null", entityClass.getCanonicalName());
        T entity = null;
        if (entityMeta.isClusteredCounter()) {
            entity = this.counterLoader.loadClusteredCounters(context);
        } else {
            Row row = context.loadEntity();
            if (row != null) {
                entity = entityMeta.instanciate();
                this.mapper.setNonCounterPropertiesToEntity(row, entityMeta, entity);
            }
        }
        return entity;
    }

    public <T> T createEmptyEntity(EntityOperations context, Class<T> entityClass) {
        log.debug("Loading entity of class {} using PersistenceContext {}", entityClass, (Object)context);
        EntityMeta entityMeta = context.getEntityMeta();
        Object primaryKey = context.getPrimaryKey();
        Validator.validateNotNull(entityClass, "Entity class should not be null", new Object[0]);
        Validator.validateNotNull(primaryKey, "Entity '%s' key should not be null", entityClass.getCanonicalName());
        Validator.validateNotNull(entityMeta, "Entity meta for '%s' should not be null", entityClass.getCanonicalName());
        Object entity = entityMeta.instanciate();
        entityMeta.getIdMeta().setValueToField(entity, primaryKey);
        return entity;
    }

    public void loadPropertyIntoObject(EntityOperations context, Object realObject, PropertyMeta pm) {
        log.trace("Loading property {} into object {}", (Object)pm.getPropertyName(), realObject);
        PropertyType type = pm.type();
        if (type.isCounter()) {
            this.counterLoader.loadCounter(context, realObject, pm);
        } else {
            Row row = context.loadProperty(pm);
            this.mapper.setPropertyToEntity(row, context.getEntityMeta(), pm, realObject);
        }
    }
}

