/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.google.common.base.Optional;
import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.InternalCounterImpl;
import info.archinnov.achilles.type.CounterBuilder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CounterPersister {
    private static final Logger log = LoggerFactory.getLogger(CounterPersister.class);

    public void persistCounters(EntityOperations context, List<PropertyMeta> counterMetas) {
        log.trace("Persisting counters using PersistenceContext {}", (Object)context);
        Object entity = context.getEntity();
        for (PropertyMeta counterMeta : counterMetas) {
            long counterDelta;
            Object counter = counterMeta.getValueFromField(entity);
            if (counter == null || (counterDelta = this.retrieveCounterValue(counter)) == 0L) continue;
            context.bindForSimpleCounterIncrement(counterMeta, counterDelta);
        }
    }

    public void persistClusteredCounters(EntityOperations context) {
        log.trace("Persisting clustered counter using PersistenceContext {}", (Object)context);
        Object entity = context.getEntity();
        int nullCount = 0;
        List<PropertyMeta> allCountersMeta = context.getAllCountersMeta();
        for (PropertyMeta counterMeta : allCountersMeta) {
            Object counter = counterMeta.getValueFromField(entity);
            if (counter != null) {
                long counterDelta = this.retrieveCounterValue(counter);
                if (counterDelta == 0L) continue;
                context.pushClusteredCounterIncrementStatement(counterMeta, counterDelta);
                continue;
            }
            ++nullCount;
        }
        if (nullCount == allCountersMeta.size()) {
            throw new IllegalStateException("Cannot insert clustered counter entity '" + entity + "' with null clustered counter value");
        }
    }

    private long retrieveCounterValue(Object counter) {
        long counterDelta;
        if (InternalCounterImpl.class.isInstance(counter)) {
            Long counterVale = ((InternalCounterImpl)counter).getInternalCounterDelta();
            counterDelta = (Long)Optional.fromNullable((Object)counterVale).or((Object)0L);
        } else if (CounterBuilder.CounterImpl.class.isInstance(counter)) {
            counterDelta = ((CounterBuilder.CounterImpl)counter).get();
        } else {
            throw new IllegalArgumentException(String.format("The type of counter '%s' should be '%s' or '%s'", counter, InternalCounterImpl.class.getCanonicalName(), CounterBuilder.CounterImpl.class.getCanonicalName()));
        }
        return counterDelta;
    }

    public void removeRelatedCounters(EntityOperations context) {
        log.trace("Removing counter values related to entity using PersistenceContext {}", (Object)context);
        EntityMeta entityMeta = context.getEntityMeta();
        for (PropertyMeta pm : entityMeta.getAllCounterMetas()) {
            context.bindForSimpleCounterRemoval(pm);
        }
    }
}

