/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.persistence.operations;

import com.datastax.driver.core.Row;
import info.archinnov.achilles.internal.consistency.ConsistencyOverrider;
import info.archinnov.achilles.internal.context.facade.EntityOperations;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityMapper;
import info.archinnov.achilles.type.ConsistencyLevel;

public class CounterLoader {
    private EntityMapper mapper = new EntityMapper();
    private ConsistencyOverrider overrider = new ConsistencyOverrider();

    public <T> T loadClusteredCounters(EntityOperations context) {
        EntityMeta entityMeta = context.getEntityMeta();
        Object primaryKey = context.getPrimaryKey();
        T entity = null;
        Row row = context.getClusteredCounter();
        if (row != null) {
            entity = entityMeta.instanciate();
            entityMeta.getIdMeta().setValueToField(entity, primaryKey);
            for (PropertyMeta counterMeta : context.getAllCountersMeta()) {
                this.mapper.setCounterToEntity(counterMeta, entity, row);
            }
        }
        return entity;
    }

    public void loadClusteredCounterColumn(EntityOperations context, Object realObject, PropertyMeta counterMeta) {
        Long counterValue = context.getClusteredCounterColumn(counterMeta);
        this.mapper.setCounterToEntity(counterMeta, realObject, counterValue);
    }

    public void loadCounter(EntityOperations context, Object entity, PropertyMeta counterMeta) {
        ConsistencyLevel readLevel = this.overrider.getReadLevel(context, counterMeta);
        Long initialCounterValue = context.getSimpleCounter(counterMeta, readLevel);
        this.mapper.setCounterToEntity(counterMeta, entity, initialCounterValue);
    }
}

