/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.transcoding;

import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.transcoding.AbstractTranscoder;
import java.util.HashMap;
import java.util.Map;

public class MapTranscoder
extends AbstractTranscoder {
    public MapTranscoder(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public Object encode(PropertyMeta pm, Object entityValue) {
        return super.encodeInternal(pm.getValueClass(), entityValue);
    }

    @Override
    public Object encodeKey(PropertyMeta pm, Object entityValue) {
        return super.encodeInternal(pm.getKeyClass(), entityValue);
    }

    @Override
    public Map<Object, Object> encode(PropertyMeta pm, Map<?, ?> entityValue) {
        HashMap<Object, Object> encoded = new HashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : entityValue.entrySet()) {
            Object encodedKey = super.encodeInternal(pm.getKeyClass(), entry.getKey());
            Object encodedValue = super.encodeInternal(pm.getValueClass(), entry.getValue());
            encoded.put(encodedKey, encodedValue);
        }
        return encoded;
    }

    @Override
    public Object decode(PropertyMeta pm, Object cassandraValue) {
        return super.decodeInternal(pm.getValueClass(), cassandraValue);
    }

    @Override
    public Object decodeKey(PropertyMeta pm, Object cassandraValue) {
        return super.decodeInternal(pm.getKeyClass(), cassandraValue);
    }

    @Override
    public Map<Object, Object> decode(PropertyMeta pm, Map<?, ?> cassandraValue) {
        HashMap<Object, Object> decoded = new HashMap<Object, Object>();
        for (Map.Entry<?, ?> entry : cassandraValue.entrySet()) {
            Object decodedKey = super.decodeInternal(pm.getKeyClass(), entry.getKey());
            Object decodedValue = super.decodeInternal(pm.getValueClass(), entry.getValue());
            decoded.put(decodedKey, decodedValue);
        }
        return decoded;
    }
}

