/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.transcoding;

import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.transcoding.AbstractTranscoder;
import info.archinnov.achilles.internal.validation.Validator;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundTranscoder
extends AbstractTranscoder {
    private static final Logger log = LoggerFactory.getLogger(CompoundTranscoder.class);

    public CompoundTranscoder(ObjectMapper objectMapper) {
        super(objectMapper);
    }

    @Override
    public List<Object> encodeToComponents(PropertyMeta idMeta, Object compoundKey, boolean onlyStaticColumns) {
        log.trace("Encode {} to CQL components", compoundKey);
        ArrayList<Object> compoundComponents = new ArrayList<Object>();
        List<Class<?>> componentClasses = idMeta.getComponentClasses();
        if (compoundKey != null) {
            List<Field> componentFields = onlyStaticColumns ? idMeta.getPartitionComponentFields() : idMeta.getComponentFields();
            for (int i = 0; i < componentFields.size(); ++i) {
                Object component = this.invoker.getValueFromField(compoundKey, componentFields.get(i));
                Object encoded = super.encodeInternal(componentClasses.get(i), component);
                compoundComponents.add(encoded);
            }
        }
        return compoundComponents;
    }

    @Override
    public List<Object> encodeToComponents(PropertyMeta pm, List<?> components) {
        log.trace("Encode {} to CQL components", components);
        ArrayList<Object> encodedComponents = new ArrayList<Object>();
        List<Class<?>> componentClasses = pm.getComponentClasses();
        for (Object component : components) {
            if (component == null) continue;
            Class<?> componentClass = component.getClass();
            Validator.validateTrue(componentClasses.contains(componentClass), "The component {} for embedded id {} has an unknown type. Valid types are {}", component, pm.getValueClass().getCanonicalName(), componentClasses);
            Object encoded = super.encodeInternal(componentClass, component);
            encodedComponents.add(encoded);
        }
        return encodedComponents;
    }

    @Override
    public Object decodeFromComponents(PropertyMeta idMeta, List<?> components) {
        log.trace("Decode from CQL components", components);
        List<Field> componentFields = idMeta.getComponentFields();
        ArrayList<Object> decodedComponents = new ArrayList<Object>();
        List<Class<?>> componentClasses = idMeta.getComponentClasses();
        for (int i = 0; i < components.size(); ++i) {
            Object decoded = super.decodeInternal(componentClasses.get(i), components.get(i));
            decodedComponents.add(decoded);
        }
        Object compoundKey = this.injectValues(idMeta, decodedComponents, componentFields);
        return compoundKey;
    }

    private Object injectValues(PropertyMeta pm, List<?> components, List<Field> componentFields) {
        log.trace("Instantiate primary compound key from CQL components {}", components);
        Object compoundKey = pm.instantiate();
        for (int i = 0; i < components.size(); ++i) {
            Object compValue = components.get(i);
            this.invoker.setValueToField(compoundKey, componentFields.get(i), compValue);
        }
        return compoundKey;
    }
}

