/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.transcoding;

import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.parsing.PropertyParser;
import info.archinnov.achilles.internal.metadata.transcoding.DataTranscoder;
import info.archinnov.achilles.internal.reflection.ReflectionInvoker;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTranscoder
implements DataTranscoder {
    private static final Logger log = LoggerFactory.getLogger(AbstractTranscoder.class);
    protected ObjectMapper objectMapper;
    protected ReflectionInvoker invoker = new ReflectionInvoker();

    public AbstractTranscoder(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    @Override
    public Object encode(PropertyMeta pm, Object entityValue) {
        throw new AchillesException("Transcoder cannot encode value '" + entityValue + "' for type '" + pm.type().name() + "'");
    }

    @Override
    public Object encodeKey(PropertyMeta pm, Object entityValue) {
        throw new AchillesException("Transcoder cannot encode key '" + entityValue + "' for type '" + pm.type().name() + "'");
    }

    @Override
    public List<Object> encode(PropertyMeta pm, List<?> entityValue) {
        throw new AchillesException("Transcoder cannot encode value '" + entityValue + "' for type '" + pm.type().name() + "'");
    }

    @Override
    public Set<Object> encode(PropertyMeta pm, Set<?> entityValue) {
        throw new AchillesException("Transcoder cannot encode value '" + entityValue + "' for type '" + pm.type().name() + "'");
    }

    @Override
    public Map<Object, Object> encode(PropertyMeta pm, Map<?, ?> entityValue) {
        throw new AchillesException("Transcoder cannot encode value '" + entityValue + "' for type '" + pm.type().name() + "'");
    }

    @Override
    public List<Object> encodeToComponents(PropertyMeta pm, Object compoundKey, boolean onlyStaticColumns) {
        throw new AchillesException("Transcoder cannot encode from value '" + compoundKey + "' to components for type '" + pm.type().name() + "'");
    }

    @Override
    public List<Object> encodeToComponents(PropertyMeta pm, List<?> components) {
        throw new AchillesException("Transcoder cannot encode components value '" + components + "'");
    }

    @Override
    public Object decode(PropertyMeta pm, Object cassandraValue) {
        throw new AchillesException("Transcoder cannot decode value '" + cassandraValue + "' for type '" + pm.type().name() + "'");
    }

    @Override
    public Object decodeKey(PropertyMeta pm, Object cassandraValue) {
        throw new AchillesException("Transcoder cannot decode key '" + cassandraValue + "' for type '" + pm.type().name() + "'");
    }

    @Override
    public List<Object> decode(PropertyMeta pm, List<?> cassandraValue) {
        throw new AchillesException("Transcoder cannot decode value '" + cassandraValue + "' for type '" + pm.type().name() + "'");
    }

    @Override
    public Set<Object> decode(PropertyMeta pm, Set<?> cassandraValue) {
        throw new AchillesException("Transcoder cannot decode value '" + cassandraValue + "' for type '" + pm.type().name() + "'");
    }

    @Override
    public Map<Object, Object> decode(PropertyMeta pm, Map<?, ?> cassandraValue) {
        throw new AchillesException("Transcoder cannot decode value '" + cassandraValue + "' for type '" + pm.type().name() + "'");
    }

    @Override
    public Object decodeFromComponents(PropertyMeta pm, List<?> components) {
        throw new AchillesException("Transcoder cannot decode from components '" + components + "' to value for type '" + pm.type().name() + "'");
    }

    Object encodeInternal(Class<?> sourceType, Object entityValue) {
        log.trace("Encode {} to CQL type {}", entityValue, sourceType);
        if (Byte.TYPE.isAssignableFrom(sourceType) || Byte.class.isAssignableFrom(sourceType)) {
            return ByteBuffer.wrap(new byte[]{(Byte)entityValue});
        }
        if (byte[].class.isAssignableFrom(sourceType)) {
            return ByteBuffer.wrap((byte[])entityValue);
        }
        if (PropertyParser.isAssignableFromNativeType(sourceType)) {
            return entityValue;
        }
        if (sourceType.isEnum()) {
            return ((Enum)entityValue).name();
        }
        return this.forceEncodeToJSON(entityValue);
    }

    Object decodeInternal(Class<?> targetType, Object cassandraValue) {
        log.trace("Decode {} from CQL type {}", cassandraValue, targetType);
        if (Byte.TYPE.isAssignableFrom(targetType) || Byte.class.isAssignableFrom(targetType)) {
            byte[] byteBuffer = this.readByteBuffer(cassandraValue);
            if (byteBuffer.length < 1) {
                throw new AchillesException("Error while decoding value '" + cassandraValue + "' to type '" + targetType.getCanonicalName() + "'");
            }
            return byteBuffer[0];
        }
        if (byte[].class.isAssignableFrom(targetType)) {
            return this.readByteBuffer(cassandraValue);
        }
        if (PropertyParser.isSupportedNativeType(targetType)) {
            return cassandraValue;
        }
        if (targetType.isEnum()) {
            return Enum.valueOf(targetType, (String)cassandraValue);
        }
        if (cassandraValue instanceof String) {
            return this.forceDecodeFromJSON((String)cassandraValue, targetType);
        }
        throw new AchillesException("Error while decoding value '" + cassandraValue + "' to type '" + targetType.getCanonicalName() + "'");
    }

    private byte[] readByteBuffer(Object cassandraValue) {
        ByteBuffer byteBuffer = (ByteBuffer)cassandraValue;
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        return bytes;
    }

    @Override
    public String forceEncodeToJSON(Object object) {
        log.trace("Force encode {} to JSON", object);
        String result = null;
        if (object != null) {
            if (object instanceof String) {
                result = (String)String.class.cast(object);
            } else {
                try {
                    return this.objectMapper.writeValueAsString(object);
                }
                catch (Exception e) {
                    throw new AchillesException("Error while encoding value '" + object + "'", (Throwable)e);
                }
            }
        }
        return result;
    }

    @Override
    public <T> T forceDecodeFromJSON(String cassandraValue, Class<T> targetType) {
        log.trace("Force decode {} from JSON to type {}", (Object)cassandraValue, targetType);
        String result = null;
        if (cassandraValue != null) {
            if (targetType == String.class) {
                result = cassandraValue;
            } else {
                try {
                    return (T)this.objectMapper.readValue(cassandraValue, targetType);
                }
                catch (Exception e) {
                    throw new AchillesException("Error while decoding value '" + cassandraValue + "' to type '" + targetType.getCanonicalName() + "'", (Throwable)e);
                }
            }
        }
        return (T)result;
    }
}

