/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing.validator;

import info.archinnov.achilles.exception.AchillesBeanMappingException;
import info.archinnov.achilles.internal.metadata.parsing.PropertyParser;
import info.archinnov.achilles.internal.metadata.parsing.context.PropertyParsingContext;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyParsingValidator {
    private static final Logger log = LoggerFactory.getLogger(PropertyParsingValidator.class);

    public void validateNoDuplicate(PropertyParsingContext context) {
        String propertyName = context.getCurrentPropertyName();
        log.debug("Validate that property name {} is unique for the entity class {}", (Object)propertyName, (Object)context.getCurrentEntityClass().getCanonicalName());
        Validator.validateBeanMappingFalse(context.getPropertyMetas().containsKey(propertyName), "The property '%s' is already used for the entity '%s'", propertyName, context.getCurrentEntityClass().getCanonicalName());
    }

    public void validateMapGenerics(Field field, Class<?> entityClass) {
        log.debug("Validate parameterized types for property {} of entity class {}", (Object)field.getName(), (Object)entityClass.getCanonicalName());
        Type genericType = field.getGenericType();
        if (!(genericType instanceof ParameterizedType)) {
            throw new AchillesBeanMappingException("The Map type should be parameterized for the entity '" + entityClass.getCanonicalName() + "'");
        }
        ParameterizedType pt = (ParameterizedType)genericType;
        Type[] actualTypeArguments = pt.getActualTypeArguments();
        if (actualTypeArguments.length <= 1) {
            throw new AchillesBeanMappingException("The Map type should be parameterized with <K,V> for the entity '" + entityClass.getCanonicalName() + "'");
        }
    }

    public void validateConsistencyLevelForCounter(PropertyParsingContext context, Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels) {
        log.debug("Validate that counter property {} of entity class {} does not have ANY consistency level", (Object)context.getCurrentPropertyName(), (Object)context.getCurrentEntityClass().getCanonicalName());
        if (consistencyLevels.left == ConsistencyLevel.ANY || consistencyLevels.right == ConsistencyLevel.ANY) {
            throw new AchillesBeanMappingException("Counter field '" + context.getCurrentField().getName() + "' of entity '" + context.getCurrentEntityClass().getCanonicalName() + "' cannot have ANY as read/write consistency level. All consistency levels except ANY are allowed");
        }
    }

    public void validateIndexIfSet(PropertyParsingContext context) {
        String fieldName = context.getCurrentPropertyName();
        String className = context.getCurrentEntityClass().getCanonicalName();
        log.debug("Validate that this property {} of entity class {} has a properly set index parameter, if set", (Object)fieldName, (Object)className);
        if (PropertyParser.getIndexName(context.getCurrentField()) != null) {
            Validator.validateBeanMappingTrue(PropertyParser.isSupportedType(context.getCurrentField().getType()), "Property '%s' of entity '%s' cannot be indexed because the type '%s' is not supported", fieldName, className, context.getCurrentField().getType().getCanonicalName());
            Validator.validateBeanMappingFalse(context.isEmbeddedId(), "Property '%s' of entity '%s' is part of a compound primary key and therefore cannot be indexed", fieldName, className);
            Validator.validateBeanMappingFalse(context.isPrimaryKey(), "Property '%s' of entity '%s' is a primary key and therefore cannot be indexed", fieldName, className);
        }
    }

    public static void validateAllowedTypes(Class<?> type, Set<Class<?>> allowedTypes, String message) {
        log.debug("Validate that type {} is supported", type);
        if (!allowedTypes.contains(type) && !type.isEnum()) {
            throw new AchillesBeanMappingException(message);
        }
    }
}

