/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing.context;

import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.parsing.context.PropertyParsingContext;
import info.archinnov.achilles.json.ObjectMapperFactory;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.InsertStrategy;
import info.archinnov.achilles.type.Pair;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EntityParsingContext {
    private ConfigurationContext configContext;
    private Boolean hasCounter = false;
    private Map<String, PropertyMeta> propertyMetas = new HashMap<String, PropertyMeta>();
    private List<PropertyMeta> counterMetas = new ArrayList<PropertyMeta>();
    private Class<?> currentEntityClass;
    private ObjectMapper currentObjectMapper;
    private Pair<ConsistencyLevel, ConsistencyLevel> currentConsistencyLevels;

    public EntityParsingContext(ConfigurationContext configContext, Class<?> currentEntityClass) {
        this.configContext = configContext;
        this.currentEntityClass = currentEntityClass;
    }

    public PropertyParsingContext newPropertyContext(Field currentField) {
        return new PropertyParsingContext(this, currentField);
    }

    public Class<?> getCurrentEntityClass() {
        return this.currentEntityClass;
    }

    public Map<String, PropertyMeta> getPropertyMetas() {
        return this.propertyMetas;
    }

    public Boolean hasSimpleCounter() {
        return this.hasCounter;
    }

    public void setHasSimpleCounter(Boolean hasCounter) {
        this.hasCounter = hasCounter;
    }

    public ObjectMapper getCurrentObjectMapper() {
        return this.currentObjectMapper;
    }

    public void setCurrentObjectMapper(ObjectMapper currentObjectMapper) {
        this.currentObjectMapper = currentObjectMapper;
    }

    public void setCurrentConsistencyLevels(Pair<ConsistencyLevel, ConsistencyLevel> currentConsistencyLevels) {
        this.currentConsistencyLevels = currentConsistencyLevels;
    }

    public List<PropertyMeta> getCounterMetas() {
        return this.counterMetas;
    }

    public Pair<ConsistencyLevel, ConsistencyLevel> getCurrentConsistencyLevels() {
        return this.currentConsistencyLevels;
    }

    public ObjectMapperFactory getObjectMapperFactory() {
        return this.configContext.getObjectMapperFactory();
    }

    public boolean isSchemaUpdateEnabled(String columnFamilyName) {
        Map<String, Boolean> columnFamilyUpdateMap = this.configContext.getEnableSchemaUpdateForTables();
        if (columnFamilyUpdateMap.containsKey(columnFamilyName)) {
            return columnFamilyUpdateMap.get(columnFamilyName);
        }
        return this.configContext.isEnableSchemaUpdate();
    }

    public InsertStrategy getDefaultInsertStrategy() {
        return this.configContext.getInsertStrategy();
    }

    public ConfigurationContext getConfigContext() {
        return this.configContext;
    }
}

