/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing;

import info.archinnov.achilles.annotations.Column;
import info.archinnov.achilles.annotations.EmbeddedId;
import info.archinnov.achilles.annotations.Id;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyFilter {
    private static final Logger log = LoggerFactory.getLogger(PropertyFilter.class);
    static final List<Class<?>> acceptedAnnotations = new ArrayList();

    public boolean matches(Field field) {
        log.trace("Does the field {} of class {} has the annotations @Id/@EmbeddedId/@Column ?", (Object)field.getName(), (Object)field.getDeclaringClass().getCanonicalName());
        for (Class<?> clazz : acceptedAnnotations) {
            if (!this.hasAnnotation(field, clazz)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(Field field, Class<?> annotation) {
        log.trace("Does the field {} of class {} has the annotations {} ?", new Object[]{field.getName(), field.getDeclaringClass().getCanonicalName(), annotation.getCanonicalName()});
        return this.hasAnnotation(field, annotation);
    }

    public boolean matches(Field field, Class<?> annotation, String propertyName) {
        log.trace("Does the field {} of class {} has the annotations {} ?", new Object[]{field.getName(), field.getDeclaringClass().getCanonicalName(), annotation.getCanonicalName()});
        return this.hasAnnotation(field, annotation) && field.getName().equals(propertyName);
    }

    public boolean hasAnnotation(Field field, Class<?> annotationClass) {
        log.trace("Does the field {} of class {} has the annotations {} ?", new Object[]{field.getName(), field.getDeclaringClass().getCanonicalName(), annotationClass.getCanonicalName()});
        return field.getAnnotation(annotationClass) != null;
    }

    static {
        acceptedAnnotations.add(Id.class);
        acceptedAnnotations.add(EmbeddedId.class);
        acceptedAnnotations.add(Column.class);
    }
}

