/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import info.archinnov.achilles.annotations.Consistency;
import info.archinnov.achilles.annotations.Entity;
import info.archinnov.achilles.annotations.Strategy;
import info.archinnov.achilles.exception.AchillesBeanMappingException;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.helper.LoggerHelper;
import info.archinnov.achilles.internal.metadata.parsing.PropertyFilter;
import info.archinnov.achilles.internal.metadata.parsing.context.EntityParsingContext;
import info.archinnov.achilles.internal.table.TableNameNormalizer;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.InsertStrategy;
import info.archinnov.achilles.type.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityIntrospector {
    private static final Logger log = LoggerFactory.getLogger(EntityIntrospector.class);
    private PropertyFilter filter = new PropertyFilter();

    protected String[] deriveGetterName(Field field) {
        log.debug("Derive getter name for field {} from class {}", (Object)field.getName(), (Object)field.getDeclaringClass().getCanonicalName());
        String camelCase = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        Object[] getters = StringUtils.equals((String)field.getType().toString(), (String)"boolean") ? new String[]{"is" + camelCase, "get" + camelCase} : new String[]{"get" + camelCase};
        if (log.isTraceEnabled()) {
            log.trace("Derived getters : {}", (Object)StringUtils.join((Object[])getters, (String)","));
        }
        return getters;
    }

    protected String deriveSetterName(Field field) {
        log.debug("Derive setter name for field {} from class {}", (Object)field.getName(), (Object)field.getDeclaringClass().getCanonicalName());
        String fieldName = field.getName();
        String setter = "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
        log.trace("Derived setter : {}", (Object)setter);
        return setter;
    }

    public Method findGetter(Class<?> beanClass, Field field) {
        String[] getters;
        log.debug("Find getter for field {} in class {}", (Object)field.getName(), (Object)beanClass.getCanonicalName());
        Method getterMethod = null;
        String fieldName = field.getName();
        for (String getter : getters = this.deriveGetterName(field)) {
            try {
                getterMethod = beanClass.getMethod(getter, new Class[0]);
                if (getterMethod.getReturnType() == field.getType()) continue;
                throw new AchillesBeanMappingException("The getter for field '" + fieldName + "' of type '" + field.getDeclaringClass().getCanonicalName() + "' does not return correct type");
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (getterMethod == null) {
            throw new AchillesBeanMappingException("The getter for field '" + fieldName + "' of type '" + field.getDeclaringClass().getCanonicalName() + "' does not exist");
        }
        log.trace("Derived getter method : {}", (Object)getterMethod.getName());
        return getterMethod;
    }

    public Method findSetter(Class<?> beanClass, Field field) {
        log.debug("Find setter for field {} in class {}", (Object)field.getName(), (Object)beanClass.getCanonicalName());
        String fieldName = field.getName();
        try {
            String setter = this.deriveSetterName(field);
            Method setterMethod = beanClass.getMethod(setter, field.getType());
            if (!setterMethod.getReturnType().toString().equals("void")) {
                throw new AchillesBeanMappingException("The setter for field '" + fieldName + "' of type '" + field.getDeclaringClass().getCanonicalName() + "' does not return correct type or does not have the correct parameter");
            }
            log.trace("Derived setter method : {}", (Object)setterMethod.getName());
            return setterMethod;
        }
        catch (NoSuchMethodException e) {
            throw new AchillesBeanMappingException("The setter for field '" + fieldName + "' of type '" + field.getDeclaringClass().getCanonicalName() + "' does not exist or is incorrect");
        }
    }

    public Method[] findAccessors(Class<?> beanClass, Field field) {
        log.debug("Find accessors for field {} in class {}", (Object)field.getName(), (Object)beanClass.getCanonicalName());
        Method[] accessors = new Method[]{this.findGetter(beanClass, field), this.findSetter(beanClass, field)};
        return accessors;
    }

    public String inferTableName(Class<?> entity, String canonicalName) {
        String columnFamilyName = null;
        Entity annotation = entity.getAnnotation(Entity.class);
        if (annotation != null && StringUtils.isNotBlank((String)annotation.table())) {
            columnFamilyName = annotation.table();
        }
        columnFamilyName = !StringUtils.isBlank(columnFamilyName) ? TableNameNormalizer.normalizerAndValidateColumnFamilyName(columnFamilyName) : TableNameNormalizer.normalizerAndValidateColumnFamilyName(canonicalName);
        log.debug("Inferred columnFamilyName for entity {} : {}", (Object)canonicalName, (Object)columnFamilyName);
        return columnFamilyName;
    }

    public <T> Pair<ConsistencyLevel, ConsistencyLevel> findConsistencyLevels(Class<T> entity, String tableName, ConfigurationContext configContext) {
        log.debug("Find consistency levels for entity class {}", (Object)entity.getCanonicalName());
        ConsistencyLevel readLevel = configContext.getDefaultReadConsistencyLevel();
        ConsistencyLevel writeLevel = configContext.getDefaultWriteConsistencyLevel();
        Consistency clevel = entity.getAnnotation(Consistency.class);
        if (clevel != null) {
            readLevel = clevel.read();
            writeLevel = clevel.write();
        }
        readLevel = (ConsistencyLevel)Optional.fromNullable((Object)configContext.getReadConsistencyLevelForTable(tableName)).or((Object)readLevel);
        writeLevel = (ConsistencyLevel)Optional.fromNullable((Object)configContext.getWriteConsistencyLevelForTable(tableName)).or((Object)writeLevel);
        log.trace("Found consistency levels : {}/{}", (Object)readLevel, (Object)writeLevel);
        return Pair.create(readLevel, writeLevel);
    }

    public List<Field> getInheritedPrivateFields(Class<?> type) {
        log.debug("Find inherited private fields from hierarchy for entity class {}", (Object)type.getCanonicalName());
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field declaredField : i.getDeclaredFields()) {
                if (!this.filter.matches(declaredField)) continue;
                fields.add(declaredField);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Found inherited private fields : {}", (Object)Lists.transform(fields, LoggerHelper.fieldToStringFn));
        }
        return fields;
    }

    public Field getInheritedPrivateFields(Class<?> type, Class<?> annotation) {
        log.debug("Find private field from hierarchy with annotation {} for entity class {}", (Object)annotation.getCanonicalName(), (Object)type.getCanonicalName());
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field declaredField : i.getDeclaredFields()) {
                if (!this.filter.matches(declaredField, annotation)) continue;
                log.trace("Found inherited private field : {}", (Object)declaredField);
                return declaredField;
            }
        }
        return null;
    }

    public Field getInheritedPrivateFields(Class<?> type, Class<?> annotation, String name) {
        log.debug("Find private field with name {} having annotation {} from hierarchy for entity class {}", new Object[]{name, annotation.getCanonicalName(), type.getCanonicalName()});
        for (Class<?> i = type; i != null && i != Object.class; i = i.getSuperclass()) {
            for (Field declaredField : i.getDeclaredFields()) {
                if (!this.filter.matches(declaredField, annotation, name)) continue;
                log.trace("Found inherited private field : {}", (Object)declaredField);
                return declaredField;
            }
        }
        return null;
    }

    public InsertStrategy getInsertStrategy(Class<?> type, EntityParsingContext parsingContext) {
        Strategy strategy = type.getAnnotation(Strategy.class);
        return strategy != null ? strategy.insert() : parsingContext.getDefaultInsertStrategy();
    }
}

