/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.parsing;

import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import info.archinnov.achilles.annotations.Column;
import info.archinnov.achilles.annotations.Order;
import info.archinnov.achilles.annotations.PartitionKey;
import info.archinnov.achilles.annotations.TimeUUID;
import info.archinnov.achilles.exception.AchillesBeanMappingException;
import info.archinnov.achilles.internal.metadata.holder.EmbeddedIdProperties;
import info.archinnov.achilles.internal.metadata.holder.EmbeddedIdPropertiesBuilder;
import info.archinnov.achilles.internal.metadata.parsing.EntityIntrospector;
import info.archinnov.achilles.internal.metadata.parsing.PropertyFilter;
import info.archinnov.achilles.internal.metadata.parsing.PropertyParser;
import info.archinnov.achilles.internal.metadata.parsing.validator.PropertyParsingValidator;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.schemabuilder.Create;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.reflections.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedIdParser {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedIdParser.class);
    protected EntityIntrospector entityIntrospector = new EntityIntrospector();
    private PropertyFilter filter = new PropertyFilter();

    public EmbeddedIdProperties parseEmbeddedId(Class<?> embeddedIdClass) {
        log.debug("Parse embedded id class {} ", (Object)embeddedIdClass.getCanonicalName());
        this.checkForDefaultConstructor(embeddedIdClass);
        Map<Integer, Field> components = this.extractComponentsOrdering(embeddedIdClass);
        this.validateConsistentPartitionKeys(components, embeddedIdClass.getCanonicalName());
        List<Create.Options.ClusteringOrder> clusteringOrders = this.extractClusteredOrder(embeddedIdClass);
        EmbeddedIdProperties embeddedIdProperties = this.buildComponentMetas(embeddedIdClass, components, clusteringOrders);
        log.trace("Built embeddedId properties : {}", (Object)embeddedIdProperties);
        return embeddedIdProperties;
    }

    private Map<Integer, Field> extractComponentsOrdering(Class<?> embeddedIdClass) {
        log.trace("Extract components ordering from embedded id class {} ", (Object)embeddedIdClass.getCanonicalName());
        String embeddedIdClassName = embeddedIdClass.getCanonicalName();
        TreeMap<Integer, Field> components = new TreeMap<Integer, Field>();
        Set candidateFields = ReflectionUtils.getAllFields(embeddedIdClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Order.class)});
        HashSet<Integer> orders = new HashSet<Integer>();
        int orderSum = 0;
        int componentCount = candidateFields.size();
        for (Field candidateField : candidateFields) {
            Order orderAnnotation = candidateField.getAnnotation(Order.class);
            int order = orderAnnotation.value();
            Class<?> componentType = candidateField.getType();
            orderSum = this.validateNoDuplicateOrderAndType(embeddedIdClassName, orders, orderSum, order, componentType);
            components.put(order, candidateField);
        }
        this.validateConsistentOrdering(embeddedIdClassName, orderSum, componentCount);
        Validator.validateBeanMappingTrue(componentCount > 1, "There should be at least 2 fields annotated with @Order for the @EmbeddedId class '%s'", embeddedIdClass.getCanonicalName());
        return components;
    }

    private List<Create.Options.ClusteringOrder> extractClusteredOrder(Class<?> embeddedIdClass) {
        log.debug("Extract clustering component order from embedded id class {} ", (Object)embeddedIdClass.getCanonicalName());
        LinkedList<Create.Options.ClusteringOrder> sortOrders = new LinkedList<Create.Options.ClusteringOrder>();
        Set candidateFields = ReflectionUtils.getAllFields(embeddedIdClass, (Predicate[])new Predicate[]{ReflectionUtils.withAnnotation(Order.class)});
        ImmutableList clusteringFields = FluentIterable.from((Iterable)candidateFields).filter((Predicate)new Predicate<Field>(){

            public boolean apply(Field field) {
                Order orderAnnotation = field.getAnnotation(Order.class);
                return !EmbeddedIdParser.this.filter.hasAnnotation(field, PartitionKey.class) && orderAnnotation.value() > 1;
            }
        }).toSortedList((Comparator)new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                Order order1 = o1.getAnnotation(Order.class);
                Order order2 = o2.getAnnotation(Order.class);
                return new Integer(order1.value()).compareTo(new Integer(order2.value()));
            }
        });
        for (Field clusteringField : clusteringFields) {
            Order order = clusteringField.getAnnotation(Order.class);
            String columnName = this.extractColumnName(clusteringField);
            sortOrders.add(new Create.Options.ClusteringOrder(columnName, order.reversed() ? Create.Options.ClusteringOrder.Sorting.DESC : Create.Options.ClusteringOrder.Sorting.ASC));
        }
        return sortOrders;
    }

    private int validateNoDuplicateOrderAndType(String embeddedIdClassName, Set<Integer> orders, int orderSum, int order, Class<?> componentType) {
        log.debug("Validate type and component ordering for embedded id class {} ", (Object)embeddedIdClassName);
        Validator.validateBeanMappingTrue(orders.add(order), "The order '%s' is duplicated in @EmbeddedId class '%s'", order, embeddedIdClassName);
        PropertyParsingValidator.validateAllowedTypes(componentType, PropertyParser.allowedTypes, "The class '" + componentType.getCanonicalName() + "' is not a valid component type for the @EmbeddedId class '" + embeddedIdClassName + "'");
        return orderSum += order;
    }

    private void validateConsistentOrdering(String embeddedIdClassName, int orderSum, int componentCount) {
        int check = componentCount * (componentCount + 1) / 2;
        log.debug("Validate component ordering for @EmbeddedId class {} ", (Object)embeddedIdClassName);
        Validator.validateBeanMappingTrue(orderSum == check, "The component ordering is wrong for @EmbeddedId class '%s'", embeddedIdClassName);
    }

    private void validateConsistentPartitionKeys(Map<Integer, Field> componentsOrdering, String embeddedIdClassName) {
        log.debug("Validate composite partition key component ordering for @EmbeddedId class {} ", (Object)embeddedIdClassName);
        int orderSum = 0;
        int orderCount = 0;
        for (Integer order : componentsOrdering.keySet()) {
            Field componentField = componentsOrdering.get(order);
            if (!this.filter.hasAnnotation(componentField, PartitionKey.class)) continue;
            orderSum += order.intValue();
            ++orderCount;
        }
        int check = orderCount * (orderCount + 1) / 2;
        Validator.validateBeanMappingTrue(orderSum == check, "The composite partition key ordering is wrong for @EmbeddedId class '%s'", embeddedIdClassName);
    }

    private EmbeddedIdProperties buildComponentMetas(Class<?> embeddedIdClass, Map<Integer, Field> components, List<Create.Options.ClusteringOrder> clusteringOrders) {
        log.debug("Build components meta data for embedded id class {}", (Object)embeddedIdClass.getCanonicalName());
        EmbeddedIdPropertiesBuilder partitionKeysBuilder = new EmbeddedIdPropertiesBuilder();
        EmbeddedIdPropertiesBuilder clusteringKeysBuilder = new EmbeddedIdPropertiesBuilder();
        clusteringKeysBuilder.setClusteringOrders(clusteringOrders);
        EmbeddedIdPropertiesBuilder embeddedIdPropertiesBuilder = new EmbeddedIdPropertiesBuilder();
        boolean hasPartitionKeyAnnotation = this.buildPartitionAndClusteringKeys(embeddedIdClass, components, partitionKeysBuilder, clusteringKeysBuilder, embeddedIdPropertiesBuilder);
        if (!hasPartitionKeyAnnotation) {
            partitionKeysBuilder.addComponentName(clusteringKeysBuilder.removeFirstComponentName());
            partitionKeysBuilder.addComponentClass(clusteringKeysBuilder.removeFirstComponentClass());
            partitionKeysBuilder.addComponentField(clusteringKeysBuilder.removeFirstComponentField());
            partitionKeysBuilder.addComponentGetter(clusteringKeysBuilder.removeFirstComponentGetter());
            partitionKeysBuilder.addComponentSetter(clusteringKeysBuilder.removeFirstComponentSetter());
        }
        return embeddedIdPropertiesBuilder.buildEmbeddedIdProperties(partitionKeysBuilder.buildPartitionKeys(), clusteringKeysBuilder.buildClusteringKeys());
    }

    private boolean buildPartitionAndClusteringKeys(Class<?> embeddedIdClass, Map<Integer, Field> components, EmbeddedIdPropertiesBuilder partitionKeysBuilder, EmbeddedIdPropertiesBuilder clusteringKeysBuilder, EmbeddedIdPropertiesBuilder embeddedIdPropertiesBuilder) {
        log.debug("Build Components meta data for embedded id class {}", (Object)embeddedIdClass.getCanonicalName());
        boolean hasPartitionKeyAnnotation = false;
        for (Integer order : components.keySet()) {
            Field compositeKeyField = components.get(order);
            Class<?> componentClass = compositeKeyField.getType();
            Method componentGetter = this.entityIntrospector.findGetter(embeddedIdClass, compositeKeyField);
            Method componentSetter = this.entityIntrospector.findSetter(embeddedIdClass, compositeKeyField);
            String componentName = this.extractColumnName(compositeKeyField);
            embeddedIdPropertiesBuilder.addComponentName(componentName);
            embeddedIdPropertiesBuilder.addComponentClass(componentClass);
            embeddedIdPropertiesBuilder.addComponentField(compositeKeyField);
            embeddedIdPropertiesBuilder.addComponentGetter(componentGetter);
            embeddedIdPropertiesBuilder.addComponentSetter(componentSetter);
            if (this.filter.hasAnnotation(compositeKeyField, TimeUUID.class)) {
                embeddedIdPropertiesBuilder.addTimeUUIDComponent(componentName);
            }
            if (this.filter.hasAnnotation(compositeKeyField, PartitionKey.class)) {
                partitionKeysBuilder.addComponentName(componentName);
                partitionKeysBuilder.addComponentClass(componentClass);
                partitionKeysBuilder.addComponentField(compositeKeyField);
                partitionKeysBuilder.addComponentGetter(componentGetter);
                partitionKeysBuilder.addComponentSetter(componentSetter);
                hasPartitionKeyAnnotation = true;
                continue;
            }
            clusteringKeysBuilder.addComponentName(componentName);
            clusteringKeysBuilder.addComponentClass(componentClass);
            clusteringKeysBuilder.addComponentField(compositeKeyField);
            clusteringKeysBuilder.addComponentGetter(componentGetter);
            clusteringKeysBuilder.addComponentSetter(componentSetter);
        }
        return hasPartitionKeyAnnotation;
    }

    private String extractColumnName(Field compositeKeyField) {
        Column column = compositeKeyField.getAnnotation(Column.class);
        String componentName = column != null && StringUtils.isNotBlank((String)column.name()) ? column.name() : compositeKeyField.getName();
        if (column != null && column.staticColumn()) {
            throw new AchillesBeanMappingException(String.format("The property '%s' of class '%s' cannot be a static column because it belongs to the primary key", componentName, compositeKeyField.getDeclaringClass().getCanonicalName()));
        }
        return componentName;
    }

    private void checkForDefaultConstructor(Class<?> embeddedIdClass) {
        Set defaultConstructors = ReflectionUtils.getAllConstructors(embeddedIdClass, (Predicate[])new Predicate[]{ReflectionUtils.withParametersCount((int)0)});
        Validator.validateBeanMappingFalse(defaultConstructors.isEmpty(), "The @EmbeddedId class '%s' should have a public default constructor", embeddedIdClass.getCanonicalName());
    }
}

