/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.fasterxml.jackson.databind.ObjectMapper;
import info.archinnov.achilles.internal.metadata.holder.CounterProperties;
import info.archinnov.achilles.internal.metadata.holder.EmbeddedIdProperties;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyType;
import info.archinnov.achilles.internal.metadata.transcoding.CompoundTranscoder;
import info.archinnov.achilles.internal.metadata.transcoding.DataTranscoder;
import info.archinnov.achilles.internal.metadata.transcoding.ListTranscoder;
import info.archinnov.achilles.internal.metadata.transcoding.MapTranscoder;
import info.archinnov.achilles.internal.metadata.transcoding.SetTranscoder;
import info.archinnov.achilles.internal.metadata.transcoding.SimpleTranscoder;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMetaBuilder {
    private static final Logger log = LoggerFactory.getLogger(PropertyMetaBuilder.class);
    private PropertyType type;
    private String propertyName;
    private String entityClassName;
    private Method[] accessors;
    private Field field;
    private ObjectMapper objectMapper;
    private CounterProperties counterProperties;
    private EmbeddedIdProperties embeddedIdProperties;
    private Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels;
    private boolean timeUUID = false;
    private boolean emptyCollectionAndMapIfNull = false;
    private boolean staticColumn = false;

    public static PropertyMetaBuilder factory() {
        return new PropertyMetaBuilder();
    }

    public PropertyMetaBuilder propertyName(String propertyName) {
        this.propertyName = propertyName;
        return this;
    }

    public PropertyMetaBuilder entityClassName(String entityClassName) {
        this.entityClassName = entityClassName;
        return this;
    }

    public PropertyMetaBuilder objectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public PropertyMeta build(Class<?> keyClass, Class<?> valueClass) {
        log.debug("Build propertyMeta for property {} of entity class {}", (Object)this.propertyName, (Object)this.entityClassName);
        PropertyMeta meta = new PropertyMeta();
        meta.setField(this.field);
        meta.setType(this.type);
        meta.setPropertyName(this.propertyName);
        meta.setEntityClassName(this.entityClassName);
        meta.setKeyClass(keyClass);
        meta.setValueClass(valueClass);
        meta.setGetter(this.accessors[0]);
        meta.setSetter(this.accessors[1]);
        meta.setEmbeddedIdProperties(this.embeddedIdProperties);
        meta.setCounterProperties(this.counterProperties);
        meta.setConsistencyLevels(this.consistencyLevels);
        meta.setTranscoder(this.determineTranscoder());
        meta.setTimeUUID(this.timeUUID);
        meta.setEmptyCollectionAndMapIfNull(this.emptyCollectionAndMapIfNull);
        meta.setStaticColumn(this.staticColumn);
        return meta;
    }

    public PropertyMetaBuilder type(PropertyType type) {
        this.type = type;
        return this;
    }

    public PropertyMetaBuilder accessors(Method[] accessors) {
        this.accessors = accessors;
        return this;
    }

    public PropertyMetaBuilder field(Field field) {
        this.field = field;
        return this;
    }

    public PropertyMetaBuilder embeddedIdProperties(EmbeddedIdProperties embeddedIdProperties) {
        this.embeddedIdProperties = embeddedIdProperties;
        return this;
    }

    public PropertyMetaBuilder counterProperties(CounterProperties counterProperties) {
        this.counterProperties = counterProperties;
        return this;
    }

    public PropertyMetaBuilder consistencyLevels(Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels) {
        this.consistencyLevels = consistencyLevels;
        return this;
    }

    public PropertyMetaBuilder timeuuid(boolean timeUUID) {
        this.timeUUID = timeUUID;
        return this;
    }

    public PropertyMetaBuilder staticColumn(boolean staticColumn) {
        this.staticColumn = staticColumn;
        return this;
    }

    public PropertyMetaBuilder emptyCollectionAndMapIfNull(boolean emptyCollectionAndMapIfNull) {
        this.emptyCollectionAndMapIfNull = emptyCollectionAndMapIfNull;
        return this;
    }

    private DataTranscoder determineTranscoder() {
        switch (this.type) {
            case EMBEDDED_ID: {
                return new CompoundTranscoder(this.objectMapper);
            }
            case ID: 
            case COUNTER: 
            case SIMPLE: {
                return new SimpleTranscoder(this.objectMapper);
            }
            case LIST: {
                return new ListTranscoder(this.objectMapper);
            }
            case SET: {
                return new SetTranscoder(this.objectMapper);
            }
            case MAP: {
                return new MapTranscoder(this.objectMapper);
            }
        }
        return null;
    }
}

