/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.metadata.holder.CounterProperties;
import info.archinnov.achilles.internal.metadata.holder.EmbeddedIdProperties;
import info.archinnov.achilles.internal.metadata.holder.IndexProperties;
import info.archinnov.achilles.internal.metadata.holder.InternalTimeUUID;
import info.archinnov.achilles.internal.metadata.holder.PropertyType;
import info.archinnov.achilles.internal.metadata.transcoding.DataTranscoder;
import info.archinnov.achilles.internal.persistence.operations.InternalCounterImpl;
import info.archinnov.achilles.internal.reflection.ReflectionInvoker;
import info.archinnov.achilles.schemabuilder.Create;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Pair;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMeta {
    private static final Logger log = LoggerFactory.getLogger(PropertyMeta.class);
    public static final Predicate<PropertyMeta> STATIC_COLUMN_FILTER = new Predicate<PropertyMeta>(){

        public boolean apply(PropertyMeta pm) {
            return pm.isStaticColumn();
        }
    };
    public static final Predicate<PropertyMeta> COUNTER_COLUMN_FILTER = new Predicate<PropertyMeta>(){

        public boolean apply(PropertyMeta pm) {
            return pm.isCounter();
        }
    };
    private static final Function<String, String> TO_LOWER_CASE = new Function<String, String>(){

        public String apply(String input) {
            String result = null;
            if (StringUtils.isNotBlank((String)input)) {
                result = input.toLowerCase();
            }
            return result;
        }
    };
    private PropertyType type;
    private String propertyName;
    private String entityClassName;
    private Class<?> keyClass;
    private Class<?> valueClass;
    private Method getter;
    private Method setter;
    private Field field;
    private CounterProperties counterProperties;
    private EmbeddedIdProperties embeddedIdProperties;
    private IndexProperties indexProperties;
    private Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels;
    private boolean timeUUID = false;
    private DataTranscoder transcoder;
    private boolean emptyCollectionAndMapIfNull = false;
    private boolean staticColumn = false;
    private ReflectionInvoker invoker = new ReflectionInvoker();

    public List<Field> getComponentFields() {
        log.trace("Get component fields");
        List<Field> compFields = new ArrayList<Field>();
        if (this.embeddedIdProperties != null) {
            compFields = this.embeddedIdProperties.getComponentFields();
        }
        return compFields;
    }

    public List<Method> getComponentGetters() {
        log.trace("Get component getters");
        List<Method> compGetters = new ArrayList<Method>();
        if (this.embeddedIdProperties != null) {
            compGetters = this.embeddedIdProperties.getComponentGetters();
        }
        return compGetters;
    }

    public Field getPartitionKeyField() {
        log.trace("Get partition key field");
        Field field = null;
        if (this.embeddedIdProperties != null) {
            field = this.embeddedIdProperties.getComponentFields().get(0);
        }
        return field;
    }

    public List<Method> getComponentSetters() {
        log.trace("Get component setters");
        List<Method> compSetters = new ArrayList<Method>();
        if (this.embeddedIdProperties != null) {
            compSetters = this.embeddedIdProperties.getComponentSetters();
        }
        return compSetters;
    }

    public List<Class<?>> getComponentClasses() {
        List<Class<?>> compClasses = new ArrayList();
        if (this.embeddedIdProperties != null) {
            compClasses = this.embeddedIdProperties.getComponentClasses();
        }
        return compClasses;
    }

    public List<String> getComponentNames() {
        log.trace("Get component classes");
        ArrayList<String> components = new ArrayList<String>();
        if (this.embeddedIdProperties != null) {
            return this.embeddedIdProperties.getComponentNames();
        }
        return components;
    }

    public String getVaryingComponentNameForQuery(int fixedComponentsSize) {
        log.trace("Get varying component name for CQL query");
        String componentName = null;
        if (this.embeddedIdProperties != null) {
            componentName = this.embeddedIdProperties.getVaryingComponentNameForQuery(fixedComponentsSize);
        }
        return componentName;
    }

    public List<String> getCQLComponentNames() {
        log.trace("Get CQL component names");
        return FluentIterable.from(this.getComponentNames()).transform(TO_LOWER_CASE).toList();
    }

    public List<String> getClusteringComponentNames() {
        log.trace("Get clustering component names");
        return this.embeddedIdProperties != null ? this.embeddedIdProperties.getClusteringComponentNames() : Arrays.asList(new String[0]);
    }

    public List<Class<?>> getClusteringComponentClasses() {
        log.trace("Get clustering component classes");
        return this.embeddedIdProperties != null ? this.embeddedIdProperties.getClusteringComponentClasses() : Arrays.asList(new Class[0]);
    }

    public List<String> getPartitionComponentNames() {
        log.trace("Get partition key component names");
        return this.embeddedIdProperties != null ? this.embeddedIdProperties.getPartitionComponentNames() : Arrays.asList(new String[0]);
    }

    public List<Class<?>> getPartitionComponentClasses() {
        log.trace("Get partition key component classes");
        return this.embeddedIdProperties != null ? this.embeddedIdProperties.getPartitionComponentClasses() : Arrays.asList(this.valueClass);
    }

    public List<Object> extractPartitionComponents(List<Object> components) {
        log.trace("Extract partition key components");
        return this.embeddedIdProperties != null ? this.embeddedIdProperties.extractPartitionComponents(components) : Arrays.asList(new Object[0]);
    }

    public void validatePartitionComponents(List<Object> partitionComponents) {
        log.trace("Validate partition key components");
        if (this.embeddedIdProperties != null) {
            this.embeddedIdProperties.validatePartitionComponents(this.entityClassName, partitionComponents);
        }
    }

    public void validateClusteringComponents(List<Object> clusteringComponents) {
        log.trace("Validate clustering components");
        if (this.embeddedIdProperties != null) {
            this.embeddedIdProperties.validateClusteringComponents(this.entityClassName, clusteringComponents);
        }
    }

    public List<Field> getPartitionComponentFields() {
        log.trace("Get partition key component fields");
        return this.embeddedIdProperties != null ? this.embeddedIdProperties.getPartitionComponentFields() : Arrays.asList(new Field[0]);
    }

    public List<Object> extractClusteringComponents(List<Object> components) {
        log.trace("Extract clustering components");
        return this.embeddedIdProperties != null ? this.embeddedIdProperties.extractClusteringComponents(components) : Arrays.asList(new Object[0]);
    }

    public boolean isPrimaryKeyTimeUUID(String componentName) {
        log.trace("Determine whether component {} is of TimeUUID type", (Object)componentName);
        return this.embeddedIdProperties != null && this.embeddedIdProperties.getTimeUUIDComponents().contains(componentName);
    }

    public String getOrderingComponent() {
        log.trace("Get ordering component name");
        String component = null;
        if (this.embeddedIdProperties != null) {
            return this.embeddedIdProperties.getOrderingComponent();
        }
        return component;
    }

    public List<Create.Options.ClusteringOrder> getClusteringOrders() {
        log.trace("Get clustering orders if any");
        LinkedList<Create.Options.ClusteringOrder> clusteringOrders = new LinkedList<Create.Options.ClusteringOrder>();
        if (this.embeddedIdProperties != null) {
            return this.embeddedIdProperties.getCluseringOrders();
        }
        return clusteringOrders;
    }

    public PropertyMeta counterIdMeta() {
        return this.counterProperties != null ? this.counterProperties.getIdMeta() : null;
    }

    public String fqcn() {
        return this.counterProperties != null ? this.counterProperties.getFqcn() : null;
    }

    public boolean isCounter() {
        return this.type.isCounter();
    }

    public boolean isEmbeddedId() {
        return this.type.isEmbeddedId();
    }

    public boolean isClustered() {
        boolean isClustered = false;
        if (this.embeddedIdProperties != null) {
            isClustered = !this.embeddedIdProperties.getClusteringComponentClasses().isEmpty();
        }
        return isClustered;
    }

    public ConsistencyLevel getReadConsistencyLevel() {
        return this.consistencyLevels != null ? (ConsistencyLevel)this.consistencyLevels.left : null;
    }

    public ConsistencyLevel getWriteConsistencyLevel() {
        return this.consistencyLevels != null ? (ConsistencyLevel)this.consistencyLevels.right : null;
    }

    public Object decode(Object cassandraValue) {
        return cassandraValue == null ? null : this.transcoder.decode(this, cassandraValue);
    }

    public Object decodeKey(Object cassandraValue) {
        return cassandraValue == null ? null : this.transcoder.decodeKey(this, cassandraValue);
    }

    public List<Object> decode(List<?> cassandraValue) {
        return cassandraValue == null ? null : this.transcoder.decode(this, cassandraValue);
    }

    public Set<Object> decode(Set<?> cassandraValue) {
        return cassandraValue == null ? null : this.transcoder.decode(this, cassandraValue);
    }

    public Map<Object, Object> decode(Map<?, ?> cassandraValue) {
        return cassandraValue == null ? null : this.transcoder.decode(this, cassandraValue);
    }

    public Object decodeFromComponents(List<?> components) {
        return components == null ? null : this.transcoder.decodeFromComponents(this, components);
    }

    public Object getAndEncodeValueForCassandra(Object entity) {
        Object value = this.getValueFromField(entity);
        Object encoded = null;
        if (value != null) {
            switch (this.type) {
                case SIMPLE: {
                    encoded = this.transcoder.encode(this, value);
                    break;
                }
                case LIST: {
                    encoded = this.transcoder.encode(this, (List)value);
                    break;
                }
                case SET: {
                    encoded = this.transcoder.encode(this, (Set)value);
                    break;
                }
                case MAP: {
                    encoded = this.transcoder.encode(this, (Map)value);
                    break;
                }
                case COUNTER: {
                    encoded = ((InternalCounterImpl)value).getInternalCounterDelta();
                    break;
                }
                default: {
                    throw new AchillesException("Cannot encode value '" + value + "' for Cassandra for property '" + this.propertyName + "' of type '" + this.type.name() + "'");
                }
            }
        }
        return encoded;
    }

    public Object encode(Object entityValue) {
        return entityValue == null ? null : this.transcoder.encode(this, entityValue);
    }

    public Object encodeKey(Object entityValue) {
        return entityValue == null ? null : this.transcoder.encodeKey(this, entityValue);
    }

    public <T> List<Object> encode(List<T> entityValue) {
        return entityValue == null ? null : this.transcoder.encode(this, entityValue);
    }

    public Set<Object> encode(Set<?> entityValue) {
        return entityValue == null ? null : this.transcoder.encode(this, entityValue);
    }

    public Map<Object, Object> encode(Map<?, ?> entityValue) {
        return entityValue == null ? null : this.transcoder.encode(this, entityValue);
    }

    public List<Object> encodeToComponents(Object compoundKey, boolean onlyStaticColumns) {
        return compoundKey == null ? null : this.transcoder.encodeToComponents(this, compoundKey, onlyStaticColumns);
    }

    public List<Object> encodeToComponents(List<Object> components) {
        return components == null ? null : this.transcoder.encodeToComponents(this, components);
    }

    public String forceEncodeToJSON(Object object) {
        return this.transcoder.forceEncodeToJSON(object);
    }

    public Object forceDecodeFromJSON(String cassandraValue, Class<?> targetType) {
        return this.transcoder.forceDecodeFromJSON(cassandraValue, targetType);
    }

    public Object forceDecodeFromJSON(String cassandraValue) {
        return this.transcoder.forceDecodeFromJSON(cassandraValue, this.valueClass);
    }

    public Object getPrimaryKey(Object entity) {
        log.trace("Extract primary from entity {}", entity);
        if (this.type.isId()) {
            return this.invoker.getPrimaryKey(entity, this);
        }
        throw new IllegalStateException("Cannot get primary key on a non id field '" + this.propertyName + "'");
    }

    public Object getPartitionKey(Object compoundKey) {
        log.trace("Extract partition key from primary compound key {}", compoundKey);
        if (this.type.isEmbeddedId()) {
            return this.invoker.getPartitionKey(compoundKey, this);
        }
        throw new IllegalStateException("Cannot get partition key on a non embedded id field '" + this.propertyName + "'");
    }

    public Object instantiate() {
        log.trace("Instantiate new entity of type{}", (Object)this.entityClassName);
        return this.invoker.instantiate(this.valueClass);
    }

    public Object getValueFromField(Object target) {
        return this.invoker.getValueFromField(target, this.field);
    }

    public Object invokeGetter(Object target) {
        return this.invoker.getValueFromField(target, this.getter);
    }

    public <T> List<T> getListValueFromField(Object target) {
        return this.invoker.getListValueFromField(target, this.field);
    }

    public <T> Set<T> getSetValueFromField(Object target) {
        return this.invoker.getSetValueFromField(target, this.field);
    }

    public <K, V> Map<K, V> getMapValueFromField(Object target) {
        return this.invoker.getMapValueFromField(target, this.field);
    }

    public void setValueToField(Object target, Object args) {
        this.invoker.setValueToField(target, this.field, args);
    }

    public Class<?> getValueClassForTableCreation() {
        if (this.timeUUID) {
            return InternalTimeUUID.class;
        }
        return this.valueClass;
    }

    public PropertyType type() {
        return this.type;
    }

    public void setType(PropertyType propertyType) {
        this.type = propertyType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public <T> Class<T> getKeyClass() {
        return this.keyClass;
    }

    public void setKeyClass(Class<?> keyClass) {
        this.keyClass = keyClass;
    }

    public <T> Class<T> getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(Class<?> valueClass) {
        this.valueClass = valueClass;
    }

    public Method getGetter() {
        return this.getter;
    }

    public void setGetter(Method getter) {
        this.getter = getter;
    }

    public Method getSetter() {
        return this.setter;
    }

    public void setSetter(Method setter) {
        this.setter = setter;
    }

    public Field getField() {
        return this.field;
    }

    public void setField(Field field) {
        this.field = field;
    }

    public EmbeddedIdProperties getEmbeddedIdProperties() {
        return this.embeddedIdProperties;
    }

    public void setEmbeddedIdProperties(EmbeddedIdProperties embeddedIdProperties) {
        this.embeddedIdProperties = embeddedIdProperties;
    }

    public CounterProperties getCounterProperties() {
        return this.counterProperties;
    }

    public void setCounterProperties(CounterProperties counterProperties) {
        this.counterProperties = counterProperties;
    }

    public void setConsistencyLevels(Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels) {
        this.consistencyLevels = consistencyLevels;
    }

    public String getEntityClassName() {
        return this.entityClassName;
    }

    public void setEntityClassName(String entityClassName) {
        this.entityClassName = entityClassName;
    }

    public boolean isIndexed() {
        return this.indexProperties != null;
    }

    public IndexProperties getIndexProperties() {
        return this.indexProperties;
    }

    public void setIndexProperties(IndexProperties indexProperties) {
        this.indexProperties = indexProperties;
    }

    public DataTranscoder getTranscoder() {
        return this.transcoder;
    }

    public void setTranscoder(DataTranscoder transcoder) {
        this.transcoder = transcoder;
    }

    public ReflectionInvoker getInvoker() {
        return this.invoker;
    }

    public void setInvoker(ReflectionInvoker invoker) {
        this.invoker = invoker;
    }

    public boolean isTimeUUID() {
        return this.timeUUID;
    }

    public void setTimeUUID(boolean timeUUID) {
        this.timeUUID = timeUUID;
    }

    public void setEmptyCollectionAndMapIfNull(boolean emptyCollectionAndMapIfNull) {
        this.emptyCollectionAndMapIfNull = emptyCollectionAndMapIfNull;
    }

    public boolean isStaticColumn() {
        return this.staticColumn;
    }

    public void setStaticColumn(boolean staticColumn) {
        this.staticColumn = staticColumn;
    }

    public String getCQL3PropertyName() {
        return this.propertyName;
    }

    public Object nullValueForCollectionAndMap() {
        Cloneable value = null;
        if (this.emptyCollectionAndMapIfNull) {
            switch (this.type) {
                case LIST: {
                    value = new ArrayList();
                    break;
                }
                case SET: {
                    value = new HashSet();
                    break;
                }
                case MAP: {
                    value = new HashMap();
                    break;
                }
            }
        }
        return value;
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("type", (Object)this.type).add("entityClassName", (Object)this.entityClassName).add("propertyName", (Object)this.propertyName).add("keyClass", this.keyClass).add("valueClass", this.valueClass).add("counterProperties", (Object)this.counterProperties).add("embeddedIdProperties", (Object)this.embeddedIdProperties).add("consistencyLevels", this.consistencyLevels).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.entityClassName, this.propertyName, this.type});
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyMeta other = (PropertyMeta)obj;
        return Objects.equal((Object)this.entityClassName, (Object)other.getEntityClassName()) && Objects.equal((Object)this.propertyName, (Object)other.getPropertyName()) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type()));
    }
}

