/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.interceptor.Event;
import info.archinnov.achilles.interceptor.Interceptor;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyType;
import info.archinnov.achilles.internal.metadata.parsing.PropertyParser;
import info.archinnov.achilles.internal.reflection.ReflectionInvoker;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.IndexCondition;
import info.archinnov.achilles.type.InsertStrategy;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.Pair;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class EntityMeta {
    public static final boolean IS_MANAGED = true;
    public static final boolean IS_NOT_MANAGED = false;
    public static final Predicate<EntityMeta> CLUSTERED_COUNTER_FILTER = new Predicate<EntityMeta>(){

        public boolean apply(EntityMeta meta) {
            return meta.isClusteredCounter();
        }
    };
    public static final Predicate<EntityMeta> EXCLUDE_CLUSTERED_COUNTER_FILTER = new Predicate<EntityMeta>(){

        public boolean apply(EntityMeta meta) {
            return !meta.isClusteredCounter();
        }
    };
    private ReflectionInvoker invoker = new ReflectionInvoker();
    private Class<?> entityClass;
    private String className;
    private String tableName;
    private Class<?> idClass;
    private Map<String, PropertyMeta> propertyMetas;
    private List<PropertyMeta> allMetasExceptCounters;
    private List<PropertyMeta> allMetasExceptIdAndCounters;
    private PropertyMeta idMeta;
    private Map<Method, PropertyMeta> getterMetas;
    private Map<Method, PropertyMeta> setterMetas;
    private boolean clusteredEntity = false;
    private Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels;
    private List<PropertyMeta> allMetasExceptId;
    private boolean clusteredCounter = false;
    private List<Interceptor<?>> interceptors = new ArrayList();
    private InsertStrategy insertStrategy;
    private boolean schemaUpdateEnabled = false;
    private boolean hasOnlyStaticColumns = false;

    public Object getPrimaryKey(Object entity) {
        return this.idMeta.getPrimaryKey(entity);
    }

    public void addInterceptor(Interceptor<?> interceptor) {
        this.interceptors.add(interceptor);
    }

    public List<Interceptor<?>> getInterceptors() {
        return this.interceptors;
    }

    public void intercept(Object entity, Event event) {
        List<Interceptor<?>> interceptors = this.getInterceptorsForEvent(event);
        if (interceptors.size() > 0) {
            for (Interceptor<?> interceptor : interceptors) {
                interceptor.onEvent(entity);
            }
            Validator.validateNotNull(this.getPrimaryKey(entity), "The primary key should not be null after intercepting the event '%s'", event);
        }
    }

    protected List<Interceptor<?>> getInterceptorsForEvent(Event event) {
        return FluentIterable.from(this.interceptors).filter(this.getFilterForEvent(event)).toList();
    }

    private Predicate<? super Interceptor<?>> getFilterForEvent(final Event event) {
        return new Predicate<Interceptor<?>>(){

            public boolean apply(Interceptor<?> p) {
                return p != null && p.events() != null && p.events().contains(event);
            }
        };
    }

    public Object getPartitionKey(Object compoundKey) {
        return this.idMeta.getPartitionKey(compoundKey);
    }

    public <T> T instanciate() {
        return (T)this.invoker.instantiate(this.entityClass);
    }

    public boolean hasEmbeddedId() {
        return this.idMeta.isEmbeddedId();
    }

    public <T> Class<T> getEntityClass() {
        return this.entityClass;
    }

    public void setEntityClass(Class<?> entityClass) {
        this.entityClass = entityClass;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public Map<String, PropertyMeta> getPropertyMetas() {
        return this.propertyMetas;
    }

    public void setPropertyMetas(Map<String, PropertyMeta> propertyMetas) {
        this.propertyMetas = propertyMetas;
    }

    public PropertyMeta getIdMeta() {
        return this.idMeta;
    }

    public void setIdMeta(PropertyMeta idMeta) {
        this.idMeta = idMeta;
    }

    public Map<Method, PropertyMeta> getGetterMetas() {
        return this.getterMetas;
    }

    public void setGetterMetas(Map<Method, PropertyMeta> getterMetas) {
        this.getterMetas = getterMetas;
    }

    public Map<Method, PropertyMeta> getSetterMetas() {
        return this.setterMetas;
    }

    public void setSetterMetas(Map<Method, PropertyMeta> setterMetas) {
        this.setterMetas = setterMetas;
    }

    public boolean isClusteredEntity() {
        return this.clusteredEntity;
    }

    public void setClusteredEntity(boolean clusteredEntity) {
        this.clusteredEntity = clusteredEntity;
    }

    public ConsistencyLevel getReadConsistencyLevel() {
        return (ConsistencyLevel)this.consistencyLevels.left;
    }

    public ConsistencyLevel getWriteConsistencyLevel() {
        return (ConsistencyLevel)this.consistencyLevels.right;
    }

    public Pair<ConsistencyLevel, ConsistencyLevel> getConsistencyLevels() {
        return this.consistencyLevels;
    }

    public void setConsistencyLevels(Pair<ConsistencyLevel, ConsistencyLevel> consistencyLevels) {
        this.consistencyLevels = consistencyLevels;
    }

    public InsertStrategy getInsertStrategy() {
        return this.insertStrategy;
    }

    public void setInsertStrategy(InsertStrategy insertStrategy) {
        this.insertStrategy = insertStrategy;
    }

    public boolean isSchemaUpdateEnabled() {
        return this.schemaUpdateEnabled;
    }

    public void setSchemaUpdateEnabled(boolean schemaUpdateEnabled) {
        this.schemaUpdateEnabled = schemaUpdateEnabled;
    }

    public <T> Class<T> getIdClass() {
        return this.idClass;
    }

    public void setIdClass(Class<?> idClass) {
        this.idClass = idClass;
    }

    public List<PropertyMeta> getAllMetas() {
        return new ArrayList<PropertyMeta>(this.propertyMetas.values());
    }

    public List<PropertyMeta> getAllCounterMetas() {
        return FluentIterable.from(this.propertyMetas.values()).filter((Predicate)PropertyType.counterType).toList();
    }

    public boolean isClusteredCounter() {
        return this.clusteredCounter;
    }

    public void setClusteredCounter(boolean clusteredCounter) {
        this.clusteredCounter = clusteredCounter;
    }

    public boolean isValueless() {
        return this.propertyMetas.size() == 1;
    }

    public List<PropertyMeta> getAllMetasExceptId() {
        return this.allMetasExceptId;
    }

    public void setAllMetasExceptId(List<PropertyMeta> allMetasExceptId) {
        this.allMetasExceptId = allMetasExceptId;
    }

    public List<PropertyMeta> getAllMetasExceptIdAndCounters() {
        return this.allMetasExceptIdAndCounters;
    }

    public void setAllMetasExceptIdAndCounters(List<PropertyMeta> allMetasExceptIdAndCounters) {
        this.allMetasExceptIdAndCounters = allMetasExceptIdAndCounters;
    }

    public List<PropertyMeta> getAllMetasExceptCounters() {
        return this.allMetasExceptCounters;
    }

    public void setAllMetasExceptCounters(List<PropertyMeta> allMetasExceptCounters) {
        this.allMetasExceptCounters = allMetasExceptCounters;
    }

    public boolean hasOnlyStaticColumns() {
        return this.hasOnlyStaticColumns;
    }

    public void setHasOnlyStaticColumns(boolean hasOnlyStaticColumns) {
        this.hasOnlyStaticColumns = hasOnlyStaticColumns;
    }

    public List<PropertyMeta> getColumnsMetaToInsert() {
        if (this.clusteredCounter) {
            return this.allMetasExceptId;
        }
        return this.allMetasExceptIdAndCounters;
    }

    public List<PropertyMeta> getColumnsMetaToLoad() {
        if (this.clusteredCounter) {
            return new ArrayList<PropertyMeta>(this.propertyMetas.values());
        }
        return this.allMetasExceptCounters;
    }

    public Object[] encodeBoundValuesForTypedQueries(Object[] boundValues) {
        Object[] encodedBoundValues = new Object[boundValues != null ? boundValues.length : 0];
        for (int i = 0; i < encodedBoundValues.length; ++i) {
            Object boundValue = boundValues[i];
            if (boundValue == null) continue;
            Class<?> type = boundValue.getClass();
            if (PropertyParser.isAssignableFromNativeType(type)) {
                encodedBoundValues[i] = boundValue;
                continue;
            }
            if (type.isEnum()) {
                encodedBoundValues[i] = ((Enum)boundValue).name();
                continue;
            }
            throw new AchillesException("Cannot encode value " + boundValue + " for typed query");
        }
        return encodedBoundValues;
    }

    public Object encodeCasConditionValue(Options.CASCondition CASCondition2) {
        Object rawValue = CASCondition2.getValue();
        String columnName = CASCondition2.getColumnName();
        Object encodedValue = this.encodeValueForProperty(columnName, rawValue);
        CASCondition2.encodeValue(encodedValue);
        return encodedValue;
    }

    public Object encodeIndexConditionValue(IndexCondition indexCondition) {
        Object rawValue = indexCondition.getColumnValue();
        String columnName = indexCondition.getColumnName();
        Object encodedValue = this.encodeValueForProperty(columnName, rawValue);
        indexCondition.encodeValue(encodedValue);
        return encodedValue;
    }

    private Object encodeValueForProperty(String columnName, Object rawValue) {
        Object encodedValue = rawValue;
        if (rawValue != null) {
            PropertyMeta propertyMeta = this.findPropertyMetaByCQL3Name(columnName);
            encodedValue = propertyMeta.encode(rawValue);
        }
        return encodedValue;
    }

    public List<PropertyMeta> retrievePropertyMetasForInsert(Object entity) {
        if (this.insertStrategy == InsertStrategy.ALL_FIELDS) {
            return this.getAllMetasExceptIdAndCounters();
        }
        ArrayList<PropertyMeta> metasForNonNullProperties = new ArrayList<PropertyMeta>();
        for (PropertyMeta propertyMeta : this.getAllMetasExceptIdAndCounters()) {
            if (propertyMeta.getValueFromField(entity) == null) continue;
            metasForNonNullProperties.add(propertyMeta);
        }
        return metasForNonNullProperties;
    }

    private PropertyMeta findPropertyMetaByCQL3Name(String cql3Name) {
        for (PropertyMeta meta : this.allMetasExceptCounters) {
            if (!meta.getCQL3PropertyName().equals(cql3Name)) continue;
            return meta;
        }
        throw new AchillesException(String.format("Cannot find matching property meta for the cql3 field %s", cql3Name));
    }

    public String toString() {
        ArrayList<String> propertyNames = new ArrayList<String>(this.propertyMetas.keySet());
        Collections.sort(propertyNames);
        return Objects.toStringHelper(this.getClass()).add("className", (Object)this.className).add("tableName/columnFamilyName", (Object)this.tableName).add("propertyMetas", (Object)StringUtils.join(propertyNames, (String)",")).add("idMeta", (Object)this.idMeta).add("clusteredEntity", this.clusteredEntity).add("consistencyLevels", this.consistencyLevels).toString();
    }

    public static enum EntityState {
        MANAGED(true),
        NOT_MANAGED(false);

        private final boolean managed;

        private EntityState(boolean managed) {
            this.managed = managed;
        }

        public boolean isManaged() {
            return this.managed;
        }
    }
}

