/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import com.google.common.base.Objects;
import info.archinnov.achilles.internal.metadata.holder.AbstractComponentProperties;
import info.archinnov.achilles.internal.metadata.holder.ClusteringComponents;
import info.archinnov.achilles.internal.metadata.holder.PartitionComponents;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.schemabuilder.Create;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedIdProperties
extends AbstractComponentProperties {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedIdProperties.class);
    private final PartitionComponents partitionComponents;
    private final ClusteringComponents clusteringComponents;
    private final List<String> timeUUIDComponents;

    public EmbeddedIdProperties(PartitionComponents partitionComponents, ClusteringComponents clusteringComponents, List<Class<?>> componentClasses, List<String> componentNames, List<Field> componentFields, List<Method> componentGetters, List<Method> componentSetters, List<String> timeUUIDComponents) {
        super(componentClasses, componentNames, componentFields, componentGetters, componentSetters);
        this.partitionComponents = partitionComponents;
        this.clusteringComponents = clusteringComponents;
        this.timeUUIDComponents = timeUUIDComponents;
    }

    void validatePartitionComponents(String className, List<Object> partitionComponents) {
        this.partitionComponents.validatePartitionComponents(className, partitionComponents);
    }

    void validateClusteringComponents(String className, List<Object> clusteringComponents) {
        this.clusteringComponents.validateClusteringComponents(className, clusteringComponents);
    }

    String getVaryingComponentNameForQuery(int fixedComponentsSize) {
        log.trace("Get varying component name for query");
        if (fixedComponentsSize > 0) {
            return this.getComponentNames().get(fixedComponentsSize);
        }
        return this.getClusteringComponentNames().get(0);
    }

    public boolean isCompositePartitionKey() {
        return this.partitionComponents.isComposite();
    }

    public boolean isClustered() {
        return this.clusteringComponents.isClustered();
    }

    public String getOrderingComponent() {
        return this.clusteringComponents.getOrderingComponent();
    }

    public List<Create.Options.ClusteringOrder> getCluseringOrders() {
        return this.clusteringComponents.getClusteringOrders();
    }

    public List<String> getClusteringComponentNames() {
        return this.clusteringComponents.getComponentNames();
    }

    public List<Class<?>> getClusteringComponentClasses() {
        return this.clusteringComponents.getComponentClasses();
    }

    public List<String> getPartitionComponentNames() {
        return this.partitionComponents.getComponentNames();
    }

    public List<Class<?>> getPartitionComponentClasses() {
        return this.partitionComponents.getComponentClasses();
    }

    public List<Field> getPartitionComponentFields() {
        return this.partitionComponents.getComponentFields();
    }

    public List<String> getTimeUUIDComponents() {
        return this.timeUUIDComponents;
    }

    @Override
    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("partitionComponents", (Object)this.partitionComponents).add("clusteringComponents", (Object)this.clusteringComponents).toString();
    }

    List<Object> extractPartitionComponents(List<Object> components) {
        log.trace("Extract partition key components from {}", components);
        int partitionComponentsCount = this.partitionComponents.getComponentClasses().size();
        Validator.validateTrue(components.size() >= partitionComponentsCount, "Cannot extract composite partition key components from components list '%s'", components);
        return components.subList(0, partitionComponentsCount);
    }

    List<Object> extractClusteringComponents(List<Object> components) {
        log.trace("Extract clustering components from {}", components);
        int partitionComponentsCount = this.partitionComponents.getComponentClasses().size();
        Validator.validateTrue(components.size() >= partitionComponentsCount, "Cannot extract clustering components from components list '%s'", components);
        return components.subList(partitionComponentsCount, components.size());
    }
}

