/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.metadata.holder;

import info.archinnov.achilles.exception.AchillesException;
import info.archinnov.achilles.internal.metadata.holder.AbstractComponentProperties;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.schemabuilder.Create;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;

public class ClusteringComponents
extends AbstractComponentProperties {
    private List<Create.Options.ClusteringOrder> clusteringOrders;

    public ClusteringComponents(List<Class<?>> componentClasses, List<String> componentNames, List<Field> componentFields, List<Method> componentGetters, List<Method> componentSetters, List<Create.Options.ClusteringOrder> clusteringOrders) {
        super(componentClasses, componentNames, componentFields, componentGetters, componentSetters);
        this.clusteringOrders = clusteringOrders;
    }

    void validateClusteringComponents(String className, List<Object> clusteringComponents) {
        Validator.validateNotNull(clusteringComponents, "There should be at least one clustering key provided for querying on entity '%s'", className);
        int maxClusteringCount = this.componentClasses.size();
        Validator.validateTrue(clusteringComponents.size() <= maxClusteringCount, "There should be at most %s value(s) of clustering component(s) provided for querying on entity '%s'", maxClusteringCount, className);
        this.validateNoHoleAndReturnLastNonNullIndex(clusteringComponents);
        for (int i = 0; i < clusteringComponents.size(); ++i) {
            Object clusteringKey = clusteringComponents.get(i);
            if (clusteringKey == null) continue;
            Class<?> clusteringType = clusteringKey.getClass();
            Class expectedClusteringType = (Class)this.componentClasses.get(i);
            Validator.validateComparable(clusteringType, "The type '%s' of clustering key '%s' for querying on entity '%s' should implement the Comparable<T> interface", clusteringType.getCanonicalName(), clusteringKey, className);
            Validator.validateTrue(expectedClusteringType.equals(clusteringType), "The type '%s' of clustering key '%s' for querying on entity '%s' is not valid. It should be '%s'", clusteringType.getCanonicalName(), clusteringKey, className, expectedClusteringType.getCanonicalName());
        }
    }

    String getOrderingComponent() {
        return this.isClustered() ? (String)this.componentNames.get(0) : null;
    }

    boolean isClustered() {
        return this.componentClasses.size() > 0;
    }

    public List<Create.Options.ClusteringOrder> getClusteringOrders() {
        return this.clusteringOrders;
    }

    private int validateNoHoleAndReturnLastNonNullIndex(List<Object> components) {
        boolean nullFlag = false;
        int lastNotNullIndex = 0;
        for (Object component : components) {
            if (component != null) {
                if (nullFlag) {
                    throw new AchillesException("There should not be any null value between two non-null components of an @EmbeddedId");
                }
                ++lastNotNullIndex;
                continue;
            }
            nullFlag = true;
        }
        return --lastNotNullIndex;
    }
}

