/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.TableMetadata;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.parsing.context.ParsingResult;
import info.archinnov.achilles.internal.table.TableCreator;
import info.archinnov.achilles.internal.table.TableUpdater;
import info.archinnov.achilles.internal.table.TableValidator;
import java.util.Map;
import java.util.Set;

public class SchemaContext {
    private boolean forceColumnFamilyCreation;
    private Cluster cluster;
    private Session session;
    private String keyspaceName;
    private Map<Class<?>, EntityMeta> entityMetaMap;
    private boolean hasCounter;
    private TableCreator tableCreator = new TableCreator();
    private TableValidator tableValidator = new TableValidator();
    private TableUpdater tableUpdater = new TableUpdater();

    public SchemaContext(boolean forceColumnFamilyCreation, Session session, String keyspaceName, Cluster cluster, ParsingResult parsingResult) {
        this.forceColumnFamilyCreation = forceColumnFamilyCreation;
        this.session = session;
        this.keyspaceName = keyspaceName;
        this.cluster = cluster;
        this.entityMetaMap = parsingResult.getMetaMap();
        this.hasCounter = parsingResult.hasSimpleCounter();
    }

    public Session getSession() {
        return this.session;
    }

    public boolean hasSimpleCounter() {
        return this.hasCounter;
    }

    public Set<Map.Entry<Class<?>, EntityMeta>> entityMetaEntrySet() {
        return this.entityMetaMap.entrySet();
    }

    public void validateForEntity(EntityMeta entityMeta, TableMetadata tableMetaData) {
        this.tableValidator.validateForEntity(entityMeta, tableMetaData);
    }

    public void validateAchillesCounter() {
        this.tableValidator.validateAchillesCounter(this.cluster.getMetadata().getKeyspace(this.keyspaceName), this.keyspaceName);
    }

    public Map<String, TableMetadata> fetchTableMetaData() {
        return this.tableCreator.fetchTableMetaData(this.cluster.getMetadata().getKeyspace(this.keyspaceName), this.keyspaceName);
    }

    public void createTableForEntity(EntityMeta entityMeta) {
        this.tableCreator.createTableForEntity(this.session, entityMeta, this.forceColumnFamilyCreation);
    }

    public void createTableForCounter() {
        this.tableCreator.createTableForCounter(this.session, this.forceColumnFamilyCreation);
    }

    public void updateForEntity(EntityMeta entityMeta, TableMetadata tableMetaData) {
        this.tableUpdater.updateTableForEntity(this.session, entityMeta, tableMetaData);
    }
}

