/*
 * Decompiled with CFR 0.152.
 */
package info.archinnov.achilles.internal.context;

import com.google.common.base.Optional;
import info.archinnov.achilles.internal.context.AbstractFlushContext;
import info.archinnov.achilles.internal.context.ConfigurationContext;
import info.archinnov.achilles.internal.context.DaoContext;
import info.archinnov.achilles.internal.context.ImmediateFlushContext;
import info.archinnov.achilles.internal.context.PersistenceContext;
import info.archinnov.achilles.internal.metadata.holder.EntityMeta;
import info.archinnov.achilles.internal.metadata.holder.PropertyMeta;
import info.archinnov.achilles.internal.persistence.operations.EntityProxifier;
import info.archinnov.achilles.internal.reflection.ReflectionInvoker;
import info.archinnov.achilles.internal.validation.Validator;
import info.archinnov.achilles.type.ConsistencyLevel;
import info.archinnov.achilles.type.Options;
import info.archinnov.achilles.type.OptionsBuilder;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceContextFactory {
    private static final Logger log = LoggerFactory.getLogger(PersistenceContextFactory.class);
    public static final Optional<Integer> NO_TTL = Optional.absent();
    private DaoContext daoContext;
    private ConfigurationContext configContext;
    private Map<Class<?>, EntityMeta> entityMetaMap;
    private EntityProxifier proxifier = new EntityProxifier();
    private ReflectionInvoker invoker = new ReflectionInvoker();

    public PersistenceContextFactory(DaoContext daoContext, ConfigurationContext configContext, Map<Class<?>, EntityMeta> entityMetaMap) {
        this.daoContext = daoContext;
        this.configContext = configContext;
        this.entityMetaMap = entityMetaMap;
    }

    public PersistenceContext newContext(Object entity, Options options) {
        ImmediateFlushContext flushContext = this.buildImmediateFlushContext(options);
        return this.newContextWithFlushContext(entity, options, flushContext);
    }

    public PersistenceContext newContextWithFlushContext(Object entity, Options options, AbstractFlushContext flushContext) {
        log.trace("Build new PersistenceContext for entity '{}' with options '{}' and flush context '{}'", new Object[]{entity, options, flushContext});
        Validator.validateNotNull(entity, "entity should not be null for persistence context creation", new Object[0]);
        Class entityClass = this.proxifier.deriveBaseClass(entity);
        EntityMeta meta = this.entityMetaMap.get(entityClass);
        return new PersistenceContext(meta, this.configContext, this.daoContext, flushContext, entity, options);
    }

    public PersistenceContext newContext(Object entity) {
        return this.newContext(entity, OptionsBuilder.noOptions());
    }

    public PersistenceContext newContext(Class<?> entityClass, Object primaryKey, Options options) {
        ImmediateFlushContext flushContext = this.buildImmediateFlushContext(options);
        return this.newContextWithFlushContext(entityClass, primaryKey, options, flushContext);
    }

    public PersistenceContext newContextWithFlushContext(Class<?> entityClass, Object primaryKey, Options options, AbstractFlushContext flushContext) {
        log.trace("Build new PersistenceContext for entity class '{}' with primary key '{}', options '{}' and flush context '{}'", new Object[]{entityClass, primaryKey, options, flushContext});
        Validator.validateNotNull(entityClass, "entityClass should not be null for persistence context creation", new Object[0]);
        Validator.validateNotNull(primaryKey, "primaryKey should not be null for persistence context creation", new Object[0]);
        EntityMeta meta = this.entityMetaMap.get(entityClass);
        return new PersistenceContext(meta, this.configContext, this.daoContext, flushContext, entityClass, primaryKey, options);
    }

    public PersistenceContext newContextForSliceQuery(Class<?> entityClass, List<Object> partitionComponents, ConsistencyLevel cl) {
        log.trace("Build new PersistenceContext for slice query on entity class '{}' with partition key components '{}' and Consistency Level '{}'", new Object[]{entityClass, partitionComponents, cl});
        EntityMeta meta = this.entityMetaMap.get(entityClass);
        PropertyMeta idMeta = meta.getIdMeta();
        Object embeddedId = this.invoker.instantiateEmbeddedIdWithPartitionComponents(idMeta, partitionComponents);
        ImmediateFlushContext flushContext = this.buildImmediateFlushContext(OptionsBuilder.withConsistency(cl));
        return new PersistenceContext(meta, this.configContext, this.daoContext, flushContext, entityClass, embeddedId, OptionsBuilder.withConsistency(cl));
    }

    private ImmediateFlushContext buildImmediateFlushContext(Options options) {
        return new ImmediateFlushContext(this.daoContext, (ConsistencyLevel)options.getConsistencyLevel().orNull(), options.getSerialConsistency());
    }
}

